/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util.pressure;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class Measure
implements Runnable {
    private AtomicInteger readCount = new AtomicInteger();
    private AtomicInteger writeCount = new AtomicInteger();
    private AtomicInteger failureCount = new AtomicInteger();
    private int readPeriod;
    private int writePeriod;
    private int failurePeriod;
    private SummaryStatistics readPsAvg = new SummaryStatistics();
    private SummaryStatistics respAvg = new SummaryStatistics();

    @Override
    public void run() {
        this.readPeriod = this.readCount.getAndSet(0);
        this.writePeriod = this.writeCount.getAndSet(0);
        this.failurePeriod = this.failureCount.getAndSet(0);
    }

    @ManagedOperation
    public void reset() {
        this.readCount.set(0);
        this.writeCount.set(0);
        this.failureCount.set(0);
        this.readPeriod = 0;
        this.writePeriod = 0;
        this.failurePeriod = 0;
        this.readPsAvg = new SummaryStatistics();
        this.respAvg = new SummaryStatistics();
    }

    public AtomicInteger getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(AtomicInteger failureCount) {
        this.failureCount = failureCount;
    }

    public AtomicInteger getReadCount() {
        return this.readCount;
    }

    public void setReadCount(AtomicInteger readCount) {
        this.readCount = readCount;
    }

    @ManagedAttribute
    public int getReadPeriod() {
        return this.readPeriod;
    }

    @ManagedAttribute
    public int getWritePeriod() {
        return this.writePeriod;
    }

    @ManagedAttribute
    public int getFailurePeriod() {
        return this.failurePeriod;
    }

    public SummaryStatistics getReadPsAvg() {
        return this.readPsAvg;
    }

    public SummaryStatistics getRespAvg() {
        return this.respAvg;
    }

    @ManagedAttribute
    public int getRespMean() {
        return (int)this.respAvg.getMean();
    }

    public AtomicInteger getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(AtomicInteger writeCount) {
        this.writeCount = writeCount;
    }
}

