/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndlessTask
implements Runnable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Runnable runnable;
    private int sleepTime;
    private boolean breakOnException;
    private boolean shutdown;

    public EndlessTask(Runnable runnable) {
        this(runnable, 0, false);
    }

    public EndlessTask(Runnable runnable, int sleepTime) {
        this(runnable, sleepTime, false);
    }

    public EndlessTask(Runnable runnable, int sleepTime, boolean breakOnException) {
        this.runnable = runnable;
        this.sleepTime = sleepTime;
        this.breakOnException = breakOnException;
    }

    public void ready() {
        this.shutdown = false;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                try {
                    this.runnable.run();
                }
                catch (RuntimeException e) {
                    if (this.breakOnException) {
                        throw e;
                    }
                    this.logger.warn(null, (Throwable)e);
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.logger.info("interrupted");
                } else {
                    if (this.sleepTime <= 0) continue;
                    if (!this.shutdown) {
                        Thread.sleep(this.sleepTime);
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.logger.info(e.getMessage());
        }
    }
}

