/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.memstat.inbound;

import com.godmonth.memstat.model.Item;
import com.godmonth.util.StringConverter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemFactory {
    private static final Logger logger = LoggerFactory.getLogger(ItemFactory.class);

    public static List<Item> read(Map<String, String> stats, Map<Long, Long> idSizeMappings) {
        HashMap<String, Item> items = new HashMap<String, Item>();
        for (String string : stats.keySet()) {
            String[] sign = StringUtils.split((String)string, (char)':');
            if (sign.length != 3) {
                logger.trace(string);
                continue;
            }
            String key = sign[1];
            Item item = (Item)items.get(key);
            if (item == null) {
                item = new Item();
                item.setId(Long.parseLong(key));
                item.setChunkSize(idSizeMappings.get(item.getId()));
                items.put(key, item);
            }
            try {
                BeanUtils.setProperty((Object)item, (String)StringConverter.dbColumn2BeanProperty((String)sign[2]), (Object)stats.get(string));
            }
            catch (Exception e) {}
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(items.values());
        Collections.sort(arrayList, new BeanComparator("id"));
        return arrayList;
    }

    public static List<Item> read(List<String> readLines, Map<Long, Long> idSizeMappings) {
        HashMap<String, Item> items = new HashMap<String, Item>();
        for (String string : readLines) {
            String[] split;
            String[] aaa = StringUtils.split((String)string, (char)':');
            if (aaa.length != 3) {
                logger.trace(string);
                continue;
            }
            String key = aaa[1];
            Item item = (Item)items.get(key);
            if (item == null) {
                item = new Item();
                item.setId(Long.parseLong(key));
                item.setChunkSize(idSizeMappings.get(item.getId()));
                items.put(key, item);
            }
            if ((split = aaa[2].split(" ")).length != 2) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace(ArrayUtils.toString((Object)split));
                continue;
            }
            try {
                BeanUtils.setProperty((Object)item, (String)StringConverter.dbColumn2BeanProperty((String)split[0]), (Object)split[1]);
            }
            catch (Exception e) {}
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(items.values());
        Collections.sort(arrayList, new BeanComparator("id"));
        return arrayList;
    }

    public static List<Item> read(InputStream is, Map<Long, Long> idSizeMappings) throws FileNotFoundException, IOException {
        return ItemFactory.read(IOUtils.readLines((InputStream)is), idSizeMappings);
    }
}

