/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.memstat.outbound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.util.Rotation;

public class Output {
    public static void write2File(JFreeChart chart, String file, int width, int height) throws FileNotFoundException, IOException {
        FileUtils.deleteQuietly((File)new File(file));
        ChartUtilities.writeChartAsPNG((OutputStream)new FileOutputStream(file), (JFreeChart)chart, (int)width, (int)height);
    }

    public static void writePngOnePie(JFreeChart chart, String file, int width, int height) throws FileNotFoundException, IOException {
        Output.setLabelAndLegend((PiePlot)chart.getPlot());
        Output.write2File(chart, file, width, height);
    }

    private static void setLabelAndLegend(PiePlot plot) {
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}:{1}:{2}"));
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("size:{0}"));
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
    }

    public static void writePngMultiPie(JFreeChart chart, String file, int width, int height) throws FileNotFoundException, IOException {
        MultiplePiePlot plot = (MultiplePiePlot)chart.getPlot();
        JFreeChart subchart = plot.getPieChart();
        Output.setLabelAndLegend((PiePlot)subchart.getPlot());
        Output.write2File(chart, file, width, height);
    }
}

