/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.memstat.stat;

import com.godmonth.memstat.model.Chunk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class ChunkStats {
    private List<Chunk> datas;

    public ChunkStats(List<Chunk> datas) {
        this.datas = datas;
    }

    public Map<Long, Long> getIdSizeMappings() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (Chunk chunk : this.datas) {
            result.put(chunk.getId(), chunk.getChunkSize());
        }
        return result;
    }

    public JFreeChart createMultiPie(String title, String ... propertyNames) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Chunk chunk : this.datas) {
            String row = String.valueOf(chunk.getChunkSize());
            for (String propertyName : propertyNames) {
                try {
                    dataset.addValue((Number)((Long)PropertyUtils.getProperty((Object)chunk, (String)propertyName)), (Comparable)((Object)row), (Comparable)((Object)propertyName));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ChartFactory.createMultiplePieChart3D((String)title, (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart createPie(String propertyName) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Chunk chunk : this.datas) {
            try {
                dataset.setValue((Comparable)((Object)(chunk.getChunkSize() + "")), (Number)((Long)PropertyUtils.getProperty((Object)chunk, (String)propertyName)));
            }
            catch (Exception e) {}
        }
        return ChartFactory.createPieChart3D((String)("chunk " + propertyName), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart createBarChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Chunk chunk : this.datas) {
            String row = chunk.getId() + ":" + chunk.getChunkSize();
            dataset.addValue((double)chunk.getTotalChunks(), (Comparable)((Object)row), (Comparable)((Object)"totalChunks"));
            dataset.addValue((double)chunk.getMemRequested(), (Comparable)((Object)row), (Comparable)((Object)"mmRequested"));
        }
        return ChartFactory.createBarChart((String)"Bar Chart Demo", (String)"Category", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }
}

