/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.memstat.stat;

import com.godmonth.memstat.model.Item;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ItemStats {
    private List<Item> items;
    private final long createTime;

    public ItemStats(List<Item> items, long createTime) {
        this.items = items;
        this.createTime = createTime;
    }

    public JFreeChart createBarEvict(String title) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Item item : this.items) {
            try {
                Long amount = (Long)PropertyUtils.getProperty((Object)item, (String)"evicted");
                dataset.addValue((Number)amount, (Comparable)((Object)"evicted"), (Comparable)((Object)String.valueOf(item.getChunkSize())));
            }
            catch (Exception e) {}
        }
        return ChartFactory.createBarChart((String)title, (String)"chunksize", (String)"amount", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart createBarAgeEt(String title) {
        long current = System.currentTimeMillis() / 1000L;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Item item : this.items) {
            try {
                Long seconds = (Long)PropertyUtils.getProperty((Object)item, (String)"age");
                long period = current - (this.createTime + seconds);
                int days = (int)(period / 60L / 60L / 24L);
                dataset.addValue((Number)new Integer(days), (Comparable)((Object)"age"), (Comparable)((Object)String.valueOf(item.getChunkSize())));
                Long duration = (Long)PropertyUtils.getProperty((Object)item, (String)"evictedTime");
                dataset.addValue((Number)new Integer(duration.intValue() / 60 / 60 / 24), (Comparable)((Object)"evictedTime"), (Comparable)((Object)String.valueOf(item.getChunkSize())));
            }
            catch (Exception e) {}
        }
        return ChartFactory.createBarChart((String)title, (String)"chunksize", (String)"day", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }
}

