/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.keepalive;

import androidx.annotation.VisibleForTesting;
import com.gojek.keepalive.AdaptiveKeepAliveState;
import com.gojek.keepalive.model.KeepAlivePersistenceModel;
import com.gojek.keepalive.persistence.KeepAlivePersistence;
import com.gojek.mqtt.pingsender.KeepAlive;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0016J\u0016\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001bJ\u0006\u0010(\u001a\u00020\u0013J\r\u0010)\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0016J\u000e\u0010,\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0016J\u0006\u0010-\u001a\u00020\u0013J\u0006\u0010.\u001a\u00020\u0013J\u0006\u0010/\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Lcom/gojek/keepalive/AdaptiveKeepAliveStateHandler;", "", "lowerBound", "", "upperBound", "step", "optimalKeepAliveResetLimit", "persistence", "Lcom/gojek/keepalive/persistence/KeepAlivePersistence;", "(IIIILcom/gojek/keepalive/persistence/KeepAlivePersistence;)V", "state", "Lcom/gojek/keepalive/AdaptiveKeepAliveState;", "getState$adaptive_keep_alive_release$annotations", "()V", "getState$adaptive_keep_alive_release", "()Lcom/gojek/keepalive/AdaptiveKeepAliveState;", "setState$adaptive_keep_alive_release", "(Lcom/gojek/keepalive/AdaptiveKeepAliveState;)V", "calculateNextKeepAlive", "", "getConvergenceTime", "getCurrentKeepAlive", "Lcom/gojek/mqtt/pingsender/KeepAlive;", "getKeepAlivePersistenceModel", "Lcom/gojek/keepalive/model/KeepAlivePersistenceModel;", "getKeepAlivePersistenceModel$adaptive_keep_alive_release", "getNetworkKey", "", "getNetworkKey$adaptive_keep_alive_release", "getOptimalKeepAlive", "getProbeCount", "isCurrentKeepAliveFailureLimitExceeded", "", "isOptimalKeepAliveFailureLimitExceeded", "isOptimalKeepAliveFound", "isValidKeepAlive", "keepAlive", "onNetworkChanged", "networkType", "networkName", "removeStateFromPersistence", "resetState", "resetState$adaptive_keep_alive_release", "updateKeepAliveFailureState", "updateKeepAliveSuccessState", "updateOptimalKeepAliveFailureState", "updatePersistenceWithLatestState", "updateProbeCountAndConvergenceTime", "Companion", "adaptive-keep-alive_release"})
public final class AdaptiveKeepAliveStateHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeepAlivePersistence persistence;
    @NotNull
    private volatile AdaptiveKeepAliveState state;
    public static final int MAX_CURRENT_KEEPALIVE_FAILURE = 3;

    public AdaptiveKeepAliveStateHandler(int lowerBound, int upperBound, int step, int optimalKeepAliveResetLimit, @NotNull KeepAlivePersistence persistence) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        this.persistence = persistence;
        int n = lowerBound - step;
        this.state = new AdaptiveKeepAliveState(n, false, 0, upperBound, step, -1, "", -1, 0, 0, 0, lowerBound, upperBound, step, optimalKeepAliveResetLimit);
    }

    public /* synthetic */ AdaptiveKeepAliveStateHandler(int n, int n2, int n3, int n4, KeepAlivePersistence keepAlivePersistence, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 1;
        }
        this(n, n2, n3, n4, keepAlivePersistence);
    }

    @NotNull
    public final AdaptiveKeepAliveState getState$adaptive_keep_alive_release() {
        return this.state;
    }

    public final void setState$adaptive_keep_alive_release(@NotNull AdaptiveKeepAliveState adaptiveKeepAliveState) {
        Intrinsics.checkNotNullParameter((Object)adaptiveKeepAliveState, (String)"<set-?>");
        this.state = adaptiveKeepAliveState;
    }

    @VisibleForTesting
    public static /* synthetic */ void getState$adaptive_keep_alive_release$annotations() {
    }

    public final void onNetworkChanged(int networkType, @NotNull String networkName) {
        Intrinsics.checkNotNullParameter((Object)networkName, (String)"networkName");
        String string = networkName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string;
        int n = 0;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String nwName = string3;
        if (!Intrinsics.areEqual((Object)this.state.getCurrentNetworkName(), (Object)nwName) || this.state.getCurrentNetworkType() != networkType) {
            this.resetState$adaptive_keep_alive_release();
            this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, false, 0, 0, 0, networkType, nwName, 0, 0, 0, 0, 0, 0, 0, 0, 32671, null);
            if (this.persistence.has(this.getNetworkKey$adaptive_keep_alive_release())) {
                KeepAlivePersistenceModel keepAlive = this.persistence.get(this.getNetworkKey$adaptive_keep_alive_release());
                int currentUpperBound = keepAlive.getCurrentUpperBound() > 0 ? keepAlive.getCurrentUpperBound() : keepAlive.getUpperBound();
                AdaptiveKeepAliveState adaptiveKeepAliveState = this.state;
                int n2 = keepAlive.getLastSuccessfulKeepAlive();
                n = keepAlive.isOptimalKeepAlive();
                int n3 = keepAlive.getStep();
                int n4 = keepAlive.getUnderTrialKeepAlive();
                int n5 = keepAlive.getKeepAliveFailureCount();
                int n6 = keepAlive.getProbeCount();
                int n7 = keepAlive.getConvergenceTime();
                this.state = AdaptiveKeepAliveState.copy$default(adaptiveKeepAliveState, n2, n != 0, 0, currentUpperBound, n3, 0, null, n4, n5, n6, n7, 0, 0, 0, 0, 30820, null);
                if (keepAlive.getUpperBound() != this.state.getUpperBound()) {
                    adaptiveKeepAliveState = this.state;
                    n2 = this.state.getUpperBound();
                    n = this.state.getStep();
                    this.state = AdaptiveKeepAliveState.copy$default(adaptiveKeepAliveState, 0, false, 0, n2, n, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 31205, null);
                }
                if (keepAlive.getLowerBound() != this.state.getLowerBound()) {
                    adaptiveKeepAliveState = this.state;
                    n2 = this.state.getStep();
                    this.state = AdaptiveKeepAliveState.copy$default(adaptiveKeepAliveState, 0, false, 0, 0, n2, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 31213, null);
                }
            } else {
                this.resetState$adaptive_keep_alive_release();
            }
        }
    }

    public final void updateKeepAliveSuccessState(@NotNull KeepAlive keepAlive) {
        Intrinsics.checkNotNullParameter((Object)keepAlive, (String)"keepAlive");
        this.state = AdaptiveKeepAliveState.copy$default(this.state, keepAlive.getKeepAliveMinutes(), false, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32510, null);
        if (this.state.getLastSuccessfulKA() == this.state.getCurrentUpperBound()) {
            this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, true, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32765, null);
        }
    }

    public final void updateKeepAliveFailureState(@NotNull KeepAlive keepAlive) {
        Intrinsics.checkNotNullParameter((Object)keepAlive, (String)"keepAlive");
        if (keepAlive.getKeepAliveMinutes() == this.state.getLowerBound()) {
            AdaptiveKeepAliveState adaptiveKeepAliveState = this.state;
            int n = this.state.getLowerBound();
            this.state = AdaptiveKeepAliveState.copy$default(adaptiveKeepAliveState, n, true, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32508, null);
        } else {
            int currentUpperBound = keepAlive.getKeepAliveMinutes() - 1;
            if (this.state.getLastSuccessfulKA() == currentUpperBound) {
                this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, true, 0, currentUpperBound, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32501, null);
            } else if (this.state.getCurrentStep() > 1) {
                this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, false, 0, currentUpperBound, this.state.getCurrentStep() / 2, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32487, null);
            }
        }
    }

    public final void updateOptimalKeepAliveFailureState() {
        this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, false, this.state.getOptimalKAFailureCount() + 1, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 32763, null);
    }

    public final void updatePersistenceWithLatestState() {
        this.persistence.put(this.getNetworkKey$adaptive_keep_alive_release(), this.getKeepAlivePersistenceModel$adaptive_keep_alive_release());
    }

    public final void removeStateFromPersistence() {
        this.persistence.remove(this.getNetworkKey$adaptive_keep_alive_release());
    }

    @NotNull
    public final KeepAlive getCurrentKeepAlive() {
        return new KeepAlive(this.state.getCurrentNetworkType(), this.state.getCurrentNetworkName(), this.state.getCurrentKA());
    }

    public final void calculateNextKeepAlive() {
        int n = this.state.getLastSuccessfulKA() + this.state.getCurrentStep();
        int n2 = this.state.getCurrentUpperBound();
        boolean bl = false;
        int keepAlive = Math.min(n, n2);
        this.state = keepAlive == this.state.getCurrentKA() ? AdaptiveKeepAliveState.copy$default(this.state, 0, false, 0, 0, 0, 0, null, 0, this.state.getCurrentKAFailureCount() + 1, 0, 0, 0, 0, 0, 0, 32511, null) : AdaptiveKeepAliveState.copy$default(this.state, 0, false, 0, 0, 0, 0, null, keepAlive, 0, 0, 0, 0, 0, 0, 0, 32383, null);
    }

    public final boolean isCurrentKeepAliveFailureLimitExceeded() {
        return this.state.getCurrentKAFailureCount() >= 3;
    }

    public final boolean isOptimalKeepAliveFailureLimitExceeded() {
        return this.state.getOptimalKAFailureCount() >= this.state.getOptimalKeepAliveResetLimit();
    }

    public final boolean isOptimalKeepAliveFound() {
        return this.state.isOptimalKeepAlive();
    }

    @NotNull
    public final KeepAlive getOptimalKeepAlive() {
        return new KeepAlive(this.state.getCurrentNetworkType(), this.state.getCurrentNetworkName(), this.state.getLastSuccessfulKA());
    }

    public final int getProbeCount() {
        return this.state.getProbeCount();
    }

    public final int getConvergenceTime() {
        return this.state.getConvergenceTime();
    }

    public final void updateProbeCountAndConvergenceTime() {
        this.state = AdaptiveKeepAliveState.copy$default(this.state, 0, false, 0, 0, 0, 0, null, 0, 0, this.state.getProbeCount() + 1, this.state.getConvergenceTime() + this.state.getCurrentKA(), 0, 0, 0, 0, 31231, null);
    }

    public final boolean isValidKeepAlive(@NotNull KeepAlive keepAlive) {
        Intrinsics.checkNotNullParameter((Object)keepAlive, (String)"keepAlive");
        return keepAlive.getNetworkType() == this.state.getCurrentNetworkType() && Intrinsics.areEqual((Object)keepAlive.getNetworkName(), (Object)this.state.getCurrentNetworkName()) && keepAlive.getKeepAliveMinutes() == this.state.getCurrentKA();
    }

    @VisibleForTesting
    public final void resetState$adaptive_keep_alive_release() {
        this.state = AdaptiveKeepAliveState.copy$default(this.state, this.state.getLowerBound() - this.state.getStep(), false, 0, this.state.getUpperBound(), this.state.getStep(), 0, null, -1, 0, 0, 0, 0, 0, 0, 0, 30820, null);
    }

    @VisibleForTesting
    @NotNull
    public final String getNetworkKey$adaptive_keep_alive_release() {
        return "" + this.state.getCurrentNetworkType() + ':' + this.state.getCurrentNetworkName();
    }

    @VisibleForTesting
    @NotNull
    public final KeepAlivePersistenceModel getKeepAlivePersistenceModel$adaptive_keep_alive_release() {
        AdaptiveKeepAliveState adaptiveKeepAliveState = this.state;
        boolean bl = false;
        boolean bl2 = false;
        AdaptiveKeepAliveState $this$getKeepAlivePersistenceModel_u24lambda_u2d0 = adaptiveKeepAliveState;
        boolean bl3 = false;
        int n = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getLastSuccessfulKA();
        int n2 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentNetworkType();
        String string = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentNetworkName();
        int n3 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getLowerBound();
        int n4 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getUpperBound();
        int n5 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentUpperBound();
        boolean bl4 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.isOptimalKeepAlive();
        int n6 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentStep();
        int n7 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentKA();
        int n8 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getCurrentKAFailureCount();
        int n9 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getProbeCount();
        int n10 = $this$getKeepAlivePersistenceModel_u24lambda_u2d0.getConvergenceTime();
        return new KeepAlivePersistenceModel(n, n7, n8, n2, string, n3, n4, n5, n6, bl4, n9, n10);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/gojek/keepalive/AdaptiveKeepAliveStateHandler$Companion;", "", "()V", "MAX_CURRENT_KEEPALIVE_FAILURE", "", "getMAX_CURRENT_KEEPALIVE_FAILURE$adaptive_keep_alive_release$annotations", "adaptive-keep-alive_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_CURRENT_KEEPALIVE_FAILURE$adaptive_keep_alive_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

