/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.keepalive;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.gojek.keepalive.AdaptiveKeepAliveStateHandler;
import com.gojek.keepalive.OptimalKeepAliveCalculator;
import com.gojek.keepalive.OptimalKeepAliveObserver;
import com.gojek.keepalive.config.AdaptiveKeepAliveConfig;
import com.gojek.keepalive.persistence.KeepAlivePersistenceImpl;
import com.gojek.keepalive.sharedpref.CourierSharedPreferences;
import com.gojek.keepalive.sharedpref.CourierSharedPreferencesFactory;
import com.gojek.keepalive.utils.NetworkUtils;
import com.gojek.mqtt.pingsender.KeepAliveCalculator;
import com.gojek.networktracker.NetworkStateTrackerFactory;
import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/gojek/keepalive/KeepAliveCalculatorFactory;", "", "()V", "create", "Lcom/gojek/mqtt/pingsender/KeepAliveCalculator;", "context", "Landroid/content/Context;", "adaptiveKeepAliveConfig", "Lcom/gojek/keepalive/config/AdaptiveKeepAliveConfig;", "optimalKeepAliveObserver", "Lcom/gojek/keepalive/OptimalKeepAliveObserver;", "adaptive-keep-alive_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class KeepAliveCalculatorFactory {
    @NotNull
    public final KeepAliveCalculator create(@NotNull Context context, @NotNull AdaptiveKeepAliveConfig adaptiveKeepAliveConfig, @NotNull OptimalKeepAliveObserver optimalKeepAliveObserver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adaptiveKeepAliveConfig, (String)"adaptiveKeepAliveConfig");
        Intrinsics.checkNotNullParameter((Object)optimalKeepAliveObserver, (String)"optimalKeepAliveObserver");
        CourierSharedPreferences sharedPreferences = CourierSharedPreferencesFactory.Companion.create(context, "KeepAlivePersistence");
        AdaptiveKeepAliveStateHandler stateHandler = new AdaptiveKeepAliveStateHandler(adaptiveKeepAliveConfig.getLowerBoundMinutes(), adaptiveKeepAliveConfig.getUpperBoundMinutes(), adaptiveKeepAliveConfig.getStepMinutes(), adaptiveKeepAliveConfig.getOptimalKeepAliveResetLimit(), new KeepAlivePersistenceImpl(sharedPreferences, new Gson()));
        return new OptimalKeepAliveCalculator(NetworkStateTrackerFactory.Companion.create$default((NetworkStateTrackerFactory.Companion)NetworkStateTrackerFactory.Companion, (Context)context, null, (int)2, null), new NetworkUtils(), stateHandler, optimalKeepAliveObserver);
    }
}

