/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.keepalive;

import androidx.annotation.VisibleForTesting;
import com.gojek.keepalive.AdaptiveKeepAliveStateHandler;
import com.gojek.keepalive.OptimalKeepAliveObserver;
import com.gojek.keepalive.utils.NetworkUtils;
import com.gojek.mqtt.pingsender.KeepAlive;
import com.gojek.mqtt.pingsender.KeepAliveCalculator;
import com.gojek.networktracker.NetworkStateListener;
import com.gojek.networktracker.NetworkStateTracker;
import com.gojek.networktracker.model.NetworkState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u001c\u0010\u000b\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/gojek/keepalive/OptimalKeepAliveCalculator;", "Lcom/gojek/mqtt/pingsender/KeepAliveCalculator;", "networkTracker", "Lcom/gojek/networktracker/NetworkStateTracker;", "networkUtils", "Lcom/gojek/keepalive/utils/NetworkUtils;", "stateHandler", "Lcom/gojek/keepalive/AdaptiveKeepAliveStateHandler;", "optimalKeepAliveObserver", "Lcom/gojek/keepalive/OptimalKeepAliveObserver;", "(Lcom/gojek/networktracker/NetworkStateTracker;Lcom/gojek/keepalive/utils/NetworkUtils;Lcom/gojek/keepalive/AdaptiveKeepAliveStateHandler;Lcom/gojek/keepalive/OptimalKeepAliveObserver;)V", "networkStateListener", "Lcom/gojek/networktracker/NetworkStateListener;", "getNetworkStateListener$adaptive_keep_alive_release$annotations", "()V", "getNetworkStateListener$adaptive_keep_alive_release", "()Lcom/gojek/networktracker/NetworkStateListener;", "calculateKeepAlive", "Lcom/gojek/mqtt/pingsender/KeepAlive;", "getOptimalKeepAlive", "", "getUnderTrialKeepAlive", "onKeepAliveFailure", "", "keepAlive", "onKeepAliveSuccess", "onNetworkStateChanged", "networkType", "networkName", "", "onOptimalKeepAliveFailure", "adaptive-keep-alive_release"})
public final class OptimalKeepAliveCalculator
implements KeepAliveCalculator {
    @NotNull
    private final NetworkUtils networkUtils;
    @NotNull
    private final AdaptiveKeepAliveStateHandler stateHandler;
    @NotNull
    private final OptimalKeepAliveObserver optimalKeepAliveObserver;
    @NotNull
    private final NetworkStateListener networkStateListener;

    public OptimalKeepAliveCalculator(@NotNull NetworkStateTracker networkTracker, @NotNull NetworkUtils networkUtils, @NotNull AdaptiveKeepAliveStateHandler stateHandler, @NotNull OptimalKeepAliveObserver optimalKeepAliveObserver) {
        Intrinsics.checkNotNullParameter((Object)networkTracker, (String)"networkTracker");
        Intrinsics.checkNotNullParameter((Object)networkUtils, (String)"networkUtils");
        Intrinsics.checkNotNullParameter((Object)stateHandler, (String)"stateHandler");
        Intrinsics.checkNotNullParameter((Object)optimalKeepAliveObserver, (String)"optimalKeepAliveObserver");
        this.networkUtils = networkUtils;
        this.stateHandler = stateHandler;
        this.optimalKeepAliveObserver = optimalKeepAliveObserver;
        this.networkStateListener = new NetworkStateListener(this){
            final /* synthetic */ OptimalKeepAliveCalculator this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStateChanged(@NotNull NetworkState activeNetworkState) {
                Intrinsics.checkNotNullParameter((Object)activeNetworkState, (String)"activeNetworkState");
                OptimalKeepAliveCalculator optimalKeepAliveCalculator = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    if (activeNetworkState.isConnected()) {
                        int networkType = OptimalKeepAliveCalculator.access$getNetworkUtils$p(optimalKeepAliveCalculator).getNetworkType$adaptive_keep_alive_release(activeNetworkState.getNetInfo());
                        String networkName = OptimalKeepAliveCalculator.access$getNetworkUtils$p(optimalKeepAliveCalculator).getNetworkName(activeNetworkState.getNetInfo());
                        OptimalKeepAliveCalculator.access$onNetworkStateChanged(optimalKeepAliveCalculator, networkType, networkName);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        networkTracker.addListener(this.networkStateListener);
    }

    @NotNull
    public final NetworkStateListener getNetworkStateListener$adaptive_keep_alive_release() {
        return this.networkStateListener;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNetworkStateListener$adaptive_keep_alive_release$annotations() {
    }

    private final synchronized void onNetworkStateChanged(int networkType, String networkName) {
        this.stateHandler.onNetworkChanged(networkType, networkName);
    }

    @NotNull
    public synchronized KeepAlive getUnderTrialKeepAlive() {
        return this.stateHandler.isOptimalKeepAliveFound() ? this.stateHandler.getOptimalKeepAlive() : this.calculateKeepAlive();
    }

    private final KeepAlive calculateKeepAlive() {
        KeepAlive keepAlive;
        this.stateHandler.calculateNextKeepAlive();
        if (this.stateHandler.isCurrentKeepAliveFailureLimitExceeded()) {
            this.onKeepAliveFailure(this.stateHandler.getCurrentKeepAlive());
            keepAlive = this.getUnderTrialKeepAlive();
        } else {
            this.stateHandler.updateProbeCountAndConvergenceTime();
            this.stateHandler.updatePersistenceWithLatestState();
            keepAlive = this.stateHandler.getCurrentKeepAlive();
        }
        return keepAlive;
    }

    public synchronized void onKeepAliveSuccess(@NotNull KeepAlive keepAlive) {
        Intrinsics.checkNotNullParameter((Object)keepAlive, (String)"keepAlive");
        if (this.stateHandler.isValidKeepAlive(keepAlive)) {
            this.stateHandler.updateKeepAliveSuccessState(keepAlive);
            if (this.stateHandler.isOptimalKeepAliveFound()) {
                this.optimalKeepAliveObserver.onOptimalKeepAliveFound(this.stateHandler.getOptimalKeepAlive().getKeepAliveMinutes(), this.stateHandler.getProbeCount(), this.stateHandler.getConvergenceTime());
            }
            this.stateHandler.updatePersistenceWithLatestState();
        }
    }

    public synchronized void onKeepAliveFailure(@NotNull KeepAlive keepAlive) {
        Intrinsics.checkNotNullParameter((Object)keepAlive, (String)"keepAlive");
        if (this.stateHandler.isValidKeepAlive(keepAlive)) {
            this.stateHandler.updateKeepAliveFailureState(keepAlive);
            if (this.stateHandler.isOptimalKeepAliveFound()) {
                this.optimalKeepAliveObserver.onOptimalKeepAliveFound(this.stateHandler.getOptimalKeepAlive().getKeepAliveMinutes(), this.stateHandler.getProbeCount(), this.stateHandler.getConvergenceTime());
            }
            this.stateHandler.updatePersistenceWithLatestState();
        }
    }

    public synchronized int getOptimalKeepAlive() {
        if (!this.stateHandler.isOptimalKeepAliveFound()) {
            return 0;
        }
        return this.stateHandler.getOptimalKeepAlive().getKeepAliveMinutes();
    }

    public synchronized void onOptimalKeepAliveFailure() {
        if (this.stateHandler.isOptimalKeepAliveFound()) {
            this.stateHandler.updateOptimalKeepAliveFailureState();
            if (this.stateHandler.isOptimalKeepAliveFailureLimitExceeded()) {
                this.stateHandler.removeStateFromPersistence();
            }
        }
    }

    public static final /* synthetic */ NetworkUtils access$getNetworkUtils$p(OptimalKeepAliveCalculator $this) {
        return $this.networkUtils;
    }

    public static final /* synthetic */ void access$onNetworkStateChanged(OptimalKeepAliveCalculator $this, int networkType, String networkName) {
        $this.onNetworkStateChanged(networkType, networkName);
    }
}

