/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.keepalive;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.gojek.courier.extensions.TimeUnitExtensionsKt;
import com.gojek.keepalive.KeepAliveCalculatorFactory;
import com.gojek.keepalive.OptimalKeepAliveObserver;
import com.gojek.keepalive.config.AdaptiveKeepAliveConfig;
import com.gojek.mqtt.pingsender.KeepAliveCalculator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/gojek/keepalive/OptimalKeepAliveProvider;", "", "context", "Landroid/content/Context;", "adaptiveKeepAliveConfig", "Lcom/gojek/keepalive/config/AdaptiveKeepAliveConfig;", "optimalKeepAliveObserver", "Lcom/gojek/keepalive/OptimalKeepAliveObserver;", "keepAliveCalculatorFactory", "Lcom/gojek/keepalive/KeepAliveCalculatorFactory;", "(Landroid/content/Context;Lcom/gojek/keepalive/config/AdaptiveKeepAliveConfig;Lcom/gojek/keepalive/OptimalKeepAliveObserver;Lcom/gojek/keepalive/KeepAliveCalculatorFactory;)V", "keepAliveCalculator", "Lcom/gojek/mqtt/pingsender/KeepAliveCalculator;", "getKeepAliveCalculator", "()Lcom/gojek/mqtt/pingsender/KeepAliveCalculator;", "getOptimalKASecondsForCurrentNetwork", "", "onOptimalKeepAliveFailure", "", "onOptimalKeepAliveFailure$adaptive_keep_alive_release", "adaptive-keep-alive_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class OptimalKeepAliveProvider {
    @NotNull
    private final KeepAliveCalculator keepAliveCalculator;

    public OptimalKeepAliveProvider(@NotNull Context context, @NotNull AdaptiveKeepAliveConfig adaptiveKeepAliveConfig, @NotNull OptimalKeepAliveObserver optimalKeepAliveObserver, @NotNull KeepAliveCalculatorFactory keepAliveCalculatorFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adaptiveKeepAliveConfig, (String)"adaptiveKeepAliveConfig");
        Intrinsics.checkNotNullParameter((Object)optimalKeepAliveObserver, (String)"optimalKeepAliveObserver");
        Intrinsics.checkNotNullParameter((Object)keepAliveCalculatorFactory, (String)"keepAliveCalculatorFactory");
        this.keepAliveCalculator = keepAliveCalculatorFactory.create(context, adaptiveKeepAliveConfig, optimalKeepAliveObserver);
    }

    public /* synthetic */ OptimalKeepAliveProvider(Context context, AdaptiveKeepAliveConfig adaptiveKeepAliveConfig, OptimalKeepAliveObserver optimalKeepAliveObserver, KeepAliveCalculatorFactory keepAliveCalculatorFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            keepAliveCalculatorFactory = new KeepAliveCalculatorFactory();
        }
        this(context, adaptiveKeepAliveConfig, optimalKeepAliveObserver, keepAliveCalculatorFactory);
    }

    @NotNull
    public final KeepAliveCalculator getKeepAliveCalculator() {
        return this.keepAliveCalculator;
    }

    public final int getOptimalKASecondsForCurrentNetwork() {
        return (int)TimeUnitExtensionsKt.fromMinutesToSeconds((int)this.keepAliveCalculator.getOptimalKeepAlive());
    }

    public final void onOptimalKeepAliveFailure$adaptive_keep_alive_release() {
        this.keepAliveCalculator.onOptimalKeepAliveFailure();
    }
}

