/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.courier.authhttp;

import com.gojek.courier.authhttp.handler.ResponseHandler;
import com.gojek.courier.authhttp.retry.AuthRetryPolicy;
import com.gojek.courier.authhttp.service.ApiService;
import com.gojek.courier.exception.AuthApiException;
import com.gojek.courier.extensions.TimeUnitExtensionsKt;
import com.gojek.courier.utils.Clock;
import com.gojek.mqtt.auth.Authenticator;
import com.gojek.mqtt.event.EventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.model.MqttConnectOptions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/gojek/courier/authhttp/HttpAuthenticator;", "Lcom/gojek/mqtt/auth/Authenticator;", "apiService", "Lcom/gojek/courier/authhttp/service/ApiService;", "apiUrl", "", "responseHandler", "Lcom/gojek/courier/authhttp/handler/ResponseHandler;", "authRetryPolicy", "Lcom/gojek/courier/authhttp/retry/AuthRetryPolicy;", "eventHandler", "Lcom/gojek/mqtt/event/EventHandler;", "clock", "Lcom/gojek/courier/utils/Clock;", "headerMap", "", "(Lcom/gojek/courier/authhttp/service/ApiService;Ljava/lang/String;Lcom/gojek/courier/authhttp/handler/ResponseHandler;Lcom/gojek/courier/authhttp/retry/AuthRetryPolicy;Lcom/gojek/mqtt/event/EventHandler;Lcom/gojek/courier/utils/Clock;Ljava/util/Map;)V", "authenticate", "Lcom/gojek/mqtt/model/MqttConnectOptions;", "connectOptions", "forceRefresh", "", "parseException", "Lcom/gojek/courier/exception/AuthApiException;", "throwable", "", "courier-auth-http_release"})
public final class HttpAuthenticator
implements Authenticator {
    @NotNull
    private final ApiService apiService;
    @NotNull
    private final String apiUrl;
    @NotNull
    private final ResponseHandler responseHandler;
    @NotNull
    private final AuthRetryPolicy authRetryPolicy;
    @NotNull
    private final EventHandler eventHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Map<String, String> headerMap;

    public HttpAuthenticator(@NotNull ApiService apiService, @NotNull String apiUrl, @NotNull ResponseHandler responseHandler, @NotNull AuthRetryPolicy authRetryPolicy, @NotNull EventHandler eventHandler, @NotNull Clock clock, @NotNull Map<String, String> headerMap) {
        Intrinsics.checkNotNullParameter((Object)apiService, (String)"apiService");
        Intrinsics.checkNotNullParameter((Object)apiUrl, (String)"apiUrl");
        Intrinsics.checkNotNullParameter((Object)responseHandler, (String)"responseHandler");
        Intrinsics.checkNotNullParameter((Object)authRetryPolicy, (String)"authRetryPolicy");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(headerMap, (String)"headerMap");
        this.apiService = apiService;
        this.apiUrl = apiUrl;
        this.responseHandler = responseHandler;
        this.authRetryPolicy = authRetryPolicy;
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.headerMap = headerMap;
    }

    public /* synthetic */ HttpAuthenticator(ApiService apiService, String string, ResponseHandler responseHandler, AuthRetryPolicy authRetryPolicy, EventHandler eventHandler, Clock clock, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            clock = new Clock();
        }
        this(apiService, string, responseHandler, authRetryPolicy, eventHandler, clock, map);
    }

    @NotNull
    public MqttConnectOptions authenticate(@NotNull MqttConnectOptions connectOptions, boolean forceRefresh) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        if (!forceRefresh && (charSequence = (CharSequence)connectOptions.getPassword()).length() > 0) {
            return connectOptions;
        }
        try {
            long startTime = this.clock.nanoTime();
            this.eventHandler.onEvent((MqttEvent)new MqttEvent.AuthenticatorAttemptEvent(forceRefresh, connectOptions, null, 4, null));
            Response response = this.apiService.authenticate(this.apiUrl, this.headerMap).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response);
            }
            this.authRetryPolicy.reset();
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.body()!!");
            MqttConnectOptions updatedConnectOptions = this.responseHandler.handleResponse((ResponseBody)object2, connectOptions);
            this.eventHandler.onEvent((MqttEvent)new MqttEvent.AuthenticatorSuccessEvent(forceRefresh, updatedConnectOptions, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - startTime)), null, 8, null));
            return updatedConnectOptions;
        }
        catch (Throwable th) {
            throw this.parseException(th);
        }
    }

    private final AuthApiException parseException(Throwable throwable) {
        return throwable instanceof HttpException ? new AuthApiException(((HttpException)throwable).code(), this.authRetryPolicy.getRetrySeconds(throwable), throwable) : new AuthApiException(0, this.authRetryPolicy.getRetrySeconds(throwable), throwable, 1, null);
    }
}

