/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.courier.messageadapter.gson;

import com.gojek.courier.Message;
import com.gojek.courier.MessageAdapter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/gojek/courier/messageadapter/gson/GsonMessageAdapter;", "T", "Lcom/gojek/courier/MessageAdapter;", "gson", "Lcom/google/gson/Gson;", "typeAdapter", "Lcom/google/gson/TypeAdapter;", "(Lcom/google/gson/Gson;Lcom/google/gson/TypeAdapter;)V", "contentType", "", "fromMessage", "topic", "message", "Lcom/gojek/courier/Message;", "(Ljava/lang/String;Lcom/gojek/courier/Message;)Ljava/lang/Object;", "toMessage", "data", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/gojek/courier/Message;", "courier-message-adapter-gson"})
final class GsonMessageAdapter<T>
implements MessageAdapter<T> {
    @NotNull
    private final Gson gson;
    @NotNull
    private final TypeAdapter<T> typeAdapter;

    public GsonMessageAdapter(@NotNull Gson gson, @NotNull TypeAdapter<T> typeAdapter) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Intrinsics.checkNotNullParameter(typeAdapter, (String)"typeAdapter");
        this.gson = gson;
        this.typeAdapter = typeAdapter;
    }

    public T fromMessage(@NotNull String topic, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Message message2 = message;
        if (!(message2 instanceof Message.Bytes)) {
            throw new NoWhenBranchMatchedException();
        }
        byte[] byArray = ((Message.Bytes)message).getValue();
        boolean bl = false;
        String stringValue = new String(byArray, Charsets.UTF_8);
        JsonReader jsonReader = this.gson.newJsonReader((Reader)new StringReader(stringValue));
        Object object = this.typeAdapter.read(jsonReader);
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @NotNull
    public Message toMessage(@NotNull String topic, T data) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Buffer buffer = new Buffer();
        OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), StandardCharsets.UTF_8);
        JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);
        this.typeAdapter.write(jsonWriter, data);
        jsonWriter.close();
        String stringValue = buffer.readByteString().utf8();
        Intrinsics.checkNotNullExpressionValue((Object)stringValue, (String)"stringValue");
        String string = stringValue;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return (Message)new Message.Bytes(byArray);
    }

    @NotNull
    public String contentType() {
        return "application/json";
    }
}

