/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.client;

import com.gojek.courier.Message;
import com.gojek.courier.QoS;
import com.gojek.mqtt.client.MqttClient;
import com.gojek.mqtt.client.internal.MqttClientInternal;
import com.gojek.mqtt.client.listener.MessageListener;
import com.gojek.mqtt.client.model.ConnectionState;
import com.gojek.mqtt.model.MqttConnectOptions;
import com.gojek.mqtt.model.MqttPacket;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JM\u0010\u001b\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u001c2*\u0010\u001d\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u001c0\u001e\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001e\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/gojek/mqtt/client/MqttCourierClient;", "Lcom/gojek/mqtt/client/MqttClient;", "mqttClient", "Lcom/gojek/mqtt/client/internal/MqttClientInternal;", "(Lcom/gojek/mqtt/client/internal/MqttClientInternal;)V", "addGlobalMessageListener", "", "listener", "Lcom/gojek/mqtt/client/listener/MessageListener;", "addMessageListener", "topic", "", "connect", "connectOptions", "Lcom/gojek/mqtt/model/MqttConnectOptions;", "disconnect", "clearState", "", "getCurrentState", "Lcom/gojek/mqtt/client/model/ConnectionState;", "reconnect", "removeMessageListener", "send", "message", "Lcom/gojek/courier/Message;", "qos", "Lcom/gojek/courier/QoS;", "subscribe", "Lkotlin/Pair;", "topics", "", "(Lkotlin/Pair;[Lkotlin/Pair;)V", "unsubscribe", "(Ljava/lang/String;[Ljava/lang/String;)V", "mqtt-client_release"})
public final class MqttCourierClient
implements MqttClient {
    @NotNull
    private final MqttClientInternal mqttClient;

    public MqttCourierClient(@NotNull MqttClientInternal mqttClient) {
        Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
        this.mqttClient = mqttClient;
    }

    @Override
    public void connect(@NotNull MqttConnectOptions connectOptions) {
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        this.mqttClient.connect(connectOptions);
    }

    @Override
    @NotNull
    public ConnectionState getCurrentState() {
        return this.mqttClient.getCurrentState();
    }

    @Override
    public void disconnect(boolean clearState) {
        this.mqttClient.disconnect(clearState);
    }

    @Override
    public void reconnect() {
        this.mqttClient.reconnect();
    }

    @Override
    public void subscribe(@NotNull Pair<String, ? extends QoS> topic, Pair<String, ? extends QoS> ... topics) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(topic);
        spreadBuilder.addSpread(topics);
        this.mqttClient.subscribe((Pair[])spreadBuilder.toArray((Object[])new Pair[spreadBuilder.size()]));
    }

    @Override
    public void unsubscribe(@NotNull String topic, String ... topics) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)topics, (String)"topics");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)topic);
        spreadBuilder.addSpread((Object)topics);
        this.mqttClient.unsubscribe((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @Override
    public boolean send(@NotNull Message message, @NotNull String topic, @NotNull QoS qos) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        return this.mqttClient.send(new MqttPacket(((Message.Bytes)message).getValue(), topic, qos));
    }

    @Override
    public void addMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mqttClient.addMessageListener(topic, listener2);
    }

    @Override
    public void removeMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mqttClient.removeMessageListener(topic, listener2);
    }

    @Override
    public void addGlobalMessageListener(@NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mqttClient.addGlobalMessageListener(listener2);
    }
}

