/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.client.event.adapter;

import com.gojek.courier.QoS;
import com.gojek.mqtt.connection.event.ConnectionEventHandler;
import com.gojek.mqtt.event.EventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.exception.CourierExceptionKt;
import com.gojek.mqtt.model.ServerUri;
import com.gojek.mqtt.network.NetworkHandler;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/gojek/mqtt/client/event/adapter/MqttClientEventAdapter;", "", "eventHandler", "Lcom/gojek/mqtt/event/EventHandler;", "networkHandler", "Lcom/gojek/mqtt/network/NetworkHandler;", "(Lcom/gojek/mqtt/event/EventHandler;Lcom/gojek/mqtt/network/NetworkHandler;)V", "adapt", "Lcom/gojek/mqtt/connection/event/ConnectionEventHandler;", "mqtt-client_release"})
public final class MqttClientEventAdapter {
    @NotNull
    private final EventHandler eventHandler;
    @NotNull
    private final NetworkHandler networkHandler;

    public MqttClientEventAdapter(@NotNull EventHandler eventHandler, @NotNull NetworkHandler networkHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        this.eventHandler = eventHandler;
        this.networkHandler = networkHandler;
    }

    @NotNull
    public final ConnectionEventHandler adapt() {
        return new ConnectionEventHandler(this){
            final /* synthetic */ MqttClientEventAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMqttConnectAttempt(boolean isOptimalKeepAlive, @Nullable ServerUri serverUri) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttConnectAttemptEvent(isOptimalKeepAlive, MqttClientEventAdapter.access$getNetworkHandler$p(this.this$0).getActiveNetworkInfo(), serverUri, null, 8, null));
            }

            public void onMqttConnectSuccess(@Nullable ServerUri serverUri, long timeTakenMillis) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttConnectSuccessEvent(MqttClientEventAdapter.access$getNetworkHandler$p(this.this$0).getActiveNetworkInfo(), serverUri, timeTakenMillis, null, 8, null));
            }

            public void onMqttConnectFailure(@NotNull Throwable throwable, @Nullable ServerUri serverUri, long timeTakenMillis) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttConnectFailureEvent(CourierExceptionKt.toCourierException(throwable), MqttClientEventAdapter.access$getNetworkHandler$p(this.this$0).getActiveNetworkInfo(), serverUri, timeTakenMillis, null, 16, null));
            }

            public void onMqttConnectionLost(@NotNull Throwable throwable, @Nullable ServerUri serverUri, int nextRetryTimeSecs, long sessionTimeMillis) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttConnectionLostEvent(CourierExceptionKt.toCourierException(throwable), MqttClientEventAdapter.access$getNetworkHandler$p(this.this$0).getActiveNetworkInfo(), serverUri, nextRetryTimeSecs, sessionTimeMillis, null, 32, null));
            }

            public void onMqttSubscribeAttempt(@NotNull Map<String, ? extends QoS> topics) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttSubscribeAttemptEvent(topics, null, 2, null));
            }

            public void onMqttSubscribeSuccess(@NotNull Map<String, ? extends QoS> topics, long timeTakenMillis) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttSubscribeSuccessEvent(topics, timeTakenMillis, null, 4, null));
            }

            public void onMqttSubscribeFailure(@NotNull Map<String, ? extends QoS> topics, @NotNull Throwable throwable, long timeTakenMillis) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttSubscribeFailureEvent(topics, CourierExceptionKt.toCourierException(throwable), timeTakenMillis, null, 8, null));
            }

            public void onMqttUnsubscribeFailure(@NotNull Set<String> topics, @NotNull Throwable throwable, long timeTakenMillis) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttUnsubscribeFailureEvent(topics, CourierExceptionKt.toCourierException(throwable), timeTakenMillis, null, 8, null));
            }

            public void onMqttUnsubscribeAttempt(@NotNull Set<String> topics) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttUnsubscribeAttemptEvent(topics, null, 2, null));
            }

            public void onMqttUnsubscribeSuccess(@NotNull Set<String> topics, long timeTakenMillis) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttUnsubscribeSuccessEvent(topics, timeTakenMillis, null, 4, null));
            }

            public void onSocketConnectAttempt(int port, @Nullable String host, long timeout) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SocketConnectAttemptEvent(port, host, timeout, null, 8, null));
            }

            public void onSocketConnectSuccess(long timeToConnect, int port, @Nullable String host, long timeout) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SocketConnectSuccessEvent(port, host, timeout, timeToConnect, null, 16, null));
            }

            public void onSocketConnectFailure(long timeToConnect, int port, @Nullable String host, long timeout, @Nullable Throwable throwable) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SocketConnectFailureEvent(port, host, timeout, timeToConnect, CourierExceptionKt.toCourierException(throwable), null, 32, null));
            }

            public void onConnectPacketSend() {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.ConnectPacketSendEvent(null, 1, null));
            }

            public void onSSLSocketAttempt(int port, @Nullable String host, long timeout) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SSLSocketAttemptEvent(port, host, timeout, null, 8, null));
            }

            public void onSSLSocketSuccess(int port, @Nullable String host, long timeout, long timeTakenMillis) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SSLSocketSuccessEvent(port, host, timeout, timeTakenMillis, null, 16, null));
            }

            public void onSSLSocketFailure(int port, @Nullable String host, long timeout, @Nullable Throwable throwable, long timeTakenMillis) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SSLSocketFailureEvent(port, host, timeout, CourierExceptionKt.toCourierException(throwable), timeTakenMillis, null, 32, null));
            }

            public void onSSLHandshakeSuccess(int port, @Nullable String host, long timeout, long timeTakenMillis) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.SSLHandshakeSuccessEvent(port, host, timeout, timeTakenMillis, null, 16, null));
            }

            public void onMqttDisconnectStart() {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttDisconnectStartEvent(null, 1, null));
            }

            public void onMqttDisconnectComplete() {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttDisconnectCompleteEvent(null, 1, null));
            }

            public void onMqttConnectDiscarded(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.MqttConnectDiscardedEvent(reason, MqttClientEventAdapter.access$getNetworkHandler$p(this.this$0).getActiveNetworkInfo(), null, 4, null));
            }

            public void onOfflineMessageDiscarded(int messageId) {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.OfflineMessageDiscardedEvent(messageId, null, 2, null));
            }

            public void onInboundInactivity() {
                MqttClientEventAdapter.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.InboundInactivityEvent(null, 1, null));
            }
        };
    }

    public static final /* synthetic */ EventHandler access$getEventHandler$p(MqttClientEventAdapter $this) {
        return $this.eventHandler;
    }

    public static final /* synthetic */ NetworkHandler access$getNetworkHandler$p(MqttClientEventAdapter $this) {
        return $this.networkHandler;
    }
}

