/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.client.internal;

import android.content.Context;
import com.gojek.courier.QoS;
import com.gojek.keepalive.KeepAliveFailureHandler;
import com.gojek.keepalive.NoOpKeepAliveFailureHandler;
import com.gojek.keepalive.OptimalKeepAliveFailureHandler;
import com.gojek.keepalive.OptimalKeepAliveObserver;
import com.gojek.mqtt.client.config.ExperimentConfigs;
import com.gojek.mqtt.client.config.v3.MqttV3Configuration;
import com.gojek.mqtt.client.event.interceptor.MqttEventsInterceptor;
import com.gojek.mqtt.client.factory.IAndroidMqttClientFactory;
import com.gojek.mqtt.client.factory.IAndroidMqttClientFactoryKt;
import com.gojek.mqtt.client.internal.KeepAliveProvider;
import com.gojek.mqtt.client.internal.MqttClientInternal;
import com.gojek.mqtt.client.internal.NonAdaptiveKeepAliveProvider;
import com.gojek.mqtt.client.internal.NonOptimalKeepAliveProvider;
import com.gojek.mqtt.client.internal.OptimalKeepAliveProvider;
import com.gojek.mqtt.client.listener.MessageListener;
import com.gojek.mqtt.client.model.ConnectionState;
import com.gojek.mqtt.client.v3.IAndroidMqttClient;
import com.gojek.mqtt.event.AdaptivePingEventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.event.PingEventHandler;
import com.gojek.mqtt.model.AdaptiveKeepAliveConfig;
import com.gojek.mqtt.model.MqttConnectOptions;
import com.gojek.mqtt.model.MqttPacket;
import com.gojek.mqtt.pingsender.AdaptiveMqttPingSender;
import com.gojek.mqtt.pingsender.MqttPingSender;
import com.gojek.networktracker.NetworkStateTracker;
import com.gojek.networktracker.NetworkStateTrackerFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0015\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u001aJ\u0016\u0010-\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200J7\u00101\u001a\u00020\u001a2*\u00102\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002050403\"\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020504\u00a2\u0006\u0002\u00106J\u001f\u00107\u001a\u00020\u001a2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f03\"\u00020\u001f\u00a2\u0006\u0002\u00108R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/gojek/mqtt/client/internal/MqttClientInternal;", "", "context", "Landroid/content/Context;", "mqttConfiguration", "Lcom/gojek/mqtt/client/config/v3/MqttV3Configuration;", "(Landroid/content/Context;Lcom/gojek/mqtt/client/config/v3/MqttV3Configuration;)V", "adaptiveMqttClient", "Lcom/gojek/mqtt/client/v3/IAndroidMqttClient;", "androidMqttClient", "androidMqttClientFactory", "Lcom/gojek/mqtt/client/factory/IAndroidMqttClientFactory;", "eventHandler", "Lcom/gojek/mqtt/client/event/interceptor/MqttEventsInterceptor;", "keepAliveFailureHandler", "Lcom/gojek/keepalive/KeepAliveFailureHandler;", "keepAliveProvider", "Lcom/gojek/mqtt/client/internal/KeepAliveProvider;", "networkStateTracker", "Lcom/gojek/networktracker/NetworkStateTracker;", "optimalKeepAliveObserver", "com/gojek/mqtt/client/internal/MqttClientInternal$optimalKeepAliveObserver$1", "Lcom/gojek/mqtt/client/internal/MqttClientInternal$optimalKeepAliveObserver$1;", "optimalKeepAliveProvider", "Lcom/gojek/keepalive/OptimalKeepAliveProvider;", "addGlobalMessageListener", "", "listener", "Lcom/gojek/mqtt/client/listener/MessageListener;", "addMessageListener", "topic", "", "connect", "connectOptions", "Lcom/gojek/mqtt/model/MqttConnectOptions;", "disconnect", "clearState", "", "getCurrentState", "Lcom/gojek/mqtt/client/model/ConnectionState;", "initialiseAdaptiveMqttClient", "initialiseOptimalKeepAliveProvider", "adaptiveKeepAliveConfig", "Lcom/gojek/mqtt/model/AdaptiveKeepAliveConfig;", "reconnect", "removeMessageListener", "send", "mqttPacket", "Lcom/gojek/mqtt/model/MqttPacket;", "subscribe", "topics", "", "Lkotlin/Pair;", "Lcom/gojek/courier/QoS;", "([Lkotlin/Pair;)V", "unsubscribe", "([Ljava/lang/String;)V", "mqtt-client_release"})
public final class MqttClientInternal {
    @NotNull
    private final Context context;
    @NotNull
    private final MqttV3Configuration mqttConfiguration;
    @NotNull
    private final IAndroidMqttClientFactory androidMqttClientFactory;
    @NotNull
    private final NetworkStateTracker networkStateTracker;
    @NotNull
    private final IAndroidMqttClient androidMqttClient;
    @Nullable
    private com.gojek.keepalive.OptimalKeepAliveProvider optimalKeepAliveProvider;
    @Nullable
    private IAndroidMqttClient adaptiveMqttClient;
    @NotNull
    private KeepAliveProvider keepAliveProvider;
    @NotNull
    private KeepAliveFailureHandler keepAliveFailureHandler;
    @NotNull
    private final MqttEventsInterceptor eventHandler;
    @NotNull
    private final optimalKeepAliveObserver.1 optimalKeepAliveObserver;

    public MqttClientInternal(@NotNull Context context, @NotNull MqttV3Configuration mqttConfiguration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mqttConfiguration, (String)"mqttConfiguration");
        this.context = context;
        this.mqttConfiguration = mqttConfiguration;
        this.androidMqttClientFactory = IAndroidMqttClientFactoryKt.getAndroidMqttClientFactory();
        Context context2 = this.context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.networkStateTracker = NetworkStateTrackerFactory.Companion.create(context2, this.mqttConfiguration.getLogger());
        this.keepAliveProvider = new NonAdaptiveKeepAliveProvider();
        this.keepAliveFailureHandler = (KeepAliveFailureHandler)new NoOpKeepAliveFailureHandler();
        this.eventHandler = new MqttEventsInterceptor(this.mqttConfiguration.getEventHandler());
        this.optimalKeepAliveObserver = new OptimalKeepAliveObserver(this){
            final /* synthetic */ MqttClientInternal this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOptimalKeepAliveFound(int timeMinutes, int probeCount, int convergenceTime) {
                MqttClientInternal.access$getMqttConfiguration$p(this.this$0).getLogger().d("MqttClient", Intrinsics.stringPlus((String)"Optimal KA found: ", (Object)timeMinutes));
                MqttClientInternal.access$getEventHandler$p(this.this$0).onEvent(new MqttEvent.OptimalKeepAliveFoundEvent(timeMinutes, probeCount, convergenceTime, null, 8, null));
                IAndroidMqttClient iAndroidMqttClient = MqttClientInternal.access$getAdaptiveMqttClient$p(this.this$0);
                if (iAndroidMqttClient != null) {
                    IAndroidMqttClient.DefaultImpls.disconnect$default(iAndroidMqttClient, false, 1, null);
                }
            }
        };
        this.initialiseAdaptiveMqttClient();
        this.androidMqttClient = this.androidMqttClientFactory.createAndroidMqttClient(this.context, this.mqttConfiguration, this.networkStateTracker, this.keepAliveProvider, this.keepAliveFailureHandler, this.eventHandler, new PingEventHandler(this.eventHandler));
    }

    public final void connect(@NotNull MqttConnectOptions connectOptions) {
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        this.androidMqttClient.connect(connectOptions);
        IAndroidMqttClient iAndroidMqttClient = this.adaptiveMqttClient;
        if (iAndroidMqttClient != null) {
            iAndroidMqttClient.connect(connectOptions);
        }
    }

    public final void disconnect(boolean clearState) {
        this.androidMqttClient.disconnect(clearState);
        IAndroidMqttClient iAndroidMqttClient = this.adaptiveMqttClient;
        if (iAndroidMqttClient != null) {
            iAndroidMqttClient.disconnect(clearState);
        }
    }

    public final void reconnect() {
        this.androidMqttClient.reconnect();
        IAndroidMqttClient iAndroidMqttClient = this.adaptiveMqttClient;
        if (iAndroidMqttClient != null) {
            iAndroidMqttClient.reconnect();
        }
    }

    public final void subscribe(Pair<String, ? extends QoS> ... topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        this.androidMqttClient.subscribe(MapsKt.mapOf(Arrays.copyOf(topics, topics.length)));
    }

    public final void unsubscribe(String ... topics) {
        Intrinsics.checkNotNullParameter((Object)topics, (String)"topics");
        this.androidMqttClient.unsubscribe(CollectionsKt.listOf((Object[])Arrays.copyOf(topics, topics.length)));
    }

    public final boolean send(@NotNull MqttPacket mqttPacket) {
        Intrinsics.checkNotNullParameter((Object)mqttPacket, (String)"mqttPacket");
        return this.androidMqttClient.send(mqttPacket);
    }

    public final void addMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.androidMqttClient.addMessageListener(topic, listener2);
    }

    public final void removeMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.androidMqttClient.removeMessageListener(topic, listener2);
    }

    public final void addGlobalMessageListener(@NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.androidMqttClient.addGlobalMessageListener(listener2);
    }

    @NotNull
    public final ConnectionState getCurrentState() {
        return this.androidMqttClient.getCurrentState();
    }

    private final void initialiseAdaptiveMqttClient() {
        block0: {
            ExperimentConfigs $this$initialiseAdaptiveMqttClient_u24lambda_u2d1;
            block1: {
                ExperimentConfigs experimentConfigs = this.mqttConfiguration.getExperimentConfigs();
                boolean bl = false;
                boolean bl2 = false;
                $this$initialiseAdaptiveMqttClient_u24lambda_u2d1 = experimentConfigs;
                boolean bl3 = false;
                if ($this$initialiseAdaptiveMqttClient_u24lambda_u2d1.getAdaptiveKeepAliveConfig() == null) break block0;
                this.initialiseOptimalKeepAliveProvider($this$initialiseAdaptiveMqttClient_u24lambda_u2d1.getAdaptiveKeepAliveConfig());
                com.gojek.keepalive.OptimalKeepAliveProvider optimalKeepAliveProvider = this.optimalKeepAliveProvider;
                Intrinsics.checkNotNull((Object)optimalKeepAliveProvider);
                int keepAliveSeconds = optimalKeepAliveProvider.getOptimalKASecondsForCurrentNetwork();
                if (keepAliveSeconds == 0) break block1;
                com.gojek.keepalive.OptimalKeepAliveProvider optimalKeepAliveProvider2 = this.optimalKeepAliveProvider;
                Intrinsics.checkNotNull((Object)optimalKeepAliveProvider2);
                this.keepAliveFailureHandler = (KeepAliveFailureHandler)new OptimalKeepAliveFailureHandler(optimalKeepAliveProvider2);
                this.keepAliveProvider = new OptimalKeepAliveProvider(keepAliveSeconds);
                break block0;
            }
            IAndroidMqttClient iAndroidMqttClient = this.adaptiveMqttClient;
            if (iAndroidMqttClient != null) break block0;
            boolean bl = false;
            boolean bl4 = false;
            boolean bl5 = false;
            AdaptiveMqttPingSender adaptiveMqttPingSender = $this$initialiseAdaptiveMqttClient_u24lambda_u2d1.getAdaptiveKeepAliveConfig().getPingSender();
            com.gojek.keepalive.OptimalKeepAliveProvider optimalKeepAliveProvider = this.optimalKeepAliveProvider;
            Intrinsics.checkNotNull((Object)optimalKeepAliveProvider);
            adaptiveMqttPingSender.setKeepAliveCalculator(optimalKeepAliveProvider.getKeepAliveCalculator());
            this.adaptiveMqttClient = this.androidMqttClientFactory.createAdaptiveAndroidMqttClient((MqttPingSender)$this$initialiseAdaptiveMqttClient_u24lambda_u2d1.getAdaptiveKeepAliveConfig().getPingSender(), this.context, this.mqttConfiguration, this.networkStateTracker, new NonOptimalKeepAliveProvider($this$initialiseAdaptiveMqttClient_u24lambda_u2d1.getAdaptiveKeepAliveConfig().getUpperBoundMinutes() * 60), (KeepAliveFailureHandler)new NoOpKeepAliveFailureHandler(), new AdaptivePingEventHandler(this.eventHandler));
        }
    }

    private final void initialiseOptimalKeepAliveProvider(AdaptiveKeepAliveConfig adaptiveKeepAliveConfig) {
        block0: {
            com.gojek.keepalive.OptimalKeepAliveProvider optimalKeepAliveProvider = this.optimalKeepAliveProvider;
            if (optimalKeepAliveProvider != null) break block0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.optimalKeepAliveProvider = new com.gojek.keepalive.OptimalKeepAliveProvider(this.context, new com.gojek.keepalive.config.AdaptiveKeepAliveConfig(adaptiveKeepAliveConfig.getLowerBoundMinutes(), adaptiveKeepAliveConfig.getUpperBoundMinutes(), adaptiveKeepAliveConfig.getStepMinutes(), adaptiveKeepAliveConfig.getOptimalKeepAliveResetLimit()), (OptimalKeepAliveObserver)this.optimalKeepAliveObserver, null, 8, null);
        }
    }

    public static final /* synthetic */ MqttV3Configuration access$getMqttConfiguration$p(MqttClientInternal $this) {
        return $this.mqttConfiguration;
    }

    public static final /* synthetic */ MqttEventsInterceptor access$getEventHandler$p(MqttClientInternal $this) {
        return $this.eventHandler;
    }

    public static final /* synthetic */ IAndroidMqttClient access$getAdaptiveMqttClient$p(MqttClientInternal $this) {
        return $this.adaptiveMqttClient;
    }
}

