/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.client.v3.impl;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import com.gojek.courier.QoS;
import com.gojek.courier.exception.AuthApiException;
import com.gojek.courier.extensions.TimeUnitExtensionsKt;
import com.gojek.courier.logging.ILogger;
import com.gojek.courier.utils.Clock;
import com.gojek.keepalive.KeepAliveFailureHandler;
import com.gojek.mqtt.auth.Authenticator;
import com.gojek.mqtt.client.IClientSchedulerBridge;
import com.gojek.mqtt.client.IMessageReceiveListener;
import com.gojek.mqtt.client.IncomingMsgController;
import com.gojek.mqtt.client.IncomingMsgControllerImpl;
import com.gojek.mqtt.client.MqttInterceptor;
import com.gojek.mqtt.client.MqttInterceptorKt;
import com.gojek.mqtt.client.config.ExperimentConfigs;
import com.gojek.mqtt.client.config.PersistenceOptions;
import com.gojek.mqtt.client.config.v3.MqttV3Configuration;
import com.gojek.mqtt.client.connectioninfo.ConnectionInfo;
import com.gojek.mqtt.client.connectioninfo.ConnectionInfoStore;
import com.gojek.mqtt.client.event.adapter.MqttClientEventAdapter;
import com.gojek.mqtt.client.internal.KeepAliveProvider;
import com.gojek.mqtt.client.listener.MessageListener;
import com.gojek.mqtt.client.model.ConnectionState;
import com.gojek.mqtt.client.model.MqttSendPacket;
import com.gojek.mqtt.client.v3.IAndroidMqttClient;
import com.gojek.mqtt.connection.IMqttConnection;
import com.gojek.mqtt.connection.MqttConnection;
import com.gojek.mqtt.connection.config.v3.ConnectionConfig;
import com.gojek.mqtt.connection.event.ConnectionEventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.exception.CourierExceptionKt;
import com.gojek.mqtt.handler.IncomingHandler;
import com.gojek.mqtt.model.MqttConnectOptions;
import com.gojek.mqtt.model.MqttPacket;
import com.gojek.mqtt.network.NetworkHandler;
import com.gojek.mqtt.persistence.impl.PahoPersistence;
import com.gojek.mqtt.persistence.model.MqttReceivePacket;
import com.gojek.mqtt.persistence.model.MqttReceivePacketKt;
import com.gojek.mqtt.pingsender.MqttPingSender;
import com.gojek.mqtt.policies.connectretrytime.IConnectRetryTimePolicy;
import com.gojek.mqtt.policies.connecttimeout.IConnectTimeoutPolicy;
import com.gojek.mqtt.policies.hostfallback.HostFallbackPolicy;
import com.gojek.mqtt.policies.hostfallback.IHostFallbackPolicy;
import com.gojek.mqtt.policies.subscriptionretry.ISubscriptionRetryPolicy;
import com.gojek.mqtt.scheduler.IRunnableScheduler;
import com.gojek.mqtt.scheduler.MqttRunnableScheduler;
import com.gojek.mqtt.send.listener.IMessageSendListener;
import com.gojek.mqtt.subscription.InMemorySubscriptionStore;
import com.gojek.mqtt.subscription.PersistableSubscriptionStore;
import com.gojek.mqtt.subscription.SubscriptionStore;
import com.gojek.mqtt.utils.MqttUtils;
import com.gojek.mqtt.utils.NetworkUtils;
import com.gojek.mqtt.wakelock.WakeLockProvider;
import com.gojek.networktracker.NetworkStateTracker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u0000 g2\u00020\u00012\u00020\u0002:\u0003ghiB?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001aH\u0016J\u0018\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020\u001aH\u0016J\b\u0010@\u001a\u00020;H\u0016J\u0010\u0010A\u001a\u00020;2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020;H\u0016J\u0010\u0010E\u001a\u00020;2\u0006\u0010F\u001a\u00020\fH\u0016J\u0010\u0010G\u001a\u00020;2\u0006\u0010F\u001a\u00020\fH\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\nH\u0002J\b\u0010K\u001a\u00020;H\u0016J \u0010L\u001a\u00020;2\u000e\u0010M\u001a\n\u0018\u00010Nj\u0004\u0018\u0001`O2\u0006\u0010P\u001a\u00020\fH\u0016J\b\u0010Q\u001a\u00020\fH\u0016J\b\u0010R\u001a\u00020\fH\u0016J\u0010\u0010S\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010P\u001a\u00020;H\u0016J\u0018\u0010T\u001a\u00020;2\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020\u001aH\u0016J\b\u0010U\u001a\u00020;H\u0016J\b\u0010V\u001a\u00020;H\u0016J\u0010\u0010W\u001a\u00020\f2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020;2\u0006\u0010X\u001a\u00020[H\u0016J\u001c\u0010\\\u001a\u00020;2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020_0^H\u0016J\u001c\u0010`\u001a\u00020;2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020_0^H\u0016J\b\u0010a\u001a\u00020;H\u0002J\u0016\u0010b\u001a\u00020;2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020?0dH\u0016J\u0016\u0010e\u001a\u00020;2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020?0fH\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient;", "Lcom/gojek/mqtt/client/v3/IAndroidMqttClient;", "Lcom/gojek/mqtt/client/IClientSchedulerBridge;", "context", "Landroid/content/Context;", "mqttConfiguration", "Lcom/gojek/mqtt/client/config/v3/MqttV3Configuration;", "networkStateTracker", "Lcom/gojek/networktracker/NetworkStateTracker;", "mqttPingSender", "Lcom/gojek/mqtt/pingsender/MqttPingSender;", "isAdaptiveKAConnection", "", "keepAliveProvider", "Lcom/gojek/mqtt/client/internal/KeepAliveProvider;", "keepAliveFailureHandler", "Lcom/gojek/keepalive/KeepAliveFailureHandler;", "(Landroid/content/Context;Lcom/gojek/mqtt/client/config/v3/MqttV3Configuration;Lcom/gojek/networktracker/NetworkStateTracker;Lcom/gojek/mqtt/pingsender/MqttPingSender;ZLcom/gojek/mqtt/client/internal/KeepAliveProvider;Lcom/gojek/keepalive/KeepAliveFailureHandler;)V", "clock", "Lcom/gojek/courier/utils/Clock;", "connectOptions", "Lcom/gojek/mqtt/model/MqttConnectOptions;", "experimentConfigs", "Lcom/gojek/mqtt/client/config/ExperimentConfigs;", "forceRefresh", "globalListener", "Lcom/gojek/mqtt/client/listener/MessageListener;", "hostFallbackPolicy", "Lcom/gojek/mqtt/policies/hostfallback/IHostFallbackPolicy;", "incomingMsgController", "Lcom/gojek/mqtt/client/IncomingMsgController;", "isInitialised", "logger", "Lcom/gojek/courier/logging/ILogger;", "mMessenger", "Landroid/os/Messenger;", "messageSendListener", "Lcom/gojek/mqtt/send/listener/IMessageSendListener;", "mqttClientEventAdapter", "Lcom/gojek/mqtt/client/event/adapter/MqttClientEventAdapter;", "mqttConnection", "Lcom/gojek/mqtt/connection/IMqttConnection;", "mqttPersistence", "Lcom/gojek/mqtt/persistence/impl/PahoPersistence;", "mqttThreadHandler", "Landroid/os/Handler;", "mqttThreadLooper", "Landroid/os/Looper;", "mqttUtils", "Lcom/gojek/mqtt/utils/MqttUtils;", "networkHandler", "Lcom/gojek/mqtt/network/NetworkHandler;", "networkUtils", "Lcom/gojek/mqtt/utils/NetworkUtils;", "runnableScheduler", "Lcom/gojek/mqtt/scheduler/IRunnableScheduler;", "subscriptionStore", "Lcom/gojek/mqtt/subscription/SubscriptionStore;", "addGlobalMessageListener", "", "listener", "addMessageListener", "topic", "", "checkActivity", "connect", "timeMillis", "", "connectMqtt", "disconnect", "clearState", "disconnectMqtt", "getCurrentState", "Lcom/gojek/mqtt/client/model/ConnectionState;", "getMqttPingSender", "handleAuthFailure", "handleMqttException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reconnect", "isConnected", "isConnecting", "postProcessConnectOptions", "removeMessageListener", "resetParams", "scheduleNextActivityCheck", "send", "mqttPacket", "Lcom/gojek/mqtt/model/MqttPacket;", "sendMessage", "Lcom/gojek/mqtt/client/model/MqttSendPacket;", "subscribe", "topicMap", "", "Lcom/gojek/courier/QoS;", "subscribeMqtt", "triggerHandleMessage", "unsubscribe", "topics", "", "unsubscribeMqtt", "", "Companion", "MqttMessageReceiverListener", "MqttMessageSendListener", "mqtt-client_release"})
public final class AndroidMqttClient
implements IAndroidMqttClient,
IClientSchedulerBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final MqttV3Configuration mqttConfiguration;
    @NotNull
    private final NetworkStateTracker networkStateTracker;
    @NotNull
    private final MqttPingSender mqttPingSender;
    private final boolean isAdaptiveKAConnection;
    @NotNull
    private final KeepAliveProvider keepAliveProvider;
    @NotNull
    private final IRunnableScheduler runnableScheduler;
    @NotNull
    private final IMqttConnection mqttConnection;
    @NotNull
    private final Looper mqttThreadLooper;
    @NotNull
    private final Handler mqttThreadHandler;
    @NotNull
    private Messenger mMessenger;
    @NotNull
    private final NetworkUtils networkUtils;
    @NotNull
    private final MqttUtils mqttUtils;
    @NotNull
    private final PahoPersistence mqttPersistence;
    @NotNull
    private final IMessageSendListener messageSendListener;
    @NotNull
    private final NetworkHandler networkHandler;
    @NotNull
    private final MqttClientEventAdapter mqttClientEventAdapter;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final IncomingMsgController incomingMsgController;
    private MqttConnectOptions connectOptions;
    @NotNull
    private final ExperimentConfigs experimentConfigs;
    @Nullable
    private volatile MessageListener globalListener;
    private volatile boolean isInitialised;
    private boolean forceRefresh;
    @NotNull
    private final SubscriptionStore subscriptionStore;
    @Nullable
    private IHostFallbackPolicy hostFallbackPolicy;
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String TAG = "AndroidMqttClient";

    /*
     * WARNING - void declaration
     */
    public AndroidMqttClient(@NotNull Context context, @NotNull MqttV3Configuration mqttConfiguration, @NotNull NetworkStateTracker networkStateTracker, @NotNull MqttPingSender mqttPingSender, boolean isAdaptiveKAConnection, @NotNull KeepAliveProvider keepAliveProvider, @NotNull KeepAliveFailureHandler keepAliveFailureHandler) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mqttConfiguration, (String)"mqttConfiguration");
        Intrinsics.checkNotNullParameter((Object)networkStateTracker, (String)"networkStateTracker");
        Intrinsics.checkNotNullParameter((Object)mqttPingSender, (String)"mqttPingSender");
        Intrinsics.checkNotNullParameter((Object)keepAliveProvider, (String)"keepAliveProvider");
        Intrinsics.checkNotNullParameter((Object)keepAliveFailureHandler, (String)"keepAliveFailureHandler");
        this.context = context;
        this.mqttConfiguration = mqttConfiguration;
        this.networkStateTracker = networkStateTracker;
        this.mqttPingSender = mqttPingSender;
        this.isAdaptiveKAConnection = isAdaptiveKAConnection;
        this.keepAliveProvider = keepAliveProvider;
        this.experimentConfigs = this.mqttConfiguration.getExperimentConfigs();
        this.subscriptionStore = this.experimentConfigs.isPersistentSubscriptionStoreEnabled() ? (SubscriptionStore)new PersistableSubscriptionStore(this.context) : (SubscriptionStore)new InMemorySubscriptionStore();
        this.clock = new Clock();
        this.logger = this.mqttConfiguration.getLogger();
        HandlerThread mqttHandlerThread = new HandlerThread("MQTT_Thread");
        mqttHandlerThread.start();
        Looper looper = mqttHandlerThread.getLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"mqttHandlerThread.looper");
        this.mqttThreadLooper = looper;
        this.mqttThreadHandler = new Handler(this.mqttThreadLooper);
        this.mMessenger = new Messenger((Handler)new IncomingHandler(this.mqttThreadLooper, this, this.logger));
        this.runnableScheduler = new MqttRunnableScheduler(mqttHandlerThread, this.mqttThreadHandler, this, this.logger, this.mqttConfiguration.getEventHandler(), this.experimentConfigs.getActivityCheckIntervalSeconds());
        this.mqttUtils = new MqttUtils();
        this.networkUtils = new NetworkUtils();
        this.mqttPersistence = new PahoPersistence(this.context);
        this.messageSendListener = new MqttMessageSendListener();
        this.networkHandler = new NetworkHandler(this.mqttConfiguration.getLogger(), this, this.networkUtils, this.networkStateTracker);
        this.mqttClientEventAdapter = new MqttClientEventAdapter(this.mqttConfiguration.getEventHandler(), this.networkHandler);
        IConnectRetryTimePolicy iConnectRetryTimePolicy = this.mqttConfiguration.getConnectRetryTimePolicy();
        IConnectTimeoutPolicy iConnectTimeoutPolicy = this.mqttConfiguration.getConnectTimeoutPolicy();
        ISubscriptionRetryPolicy iSubscriptionRetryPolicy = this.mqttConfiguration.getSubscriptionRetryPolicy();
        ISubscriptionRetryPolicy iSubscriptionRetryPolicy2 = this.mqttConfiguration.getUnsubscriptionRetryPolicy();
        int n = this.mqttConfiguration.getWakeLockTimeout();
        ILogger iLogger = this.mqttConfiguration.getLogger();
        ConnectionEventHandler connectionEventHandler = this.mqttClientEventAdapter.adapt();
        SocketFactory socketFactory = this.mqttConfiguration.getSocketFactory();
        Iterable $this$map$iv = this.mqttConfiguration.getMqttInterceptorList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MqttInterceptor mqttInterceptor = (MqttInterceptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            org.eclipse.paho.client.mqttv3.MqttInterceptor mqttInterceptor2 = MqttInterceptorKt.mapToPahoInterceptor((MqttInterceptor)it);
            collection.add(mqttInterceptor2);
        }
        List list = (List)destination$iv$iv;
        PersistenceOptions persistenceOptions = this.mqttConfiguration.getPersistenceOptions();
        int n2 = this.experimentConfigs.getInactivityTimeoutSeconds();
        int n3 = this.experimentConfigs.getPolicyResetTimeSeconds();
        ConnectionConfig connectionConfig = new ConnectionConfig(iConnectRetryTimePolicy, iConnectTimeoutPolicy, iSubscriptionRetryPolicy, iSubscriptionRetryPolicy2, n, 100, iLogger, socketFactory, connectionEventHandler, 0, 0, list, persistenceOptions, n2, n3, 1536, null);
        this.mqttConnection = new MqttConnection(this.context, connectionConfig, this.runnableScheduler, this.networkUtils, new WakeLockProvider(this.context, this.logger), this.messageSendListener, this.mqttPersistence, this.networkHandler, this.getMqttPingSender(), keepAliveFailureHandler, this.clock, this.subscriptionStore);
        this.incomingMsgController = new IncomingMsgControllerImpl(this.mqttUtils, this.mqttPersistence, this.logger, this.mqttConfiguration.getEventHandler(), this.experimentConfigs.getIncomingMessagesTTLSecs(), this.experimentConfigs.getIncomingMessagesCleanupIntervalSecs(), this.clock);
        this.networkHandler.init();
    }

    public /* synthetic */ AndroidMqttClient(Context context, MqttV3Configuration mqttV3Configuration, NetworkStateTracker networkStateTracker, MqttPingSender mqttPingSender, boolean bl, KeepAliveProvider keepAliveProvider, KeepAliveFailureHandler keepAliveFailureHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(context, mqttV3Configuration, networkStateTracker, mqttPingSender, bl, keepAliveProvider, keepAliveFailureHandler);
    }

    @Override
    public void connect(@NotNull MqttConnectOptions connectOptions) {
        Intrinsics.checkNotNullParameter((Object)connectOptions, (String)"connectOptions");
        this.connectOptions = connectOptions;
        this.isInitialised = true;
        this.runnableScheduler.connectMqtt();
    }

    @Override
    public void reconnect() {
        this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttReconnectEvent(null, 1, null));
        IRunnableScheduler.DefaultImpls.disconnectMqtt$default(this.runnableScheduler, true, false, 2, null);
    }

    @Override
    public void disconnect(boolean clearState) {
        this.isInitialised = false;
        this.runnableScheduler.disconnectMqtt(false, clearState);
    }

    @Override
    public void connect(long timeMillis) {
        this.runnableScheduler.connectMqtt(timeMillis);
    }

    @Override
    public void sendMessage(@NotNull MqttSendPacket mqttPacket) {
        Intrinsics.checkNotNullParameter((Object)mqttPacket, (String)"mqttPacket");
        if (!this.isConnected()) {
            this.connectMqtt();
        }
        try {
            this.logger.d(TAG, "Publishing mqtt packet on " + mqttPacket.getTopic() + " with qos " + mqttPacket.getQos());
            boolean bl = false;
            boolean bl2 = false;
            MqttSendPacket $this$sendMessage_u24lambda_u2d1 = mqttPacket;
            boolean bl3 = false;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageSendEvent($this$sendMessage_u24lambda_u2d1.getTopic(), $this$sendMessage_u24lambda_u2d1.getQos(), $this$sendMessage_u24lambda_u2d1.getMessage().length, null, 8, null));
            this.mqttConnection.publish(mqttPacket, mqttPacket.getQos(), mqttPacket.getTopic());
        }
        catch (MqttPersistenceException e) {
            boolean bl = false;
            boolean bl4 = false;
            MqttSendPacket $this$sendMessage_u24lambda_u2d2 = mqttPacket;
            boolean bl5 = false;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageSendFailureEvent($this$sendMessage_u24lambda_u2d2.getTopic(), $this$sendMessage_u24lambda_u2d2.getQos(), $this$sendMessage_u24lambda_u2d2.getMessage().length, CourierExceptionKt.toCourierException(e), null, 16, null));
        }
        catch (MqttException e) {
            boolean bl = false;
            boolean bl6 = false;
            MqttSendPacket $this$sendMessage_u24lambda_u2d3 = mqttPacket;
            boolean bl7 = false;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageSendFailureEvent($this$sendMessage_u24lambda_u2d3.getTopic(), $this$sendMessage_u24lambda_u2d3.getQos(), $this$sendMessage_u24lambda_u2d3.getMessage().length, CourierExceptionKt.toCourierException(e), null, 16, null));
            this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)e), true);
        }
        catch (Exception e) {
            boolean bl = false;
            boolean bl8 = false;
            MqttSendPacket $this$sendMessage_u24lambda_u2d4 = mqttPacket;
            boolean bl9 = false;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageSendFailureEvent($this$sendMessage_u24lambda_u2d4.getTopic(), $this$sendMessage_u24lambda_u2d4.getQos(), $this$sendMessage_u24lambda_u2d4.getMessage().length, CourierExceptionKt.toCourierException(e), null, 16, null));
        }
    }

    @Override
    public boolean send(@NotNull MqttPacket mqttPacket) {
        Intrinsics.checkNotNullParameter((Object)mqttPacket, (String)"mqttPacket");
        MqttSendPacket mqttSendPacket = new MqttSendPacket(mqttPacket.getMessage(), 0L, System.currentTimeMillis(), mqttPacket.getQos().getValue(), mqttPacket.getTopic());
        Message msg = Message.obtain();
        msg.what = 4;
        Bundle bundle = new Bundle();
        bundle.putParcelable("msg", (Parcelable)mqttSendPacket);
        msg.setData(bundle);
        msg.replyTo = this.mMessenger;
        try {
            this.mMessenger.send(msg);
        }
        catch (RemoteException e) {
            this.logger.e(TAG, "Remote Service dead", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void addMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.incomingMsgController.registerListener(topic, listener2);
    }

    @Override
    public void removeMessageListener(@NotNull String topic, @NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.incomingMsgController.unregisterListener(topic, listener2);
    }

    @Override
    public void addGlobalMessageListener(@NotNull MessageListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.globalListener = listener2;
    }

    @Override
    public void connectMqtt() {
        long startTime = this.clock.nanoTime();
        try {
            MqttConnectOptions mqttConnectOptions;
            MqttConnectOptions mqttConnectOptions2;
            this.logger.d(TAG, "Sending onConnectAttempt event");
            if (!this.isInitialised) {
                this.logger.d(TAG, "Mqtt Client not initialised");
                this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttConnectDiscardedEvent("Mqtt Client not initialised", this.networkHandler.getActiveNetworkInfo(), null, 4, null));
                return;
            }
            if (this.mqttConfiguration.getAuthFailureHandler() == null) {
                try {
                    MqttConnectOptions mqttConnectOptions3;
                    Authenticator authenticator = this.mqttConfiguration.getAuthenticator();
                    MqttConnectOptions mqttConnectOptions4 = this.connectOptions;
                    if (mqttConnectOptions4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"connectOptions");
                        mqttConnectOptions3 = null;
                    } else {
                        mqttConnectOptions3 = mqttConnectOptions4;
                    }
                    this.connectOptions = authenticator.authenticate(mqttConnectOptions3, this.forceRefresh);
                }
                catch (AuthApiException ex) {
                    throw ex;
                }
                catch (Throwable th) {
                    throw new AuthApiException(0, 0L, th, 1, null);
                }
            }
            if ((mqttConnectOptions2 = this.connectOptions) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectOptions");
                mqttConnectOptions = null;
            } else {
                mqttConnectOptions = mqttConnectOptions2;
            }
            MqttConnectOptions processedConnectOptions = this.postProcessConnectOptions(mqttConnectOptions);
            IMessageReceiveListener iMessageReceiveListener = new MqttMessageReceiverListener();
            IHostFallbackPolicy iHostFallbackPolicy = this.hostFallbackPolicy;
            Intrinsics.checkNotNull((Object)iHostFallbackPolicy);
            this.mqttConnection.connect(processedConnectOptions, iMessageReceiveListener, iHostFallbackPolicy, this.subscriptionStore.getSubscribeTopics());
        }
        catch (AuthApiException e) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"Auth exception : ", (Object)e.getMessage()));
            this.forceRefresh = true;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.AuthenticatorErrorEvent(CourierExceptionKt.toCourierException(e), e.getNextRetrySeconds(), this.networkHandler.getActiveNetworkInfo(), TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - startTime)), null, 16, null));
            if (e.getNextRetrySeconds() > 0L) {
                this.runnableScheduler.connectMqtt(TimeUnit.SECONDS.toMillis(e.getNextRetrySeconds()));
            } else {
                MqttException mqttException = new MqttException(6, (Throwable)e);
                this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)mqttException), true);
            }
        }
        catch (Exception e) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"Connect exception : ", (Object)e.getMessage()));
            Object mqttException = this.hostFallbackPolicy;
            this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttConnectFailureEvent(CourierExceptionKt.toCourierException(e), this.networkHandler.getActiveNetworkInfo(), mqttException == null ? null : mqttException.getServerUri(), TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - startTime)), null, 16, null));
            mqttException = new MqttException(6, (Throwable)e);
            this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)mqttException, true);
        }
    }

    @Override
    public void disconnectMqtt(boolean clearState) {
        this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttDisconnectEvent(null, 1, null));
        this.mqttConnection.disconnect();
        if (clearState) {
            this.mqttConnection.shutDown();
            this.subscriptionStore.clear();
            this.mqttPersistence.clearAll();
        }
    }

    @Override
    public void handleMqttException(@Nullable Exception exception, boolean reconnect) {
        this.mqttConnection.handleException(exception, reconnect);
    }

    @Override
    public boolean isConnected() {
        return this.mqttConnection.isConnected();
    }

    @Override
    public void subscribe(@NotNull Map<String, ? extends QoS> topicMap) {
        Intrinsics.checkNotNullParameter(topicMap, (String)"topicMap");
        Map<String, QoS> addedTopics = this.subscriptionStore.subscribeTopics(topicMap);
        this.runnableScheduler.scheduleSubscribe(0L, addedTopics);
    }

    @Override
    public void unsubscribe(@NotNull List<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Set<String> removedTopics = this.subscriptionStore.unsubscribeTopics(topics);
        this.runnableScheduler.scheduleUnsubscribe(0L, removedTopics);
    }

    @Override
    @NotNull
    public ConnectionState getCurrentState() {
        return this.mqttConnection.isConnecting() ? ConnectionState.CONNECTING : (this.mqttConnection.isConnected() ? ConnectionState.CONNECTED : (this.mqttConnection.isDisconnecting() ? ConnectionState.DISCONNECTING : (this.mqttConnection.isDisconnected() ? ConnectionState.DISCONNECTED : ConnectionState.INITIALISED)));
    }

    @Override
    public boolean isConnecting() {
        return this.mqttConnection.isConnecting();
    }

    @Override
    public void checkActivity() {
        this.mqttConnection.checkActivity();
    }

    @Override
    public void scheduleNextActivityCheck() {
        this.runnableScheduler.scheduleNextActivityCheck();
    }

    @Override
    public void subscribeMqtt(@NotNull Map<String, ? extends QoS> topicMap) {
        Intrinsics.checkNotNullParameter(topicMap, (String)"topicMap");
        if (this.mqttConnection.isConnected()) {
            this.mqttConnection.subscribe(topicMap);
        }
    }

    @Override
    public void unsubscribeMqtt(@NotNull Set<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        if (this.mqttConnection.isConnected()) {
            this.mqttConnection.unsubscribe(topics);
        }
    }

    @Override
    public void resetParams() {
        this.mqttConnection.resetParams();
    }

    @Override
    public void handleAuthFailure() {
        MqttV3Configuration mqttV3Configuration = this.mqttConfiguration;
        boolean bl = false;
        boolean bl2 = false;
        MqttV3Configuration $this$handleAuthFailure_u24lambda_u2d5 = mqttV3Configuration;
        boolean bl3 = false;
        if ($this$handleAuthFailure_u24lambda_u2d5.getAuthFailureHandler() == null) {
            this.forceRefresh = true;
            this.connectMqtt();
        } else {
            $this$handleAuthFailure_u24lambda_u2d5.getAuthFailureHandler().handleAuthFailure();
        }
    }

    private final void triggerHandleMessage() {
        this.incomingMsgController.triggerHandleMessage();
    }

    private final MqttPingSender getMqttPingSender() {
        return this.mqttPingSender;
    }

    private final MqttConnectOptions postProcessConnectOptions(MqttConnectOptions connectOptions) {
        MqttConnectOptions mqttConnectOptions;
        this.forceRefresh = false;
        this.hostFallbackPolicy = new HostFallbackPolicy(connectOptions.getServerUris());
        MqttConnectOptions mqttConnectOptions2 = mqttConnectOptions = this.isAdaptiveKAConnection ? MqttConnectOptions.copy$default(connectOptions, null, this.keepAliveProvider.getKeepAlive(connectOptions), Intrinsics.stringPlus((String)connectOptions.getClientId(), (Object)":adaptive"), null, null, true, 0, null, null, 473, null) : MqttConnectOptions.copy$default(connectOptions, null, this.keepAliveProvider.getKeepAlive(connectOptions), null, null, null, false, 0, null, null, 509, null);
        if (!this.isAdaptiveKAConnection) {
            String string = mqttConnectOptions.getClientId();
            String string2 = mqttConnectOptions.getUsername();
            int n = mqttConnectOptions.getKeepAlive().getTimeSeconds();
            int n2 = this.mqttConfiguration.getConnectTimeoutPolicy().getConnectTimeOut();
            IHostFallbackPolicy iHostFallbackPolicy = this.hostFallbackPolicy;
            Intrinsics.checkNotNull((Object)iHostFallbackPolicy);
            String string3 = iHostFallbackPolicy.getServerUri().getHost();
            IHostFallbackPolicy iHostFallbackPolicy2 = this.hostFallbackPolicy;
            Intrinsics.checkNotNull((Object)iHostFallbackPolicy2);
            int n3 = iHostFallbackPolicy2.getServerUri().getPort();
            IHostFallbackPolicy iHostFallbackPolicy3 = this.hostFallbackPolicy;
            Intrinsics.checkNotNull((Object)iHostFallbackPolicy3);
            ConnectionInfoStore.INSTANCE.updateConnectionInfo(new ConnectionInfo(string, string2, n, n2, string3, n3, iHostFallbackPolicy3.getServerUri().getScheme()));
        }
        return mqttConnectOptions;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient$MqttMessageReceiverListener;", "Lcom/gojek/mqtt/client/IMessageReceiveListener;", "(Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient;)V", "messageArrived", "", "topic", "", "byteArray", "", "mqtt-client_release"})
    public final class MqttMessageReceiverListener
    implements IMessageReceiveListener {
        public MqttMessageReceiverListener() {
            Intrinsics.checkNotNullParameter((Object)AndroidMqttClient.this, (String)"this$0");
        }

        @Override
        public boolean messageArrived(@NotNull String topic, @NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            try {
                AndroidMqttClient.this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageReceiveEvent(topic, byteArray.length, null, 4, null));
                byte[] byArray = AndroidMqttClient.this.mqttUtils.uncompressByteArray(byteArray);
                Intrinsics.checkNotNull((Object)byArray);
                byte[] bytes = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                boolean bl = false;
                String messageBody = new String(bytes, charset);
                String logMsg = "messageArrived called for message code : ";
                AndroidMqttClient.this.logger.i(AndroidMqttClient.TAG, Intrinsics.stringPlus((String)logMsg, (Object)messageBody));
                MqttReceivePacket mqttPacket = new MqttReceivePacket(bytes, 0L, AndroidMqttClient.this.clock.nanoTime(), topic);
                AndroidMqttClient.this.mqttPersistence.addReceivedMessage(mqttPacket);
                MessageListener messageListener = AndroidMqttClient.this.globalListener;
                if (messageListener != null) {
                    messageListener.onMessageReceived(MqttReceivePacketKt.toMqttMessage(mqttPacket));
                }
                AndroidMqttClient.this.triggerHandleMessage();
            }
            catch (IllegalStateException e) {
                AndroidMqttClient.this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageReceiveErrorEvent(topic, byteArray.length, CourierExceptionKt.toCourierException(e), null, 8, null));
                AndroidMqttClient.this.logger.e(AndroidMqttClient.TAG, "Exception when msg arrived : ", (Throwable)e);
                IRunnableScheduler.DefaultImpls.disconnectMqtt$default(AndroidMqttClient.this.runnableScheduler, true, false, 2, null);
                return false;
            }
            catch (Throwable e) {
                AndroidMqttClient.this.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageReceiveErrorEvent(topic, byteArray.length, CourierExceptionKt.toCourierException(e), null, 8, null));
                AndroidMqttClient.this.logger.e(AndroidMqttClient.TAG, "Exception when msg arrived : ", e);
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient$MqttMessageSendListener;", "Lcom/gojek/mqtt/send/listener/IMessageSendListener;", "(Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient;)V", "notifyWrittenOnSocket", "", "packet", "Lcom/gojek/mqtt/client/model/MqttSendPacket;", "onFailure", "exception", "", "onSuccess", "mqtt-client_release"})
    public final class MqttMessageSendListener
    implements IMessageSendListener {
        public MqttMessageSendListener() {
            Intrinsics.checkNotNullParameter((Object)AndroidMqttClient.this, (String)"this$0");
        }

        @Override
        public void onSuccess(@NotNull MqttSendPacket packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            AndroidMqttClient androidMqttClient = AndroidMqttClient.this;
            boolean bl = false;
            boolean bl2 = false;
            MqttSendPacket $this$onSuccess_u24lambda_u2d0 = packet;
            boolean bl3 = false;
            androidMqttClient.mqttConfiguration.getEventHandler().onEvent(new MqttEvent.MqttMessageSendSuccessEvent($this$onSuccess_u24lambda_u2d0.getTopic(), $this$onSuccess_u24lambda_u2d0.getQos(), $this$onSuccess_u24lambda_u2d0.getMessage().length, null, 8, null));
        }

        @Override
        public void onFailure(@NotNull MqttSendPacket packet, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            AndroidMqttClient.this.runnableScheduler.connectMqtt();
        }

        @Override
        public void notifyWrittenOnSocket(@NotNull MqttSendPacket packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/gojek/mqtt/client/v3/impl/AndroidMqttClient$Companion;", "", "()V", "TAG", "", "mqtt-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

