/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.connection;

import android.content.Context;
import android.os.SystemClock;
import com.gojek.courier.QoS;
import com.gojek.courier.extensions.TimeUnitExtensionsKt;
import com.gojek.courier.utils.Clock;
import com.gojek.keepalive.KeepAliveFailureHandler;
import com.gojek.mqtt.client.IMessageReceiveListener;
import com.gojek.mqtt.client.config.PersistenceOptions;
import com.gojek.mqtt.client.model.MqttSendPacket;
import com.gojek.mqtt.connection.IMqttConnection;
import com.gojek.mqtt.connection.MqttContext;
import com.gojek.mqtt.connection.config.v3.ConnectionConfig;
import com.gojek.mqtt.event.PahoEventHandler;
import com.gojek.mqtt.exception.handler.v3.MqttExceptionHandler;
import com.gojek.mqtt.exception.handler.v3.impl.MqttExceptionHandlerImpl;
import com.gojek.mqtt.logging.PahoLogger;
import com.gojek.mqtt.model.MqttConnectOptions;
import com.gojek.mqtt.model.ServerUri;
import com.gojek.mqtt.network.NetworkHandler;
import com.gojek.mqtt.persistence.impl.PahoPersistence;
import com.gojek.mqtt.pingsender.MqttPingSender;
import com.gojek.mqtt.pingsender.MqttPingSenderKt;
import com.gojek.mqtt.policies.connectretrytime.IConnectRetryTimePolicy;
import com.gojek.mqtt.policies.connecttimeout.IConnectTimeoutPolicy;
import com.gojek.mqtt.policies.hostfallback.IHostFallbackPolicy;
import com.gojek.mqtt.policies.subscriptionretry.ISubscriptionRetryPolicy;
import com.gojek.mqtt.scheduler.IRunnableScheduler;
import com.gojek.mqtt.send.listener.IMessageSendListener;
import com.gojek.mqtt.subscription.SubscriptionStore;
import com.gojek.mqtt.utils.NetworkUtils;
import com.gojek.mqtt.wakelock.WakeLockProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IExperimentsConfig;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttActionListenerNew;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.internal.wire.UserProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u0000 o2\u00020\u0001:\u0001oBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u00107\u001a\u000208H\u0016J4\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020'2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A0?H\u0016J\b\u0010B\u001a\u000208H\u0016J\u001e\u0010C\u001a\u0004\u0018\u00010D2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A0?H\u0002J\u0018\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020@2\u0006\u00101\u001a\u00020@H\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010I\u001a\u00020JH\u0002J\n\u0010K\u001a\u0004\u0018\u00010@H\u0016J\b\u0010L\u001a\u000202H\u0002J\u001c\u0010M\u001a\u00020D2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A0?H\u0002J\u0016\u0010O\u001a\u00020D2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020@0QH\u0002J\"\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020@0?H\u0002J\b\u0010V\u001a\u000208H\u0002J \u0010W\u001a\u0002082\u000e\u0010X\u001a\n\u0018\u00010Yj\u0004\u0018\u0001`Z2\u0006\u0010[\u001a\u00020%H\u0016J\b\u0010\\\u001a\u00020%H\u0016J\b\u0010]\u001a\u00020%H\u0016J\b\u0010^\u001a\u00020%H\u0016J\b\u0010_\u001a\u00020%H\u0016J\b\u0010`\u001a\u00020%H\u0016J\u0010\u0010a\u001a\u00020%2\u0006\u0010b\u001a\u00020\u001eH\u0002J\b\u0010c\u001a\u00020%H\u0002J \u0010d\u001a\u0002082\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020@H\u0016J\b\u0010j\u001a\u000208H\u0002J\b\u0010k\u001a\u000208H\u0016J\b\u0010l\u001a\u000208H\u0016J\u001c\u0010m\u001a\u0002082\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020A0?H\u0016J\u0016\u0010n\u001a\u0002082\f\u0010P\u001a\b\u0012\u0004\u0012\u00020@0QH\u0016R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/gojek/mqtt/connection/MqttConnection;", "Lcom/gojek/mqtt/connection/IMqttConnection;", "context", "Landroid/content/Context;", "connectionConfig", "Lcom/gojek/mqtt/connection/config/v3/ConnectionConfig;", "runnableScheduler", "Lcom/gojek/mqtt/scheduler/IRunnableScheduler;", "networkUtils", "Lcom/gojek/mqtt/utils/NetworkUtils;", "wakeLockProvider", "Lcom/gojek/mqtt/wakelock/WakeLockProvider;", "messageSendListener", "Lcom/gojek/mqtt/send/listener/IMessageSendListener;", "pahoPersistence", "Lcom/gojek/mqtt/persistence/impl/PahoPersistence;", "networkHandler", "Lcom/gojek/mqtt/network/NetworkHandler;", "mqttPingSender", "Lcom/gojek/mqtt/pingsender/MqttPingSender;", "keepAliveFailureHandler", "Lcom/gojek/keepalive/KeepAliveFailureHandler;", "clock", "Lcom/gojek/courier/utils/Clock;", "subscriptionStore", "Lcom/gojek/mqtt/subscription/SubscriptionStore;", "(Landroid/content/Context;Lcom/gojek/mqtt/connection/config/v3/ConnectionConfig;Lcom/gojek/mqtt/scheduler/IRunnableScheduler;Lcom/gojek/mqtt/utils/NetworkUtils;Lcom/gojek/mqtt/wakelock/WakeLockProvider;Lcom/gojek/mqtt/send/listener/IMessageSendListener;Lcom/gojek/mqtt/persistence/impl/PahoPersistence;Lcom/gojek/mqtt/network/NetworkHandler;Lcom/gojek/mqtt/pingsender/MqttPingSender;Lcom/gojek/keepalive/KeepAliveFailureHandler;Lcom/gojek/courier/utils/Clock;Lcom/gojek/mqtt/subscription/SubscriptionStore;)V", "connectRetryTimePolicy", "Lcom/gojek/mqtt/policies/connectretrytime/IConnectRetryTimePolicy;", "connectStartTime", "", "connectSuccessTime", "connectTimeoutPolicy", "Lcom/gojek/mqtt/policies/connecttimeout/IConnectTimeoutPolicy;", "fastReconnect", "", "forceDisconnect", "", "hostFallbackPolicy", "Lcom/gojek/mqtt/policies/hostfallback/IHostFallbackPolicy;", "logger", "Lcom/gojek/courier/logging/ILogger;", "mqtt", "Lorg/eclipse/paho/client/mqttv3/MqttAsyncClient;", "mqttExceptionHandler", "Lcom/gojek/mqtt/exception/handler/v3/MqttExceptionHandler;", "options", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "pushReConnect", "serverUri", "Lcom/gojek/mqtt/model/ServerUri;", "subscriptionPolicy", "Lcom/gojek/mqtt/policies/subscriptionretry/ISubscriptionRetryPolicy;", "unsubscriptionPolicy", "updatePolicyParams", "checkActivity", "", "connect", "mqttConnectOptions", "Lcom/gojek/mqtt/model/MqttConnectOptions;", "messageReceiveListener", "Lcom/gojek/mqtt/client/IMessageReceiveListener;", "subscriptionTopicMap", "", "", "Lcom/gojek/courier/QoS;", "disconnect", "getConnectListener", "Lorg/eclipse/paho/client/mqttv3/IMqttActionListener;", "getMqttAsyncClient", "clientId", "getMqttCallback", "Lorg/eclipse/paho/client/mqttv3/MqttCallback;", "getPahoExperimentsConfig", "Lorg/eclipse/paho/client/mqttv3/IExperimentsConfig;", "getServerURI", "getServerUri", "getSubscribeListener", "topicMap", "getUnsubscribeListener", "topics", "", "getUserPropertyList", "", "Lorg/eclipse/paho/client/mqttv3/internal/wire/UserProperty;", "userPropertiesMap", "handleDisconnect", "handleException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reconnect", "isConnected", "isConnecting", "isDisconnected", "isDisconnecting", "isForceDisconnect", "isPasswordExpired", "passwordExpiry", "isSSL", "publish", "mqttPacket", "Lcom/gojek/mqtt/client/model/MqttSendPacket;", "qos", "", "topic", "resetConnectionVariables", "resetParams", "shutDown", "subscribe", "unsubscribe", "Companion", "mqtt-client_release"})
public final class MqttConnection
implements IMqttConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ConnectionConfig connectionConfig;
    @NotNull
    private final IRunnableScheduler runnableScheduler;
    @NotNull
    private final NetworkUtils networkUtils;
    @NotNull
    private final WakeLockProvider wakeLockProvider;
    @NotNull
    private final IMessageSendListener messageSendListener;
    @NotNull
    private final PahoPersistence pahoPersistence;
    @NotNull
    private final NetworkHandler networkHandler;
    @NotNull
    private final MqttPingSender mqttPingSender;
    @NotNull
    private final KeepAliveFailureHandler keepAliveFailureHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final SubscriptionStore subscriptionStore;
    private boolean forceDisconnect;
    private volatile boolean pushReConnect;
    private volatile short fastReconnect;
    @Nullable
    private org.eclipse.paho.client.mqttv3.MqttConnectOptions options;
    @Nullable
    private MqttAsyncClient mqtt;
    private volatile boolean updatePolicyParams;
    @NotNull
    private final IConnectRetryTimePolicy connectRetryTimePolicy;
    @NotNull
    private final IConnectTimeoutPolicy connectTimeoutPolicy;
    private IHostFallbackPolicy hostFallbackPolicy;
    @NotNull
    private final ISubscriptionRetryPolicy subscriptionPolicy;
    @NotNull
    private final ISubscriptionRetryPolicy unsubscriptionPolicy;
    @NotNull
    private final com.gojek.courier.logging.ILogger logger;
    @NotNull
    private final MqttExceptionHandler mqttExceptionHandler;
    @Nullable
    private ServerUri serverUri;
    private long connectStartTime;
    private long connectSuccessTime;
    @NotNull
    public static final String TAG = "MqttConnectionV2";

    public MqttConnection(@NotNull Context context, @NotNull ConnectionConfig connectionConfig, @NotNull IRunnableScheduler runnableScheduler, @NotNull NetworkUtils networkUtils, @NotNull WakeLockProvider wakeLockProvider, @NotNull IMessageSendListener messageSendListener, @NotNull PahoPersistence pahoPersistence, @NotNull NetworkHandler networkHandler, @NotNull MqttPingSender mqttPingSender, @NotNull KeepAliveFailureHandler keepAliveFailureHandler, @NotNull Clock clock, @NotNull SubscriptionStore subscriptionStore) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        Intrinsics.checkNotNullParameter((Object)runnableScheduler, (String)"runnableScheduler");
        Intrinsics.checkNotNullParameter((Object)networkUtils, (String)"networkUtils");
        Intrinsics.checkNotNullParameter((Object)wakeLockProvider, (String)"wakeLockProvider");
        Intrinsics.checkNotNullParameter((Object)messageSendListener, (String)"messageSendListener");
        Intrinsics.checkNotNullParameter((Object)pahoPersistence, (String)"pahoPersistence");
        Intrinsics.checkNotNullParameter((Object)networkHandler, (String)"networkHandler");
        Intrinsics.checkNotNullParameter((Object)mqttPingSender, (String)"mqttPingSender");
        Intrinsics.checkNotNullParameter((Object)keepAliveFailureHandler, (String)"keepAliveFailureHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)subscriptionStore, (String)"subscriptionStore");
        this.context = context;
        this.connectionConfig = connectionConfig;
        this.runnableScheduler = runnableScheduler;
        this.networkUtils = networkUtils;
        this.wakeLockProvider = wakeLockProvider;
        this.messageSendListener = messageSendListener;
        this.pahoPersistence = pahoPersistence;
        this.networkHandler = networkHandler;
        this.mqttPingSender = mqttPingSender;
        this.keepAliveFailureHandler = keepAliveFailureHandler;
        this.clock = clock;
        this.subscriptionStore = subscriptionStore;
        this.connectStartTime = this.clock.nanoTime();
        this.connectSuccessTime = this.clock.nanoTime();
        this.connectRetryTimePolicy = this.connectionConfig.getConnectRetryTimePolicy();
        this.connectTimeoutPolicy = this.connectionConfig.getConnectTimeoutPolicy();
        this.subscriptionPolicy = this.connectionConfig.getSubscriptionRetryPolicy();
        this.unsubscriptionPolicy = this.connectionConfig.getUnsubscriptionRetryPolicy();
        this.logger = this.connectionConfig.getLogger();
        this.mqttExceptionHandler = new MqttExceptionHandlerImpl(this.runnableScheduler, this.connectRetryTimePolicy, this.logger, null, 8, null);
    }

    @Override
    public void connect(@NotNull MqttConnectOptions mqttConnectOptions, @NotNull IMessageReceiveListener messageReceiveListener, @NotNull IHostFallbackPolicy hostFallbackPolicy, @NotNull Map<String, ? extends QoS> subscriptionTopicMap) {
        Intrinsics.checkNotNullParameter((Object)mqttConnectOptions, (String)"mqttConnectOptions");
        Intrinsics.checkNotNullParameter((Object)messageReceiveListener, (String)"messageReceiveListener");
        Intrinsics.checkNotNullParameter((Object)hostFallbackPolicy, (String)"hostFallbackPolicy");
        Intrinsics.checkNotNullParameter(subscriptionTopicMap, (String)"subscriptionTopicMap");
        try {
            MqttConnectOptions connectOptions = mqttConnectOptions;
            this.hostFallbackPolicy = hostFallbackPolicy;
            if (this.forceDisconnect) {
                this.logger.d(TAG, "Force disconnect is in progress");
                this.connectionConfig.getConnectionEventHandler().onMqttConnectDiscarded("Force Disconnect in progress");
                return;
            }
            if (this.updatePolicyParams && !this.isConnected() && !this.isConnecting() && !this.isDisconnecting()) {
                this.connectTimeoutPolicy.updateParams(true);
                this.updatePolicyParams = false;
            }
            String clientId = connectOptions.getClientId();
            this.serverUri = this.getServerUri();
            this.logger.d(TAG, "clientId : " + clientId + "  serverUri " + this.serverUri);
            if (this.mqtt == null) {
                MqttAsyncClient mqttAsyncClient = this.mqtt = this.getMqttAsyncClient(clientId, String.valueOf(this.serverUri));
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.setCallback(this.getMqttCallback(messageReceiveListener));
                MqttAsyncClient mqttAsyncClient2 = this.mqtt;
                Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                this.logger.d(TAG, Intrinsics.stringPlus((String)"Number of max inflight msgs allowed : ", (Object)mqttAsyncClient2.getMaxflightMessages()));
            }
            if (this.isConnected()) {
                this.logger.d(TAG, "Client already connected!!!");
                this.connectionConfig.getConnectionEventHandler().onMqttConnectDiscarded("Client already connected");
                return;
            }
            if (this.isDisconnecting()) {
                this.logger.d(TAG, "Client is disconnecting!!!");
                this.connectionConfig.getConnectionEventHandler().onMqttConnectDiscarded("Client disconnecting");
                return;
            }
            if (this.isConnecting()) {
                this.logger.d(TAG, "Client is already connecting!!!");
                this.connectionConfig.getConnectionEventHandler().onMqttConnectDiscarded("Client connecting");
                return;
            }
            this.wakeLockProvider.acquireWakeLock(this.connectionConfig.getWakeLockTimeout());
            MqttAsyncClient mqttAsyncClient = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            mqttAsyncClient.setClientId(clientId);
            MqttAsyncClient mqttAsyncClient3 = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient3);
            mqttAsyncClient3.setServerURI(String.valueOf(this.serverUri));
            if (this.options == null) {
                this.options = new org.eclipse.paho.client.mqttv3.MqttConnectOptions();
            }
            if (this.isSSL()) {
                org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions2 = this.options;
                Intrinsics.checkNotNull((Object)mqttConnectOptions2);
                mqttConnectOptions2.setSocketFactory(this.connectionConfig.getSocketFactory());
            } else {
                org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions3 = this.options;
                Intrinsics.checkNotNull((Object)mqttConnectOptions3);
                mqttConnectOptions3.setSocketFactory(null);
            }
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions4 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions4);
            mqttConnectOptions4.setUserName(connectOptions.getUsername());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions5 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions5);
            String string = connectOptions.getPassword();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            mqttConnectOptions5.setPassword(cArray);
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions6 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions6);
            mqttConnectOptions6.setCleanSession(connectOptions.isCleanSession());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions7 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions7);
            mqttConnectOptions7.setKeepAliveInterval(connectOptions.getKeepAlive().getTimeSeconds());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions8 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions8);
            mqttConnectOptions8.setKeepAliveIntervalServer(connectOptions.getKeepAlive().getTimeSeconds());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions9 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions9);
            mqttConnectOptions9.setReadTimeout(connectOptions.getReadTimeoutSecs() == -1 ? connectOptions.getKeepAlive().getTimeSeconds() + 60 : connectOptions.getReadTimeoutSecs());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions10 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions10);
            mqttConnectOptions10.setConnectionTimeout(this.connectTimeoutPolicy.getConnectTimeOut());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions11 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions11);
            mqttConnectOptions11.setHandshakeTimeout(this.connectTimeoutPolicy.getHandshakeTimeOut());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions12 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions12);
            mqttConnectOptions12.setProtocolName(mqttConnectOptions.getVersion().getProtocolName$mqtt_client_release());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions13 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions13);
            mqttConnectOptions13.setProtocolLevel(mqttConnectOptions.getVersion().getProtocolLevel$mqtt_client_release());
            org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions14 = this.options;
            Intrinsics.checkNotNull((Object)mqttConnectOptions14);
            mqttConnectOptions14.setUserPropertyList(this.getUserPropertyList(connectOptions.getUserPropertiesMap()));
            MqttAsyncClient mqttAsyncClient4 = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient4);
            this.logger.d(TAG, Intrinsics.stringPlus((String)"MQTT connecting on : ", (Object)mqttAsyncClient4.getServerURI()));
            this.updatePolicyParams = true;
            this.connectStartTime = this.clock.nanoTime();
            this.connectionConfig.getConnectionEventHandler().onMqttConnectAttempt(connectOptions.getKeepAlive().isOptimal$mqtt_client_release(), this.serverUri);
            MqttAsyncClient mqttAsyncClient5 = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient5);
            mqttAsyncClient5.connect(this.options, null, this.getConnectListener(subscriptionTopicMap));
            this.runnableScheduler.scheduleNextActivityCheck();
        }
        catch (MqttSecurityException e) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"mqtt security exception while connecting ", (Object)((Object)e)));
            this.connectionConfig.getConnectionEventHandler().onMqttConnectFailure(e, this.serverUri, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - this.connectStartTime)));
            this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)e), false);
            this.wakeLockProvider.releaseWakeLock();
        }
        catch (MqttException e) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"Connect exception : ", (Object)e.getReasonCode()));
            this.connectionConfig.getConnectionEventHandler().onMqttConnectFailure(e, this.serverUri, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - this.connectStartTime)));
            this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)e), true);
            this.wakeLockProvider.releaseWakeLock();
        }
        catch (Exception e) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"Connect exception : ", (Object)e.getMessage()));
            this.connectionConfig.getConnectionEventHandler().onMqttConnectFailure(e, this.serverUri, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - this.connectStartTime)));
            MqttException mqttException = new MqttException(6, (Throwable)e);
            this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)mqttException), true);
            this.wakeLockProvider.releaseWakeLock();
        }
    }

    @Override
    public void publish(@NotNull MqttSendPacket mqttPacket, int qos, @NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)mqttPacket, (String)"mqttPacket");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        MqttAsyncClient mqttAsyncClient = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        this.logger.d(TAG, Intrinsics.stringPlus((String)"Current inflight msg count : ", (Object)mqttAsyncClient.getInflightMessages()));
        MqttAsyncClient mqttAsyncClient2 = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient2);
        mqttAsyncClient2.publish(topic, mqttPacket.getMessage(), qos, false, (Object)mqttPacket, (IMqttActionListener)new IMqttActionListenerNew(this){
            final /* synthetic */ MqttConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@NotNull IMqttToken arg0) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                MqttConnection.access$getLogger$p(this.this$0).d("MqttConnectionV2", Intrinsics.stringPlus((String)"Message successfully sent for message id : ", (Object)arg0.getMessageId()));
                Object object = arg0.getUserContext();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.client.model.MqttSendPacket");
                }
                MqttSendPacket packet = (MqttSendPacket)object;
                MqttConnection.access$getMessageSendListener$p(this.this$0).onSuccess(packet);
            }

            public void onFailure(@NotNull IMqttToken arg0, @NotNull Throwable arg1) {
                Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
                MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Message delivery failed for : " + arg0.getMessageId() + ", exception : " + arg1.getMessage());
                Object object = arg0.getUserContext();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.client.model.MqttSendPacket");
                }
                MqttConnection.access$getMessageSendListener$p(this.this$0).onFailure((MqttSendPacket)object, arg1);
            }

            public void notifyWrittenOnSocket(@NotNull IMqttToken token) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Object object = token.getUserContext();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.client.model.MqttSendPacket");
                }
                MqttSendPacket packet = (MqttSendPacket)object;
                MqttConnection.access$getMessageSendListener$p(this.this$0).notifyWrittenOnSocket(packet);
            }
        });
    }

    @Override
    public void handleException(@Nullable Exception exception, boolean reconnect) {
        if (exception == null || !(exception instanceof MqttException)) {
            return;
        }
        this.mqttExceptionHandler.handleException((MqttException)((Object)exception), reconnect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConnected() {
        if (this.mqtt == null) return false;
        MqttAsyncClient mqttAsyncClient = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        if (!mqttAsyncClient.isConnected()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConnecting() {
        if (this.mqtt == null) return false;
        MqttAsyncClient mqttAsyncClient = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        if (!mqttAsyncClient.isConnecting()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDisconnecting() {
        if (this.mqtt == null) return false;
        MqttAsyncClient mqttAsyncClient = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        if (!mqttAsyncClient.isDisconnecting()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDisconnected() {
        if (this.mqtt == null) return false;
        MqttAsyncClient mqttAsyncClient = this.mqtt;
        Intrinsics.checkNotNull((Object)mqttAsyncClient);
        if (!mqttAsyncClient.isDisconnected()) return false;
        return true;
    }

    @Override
    public boolean isForceDisconnect() {
        return this.forceDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        block12: {
            try {
                block14: {
                    block13: {
                        if (this.mqtt == null) break block12;
                        MqttAsyncClient mqttAsyncClient = this.mqtt;
                        Intrinsics.checkNotNull((Object)mqttAsyncClient);
                        if (mqttAsyncClient.isDisconnecting()) break block13;
                        MqttAsyncClient mqttAsyncClient2 = this.mqtt;
                        Intrinsics.checkNotNull((Object)mqttAsyncClient2);
                        if (!mqttAsyncClient2.isDisconnected()) break block14;
                    }
                    this.logger.d(TAG, "not connected but disconnecting");
                    MqttAsyncClient mqttAsyncClient = this.mqtt;
                    Intrinsics.checkNotNull((Object)mqttAsyncClient);
                    if (mqttAsyncClient.isDisconnecting()) {
                        this.logger.d(TAG, "already disconnecting");
                    } else {
                        MqttAsyncClient mqttAsyncClient3 = this.mqtt;
                        Intrinsics.checkNotNull((Object)mqttAsyncClient3);
                        if (mqttAsyncClient3.isDisconnected()) {
                            this.logger.d(TAG, "already disconnected");
                        }
                    }
                    return;
                }
                this.forceDisconnect = true;
                this.connectionConfig.getConnectionEventHandler().onMqttDisconnectStart();
                MqttAsyncClient mqttAsyncClient = this.mqtt;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.disconnectForcibly((long)this.connectionConfig.getQuiesceTimeout(), (long)this.connectionConfig.getDisconnectTimeout());
            }
            catch (Exception e) {
                this.logger.e(TAG, "exception while disconnecting mqtt", (Throwable)e);
            }
            finally {
                this.handleDisconnect();
                this.connectionConfig.getConnectionEventHandler().onMqttDisconnectComplete();
            }
        }
    }

    private final List<UserProperty> getUserPropertyList(Map<String, String> userPropertiesMap) {
        boolean bl = false;
        List userProperties = new ArrayList();
        Iterable $this$forEach$iv = userPropertiesMap.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            userProperties.add(new UserProperty((String)entry.getKey(), (String)entry.getValue()));
        }
        return userProperties;
    }

    private final boolean isPasswordExpired(long passwordExpiry) {
        if (passwordExpiry == -1L) {
            return false;
        }
        return SystemClock.elapsedRealtime() >= passwordExpiry;
    }

    private final void handleDisconnect() {
        this.resetConnectionVariables();
    }

    @Override
    public void shutDown() {
        try {
            if (this.mqtt != null) {
                MqttAsyncClient mqttAsyncClient = this.mqtt;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.close();
            }
        }
        catch (Exception e) {
            this.logger.e(TAG, "exception while closing mqtt connection", (Throwable)e);
        }
        this.mqtt = null;
        this.options = null;
    }

    private final void resetConnectionVariables() {
        this.forceDisconnect = false;
        this.updatePolicyParams = false;
        this.connectTimeoutPolicy.resetParams();
    }

    @Override
    @Nullable
    public String getServerURI() {
        String string;
        if (this.mqtt == null) {
            string = null;
        } else {
            MqttAsyncClient mqttAsyncClient = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            string = mqttAsyncClient.getServerURI();
        }
        return string;
    }

    private final ServerUri getServerUri() {
        IHostFallbackPolicy iHostFallbackPolicy;
        IHostFallbackPolicy iHostFallbackPolicy2 = this.hostFallbackPolicy;
        if (iHostFallbackPolicy2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostFallbackPolicy");
            iHostFallbackPolicy = null;
        } else {
            iHostFallbackPolicy = iHostFallbackPolicy2;
        }
        return iHostFallbackPolicy.getServerUri();
    }

    @Override
    public void checkActivity() {
        if (this.mqtt != null) {
            MqttAsyncClient mqttAsyncClient = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            mqttAsyncClient.checkActivity();
        }
    }

    @Override
    public void resetParams() {
        this.connectRetryTimePolicy.resetParams();
    }

    private final MqttAsyncClient getMqttAsyncClient(String clientId, String serverUri) {
        MqttAsyncClient mqttAsyncClient = new MqttAsyncClient(serverUri, clientId, null, (MqttClientPersistence)this.pahoPersistence, this.connectionConfig.getMaxInflightMessages(), MqttPingSenderKt.toPahoPingSender((MqttPingSender)this.mqttPingSender), (ILogger)new PahoLogger(this.connectionConfig.getLogger()), (IPahoEvents)new PahoEventHandler(this.connectionConfig.getConnectionEventHandler()), this.getPahoExperimentsConfig(), this.connectionConfig.getMqttInterceptorList());
        DisconnectedBufferOptions bufferOptions = new DisconnectedBufferOptions();
        PersistenceOptions.PahoPersistenceOptions pahoPersistenceOptions = (PersistenceOptions.PahoPersistenceOptions)this.connectionConfig.getPersistenceOptions();
        boolean bl = false;
        boolean bl2 = false;
        PersistenceOptions.PahoPersistenceOptions $this$getMqttAsyncClient_u24lambda_u2d1 = pahoPersistenceOptions;
        boolean bl3 = false;
        bufferOptions.setBufferEnabled(true);
        bufferOptions.setPersistBuffer(true);
        bufferOptions.setBufferSize($this$getMqttAsyncClient_u24lambda_u2d1.getBufferCapacity());
        bufferOptions.setDeleteOldestMessages($this$getMqttAsyncClient_u24lambda_u2d1.isDeleteOldestMessages());
        mqttAsyncClient.setBufferOpts(bufferOptions);
        return mqttAsyncClient;
    }

    private final IMqttActionListener getConnectListener(Map<String, ? extends QoS> subscriptionTopicMap) {
        return new IMqttActionListener(this){
            final /* synthetic */ MqttConnection this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@NotNull IMqttToken iMqttToken) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                try {
                    MqttConnection.access$setPushReConnect$p(this.this$0, false);
                    MqttConnection.access$setFastReconnect$p(this.this$0, (short)0);
                    MqttConnection.access$setConnectSuccessTime$p(this.this$0, MqttConnection.access$getClock$p(this.this$0).nanoTime());
                    MqttConnection.access$getRunnableScheduler$p(this.this$0).scheduleResetParams((long)MqttConnection.access$getConnectionConfig$p(this.this$0).getPolicyResetTimeSeconds() * 1000L);
                    MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttConnectSuccess(MqttConnection.access$getServerUri$p(this.this$0), TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getConnectSuccessTime$p(this.this$0) - MqttConnection.access$getConnectStartTime$p(this.this$0))));
                    MqttConnection.access$getRunnableScheduler$p(this.this$0).scheduleSubscribe(0L, MqttConnection.access$getSubscriptionStore$p(this.this$0).getSubscribeTopics());
                    IRunnableScheduler iRunnableScheduler = MqttConnection.access$getRunnableScheduler$p(this.this$0);
                    SubscriptionStore subscriptionStore = MqttConnection.access$getSubscriptionStore$p(this.this$0);
                    org.eclipse.paho.client.mqttv3.MqttConnectOptions mqttConnectOptions = MqttConnection.access$getOptions$p(this.this$0);
                    Intrinsics.checkNotNull((Object)mqttConnectOptions);
                    iRunnableScheduler.scheduleUnsubscribe(0L, subscriptionStore.getUnsubscribeTopics(mqttConnectOptions.isCleanSession()));
                }
                finally {
                    MqttConnection.access$getWakeLockProvider$p(this.this$0).releaseWakeLock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(@NotNull IMqttToken iMqttToken, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                try {
                    IHostFallbackPolicy iHostFallbackPolicy;
                    IHostFallbackPolicy iHostFallbackPolicy2;
                    if (throwable instanceof MqttException) {
                        MqttConnection.access$getRunnableScheduler$p(this.this$0).scheduleMqttHandleExceptionRunnable((Exception)throwable, true);
                    }
                    if ((iHostFallbackPolicy2 = MqttConnection.access$getHostFallbackPolicy$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"hostFallbackPolicy");
                        iHostFallbackPolicy = null;
                    } else {
                        iHostFallbackPolicy = iHostFallbackPolicy2;
                    }
                    iHostFallbackPolicy.onConnectFailure(throwable);
                    MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttConnectFailure(throwable, MqttConnection.access$getServerUri$p(this.this$0), TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - MqttConnection.access$getConnectStartTime$p(this.this$0))));
                }
                catch (Exception e) {
                    MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Exception in connect failure callback", (Throwable)e);
                }
                finally {
                    MqttConnection.access$getWakeLockProvider$p(this.this$0).releaseWakeLock();
                }
            }
        };
    }

    @Override
    public void subscribe(@NotNull Map<String, ? extends QoS> topicMap) {
        Intrinsics.checkNotNullParameter(topicMap, (String)"topicMap");
        Map<String, ? extends QoS> map = topicMap;
        boolean bl = false;
        if (!map.isEmpty()) {
            Collection $this$toTypedArray$iv = topicMap.keySet();
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] topicArray = stringArray;
            int[] qosArray = new int[topicMap.size()];
            Iterator<? extends QoS> $i$f$toTypedArray22 = topicMap.values().iterator();
            int n = 0;
            while ($i$f$toTypedArray22.hasNext()) {
                int index = n++;
                QoS qos = $i$f$toTypedArray22.next();
                qosArray[index] = qos.getValue();
            }
            long subscribeStartTime = this.clock.nanoTime();
            try {
                this.logger.d(TAG, Intrinsics.stringPlus((String)"Subscribing to topics: ", topicMap.keySet()));
                this.connectionConfig.getConnectionEventHandler().onMqttSubscribeAttempt(topicMap);
                MqttAsyncClient mqttAsyncClient = this.mqtt;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                mqttAsyncClient.subscribe(topicArray, qosArray, (Object)new MqttContext(subscribeStartTime), this.getSubscribeListener(topicMap));
            }
            catch (MqttException mqttException) {
                this.connectionConfig.getConnectionEventHandler().onMqttSubscribeFailure(topicMap, mqttException, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - subscribeStartTime)));
                this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)mqttException), true);
            }
        }
    }

    @Override
    public void unsubscribe(@NotNull Set<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Collection collection = topics;
        boolean bl = false;
        if (!collection.isEmpty()) {
            long unsubscribeStartTime = this.clock.nanoTime();
            try {
                this.logger.d(TAG, Intrinsics.stringPlus((String)"Unsubscribing to topics: ", topics));
                this.connectionConfig.getConnectionEventHandler().onMqttUnsubscribeAttempt(topics);
                MqttAsyncClient mqttAsyncClient = this.mqtt;
                Intrinsics.checkNotNull((Object)mqttAsyncClient);
                Collection $this$toTypedArray$iv = topics;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                mqttAsyncClient.unsubscribe(stringArray, (Object)new MqttContext(unsubscribeStartTime), this.getUnsubscribeListener(topics));
            }
            catch (MqttException mqttException) {
                this.connectionConfig.getConnectionEventHandler().onMqttUnsubscribeFailure(topics, mqttException, TimeUnitExtensionsKt.fromNanosToMillis((long)(this.clock.nanoTime() - unsubscribeStartTime)));
                this.runnableScheduler.scheduleMqttHandleExceptionRunnable((Exception)((Object)mqttException), true);
            }
        }
    }

    private final IMqttActionListener getSubscribeListener(Map<String, ? extends QoS> topicMap) {
        return new IMqttActionListener(this, topicMap){
            final /* synthetic */ MqttConnection this$0;
            final /* synthetic */ Map<String, QoS> $topicMap;
            {
                this.this$0 = $receiver;
                this.$topicMap = $topicMap;
            }

            public void onSuccess(@NotNull IMqttToken iMqttToken) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                MqttConnection.access$getLogger$p(this.this$0).d("MqttConnectionV2", "Subscribe successful. Connect Complete");
                Object object = iMqttToken.getUserContext();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.connection.MqttContext");
                }
                MqttContext context = (MqttContext)object;
                MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttSubscribeSuccess(this.$topicMap, TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - context.getStartTime())));
                MqttConnection.access$getSubscriptionPolicy$p(this.this$0).resetParams();
                MqttConnection.access$getSubscriptionStore$p(this.this$0).getListener().onTopicsSubscribed(this.$topicMap);
            }

            public void onFailure(@NotNull IMqttToken iMqttToken, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (MqttConnection.access$getSubscriptionPolicy$p(this.this$0).shouldRetry()) {
                    MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Subscribe unsuccessful. Will retry again");
                    MqttConnection.access$getRunnableScheduler$p(this.this$0).scheduleSubscribe(10L, this.$topicMap);
                } else {
                    MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Subscribe unsuccessful. Will reconnect again");
                    Object object = iMqttToken.getUserContext();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.connection.MqttContext");
                    }
                    MqttContext context = (MqttContext)object;
                    MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttSubscribeFailure(this.$topicMap, throwable, TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - context.getStartTime())));
                    IRunnableScheduler.DefaultImpls.disconnectMqtt$default(MqttConnection.access$getRunnableScheduler$p(this.this$0), true, false, 2, null);
                }
            }
        };
    }

    private final IMqttActionListener getUnsubscribeListener(Set<String> topics) {
        return new IMqttActionListener(this, topics){
            final /* synthetic */ MqttConnection this$0;
            final /* synthetic */ Set<String> $topics;
            {
                this.this$0 = $receiver;
                this.$topics = $topics;
            }

            public void onSuccess(@NotNull IMqttToken iMqttToken) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                MqttConnection.access$getLogger$p(this.this$0).d("MqttConnectionV2", "Unsubscribe successful");
                Object object = iMqttToken.getUserContext();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.connection.MqttContext");
                }
                MqttContext context = (MqttContext)object;
                MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttUnsubscribeSuccess(this.$topics, TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - context.getStartTime())));
                MqttConnection.access$getUnsubscriptionPolicy$p(this.this$0).resetParams();
                MqttConnection.access$getSubscriptionStore$p(this.this$0).getListener().onTopicsUnsubscribed(this.$topics);
            }

            public void onFailure(@NotNull IMqttToken iMqttToken, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)iMqttToken, (String)"iMqttToken");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (MqttConnection.access$getUnsubscriptionPolicy$p(this.this$0).shouldRetry()) {
                    MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Unsubscribe unsuccessful. Will retry again");
                    MqttConnection.access$getRunnableScheduler$p(this.this$0).scheduleUnsubscribe(10L, this.$topics);
                } else {
                    MqttConnection.access$getLogger$p(this.this$0).e("MqttConnectionV2", "Unsubscribe unsuccessful. Will reconnect again");
                    Object object = iMqttToken.getUserContext();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.gojek.mqtt.connection.MqttContext");
                    }
                    MqttContext context = (MqttContext)object;
                    MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttUnsubscribeFailure(this.$topics, throwable, TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - context.getStartTime())));
                    IRunnableScheduler.DefaultImpls.disconnectMqtt$default(MqttConnection.access$getRunnableScheduler$p(this.this$0), true, false, 2, null);
                }
            }
        };
    }

    private final MqttCallback getMqttCallback(IMessageReceiveListener messageReceiveListener) {
        return new MqttCallback(this, messageReceiveListener){
            final /* synthetic */ MqttConnection this$0;
            final /* synthetic */ IMessageReceiveListener $messageReceiveListener;
            {
                this.this$0 = $receiver;
                this.$messageReceiveListener = $messageReceiveListener;
            }

            public void connectionLost(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                MqttConnection.access$getLogger$p(this.this$0).w("MqttConnectionV2", Intrinsics.stringPlus((String)"Connection Lost : ", (Object)throwable.getMessage()));
                if (MqttConnection.access$getNetworkUtils$p(this.this$0).isConnected(MqttConnection.access$getContext$p(this.this$0))) {
                    MqttConnection.access$getKeepAliveFailureHandler$p(this.this$0).handleKeepAliveFailure();
                }
                int connRetryTimeSecs = MqttConnection.access$getConnectRetryTimePolicy$p(this.this$0).getConnRetryTimeSecs();
                MqttConnection.access$getRunnableScheduler$p(this.this$0).connectMqtt((long)connRetryTimeSecs * 1000L);
                MqttConnection.access$getConnectionConfig$p(this.this$0).getConnectionEventHandler().onMqttConnectionLost(throwable, MqttConnection.access$getServerUri$p(this.this$0), connRetryTimeSecs, TimeUnitExtensionsKt.fromNanosToMillis((long)(MqttConnection.access$getClock$p(this.this$0).nanoTime() - MqttConnection.access$getConnectSuccessTime$p(this.this$0))));
            }

            public boolean messageArrived(@NotNull String topic, @NotNull MqttMessage mqttMessage) throws Exception {
                Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
                Intrinsics.checkNotNullParameter((Object)mqttMessage, (String)"mqttMessage");
                byte[] byArray = mqttMessage.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mqttMessage.payload");
                return this.$messageReceiveListener.messageArrived(topic, byArray);
            }

            public void deliveryComplete(@NotNull IMqttDeliveryToken iMqttDeliveryToken) {
                Intrinsics.checkNotNullParameter((Object)iMqttDeliveryToken, (String)"iMqttDeliveryToken");
            }

            public void fastReconnect() {
            }
        };
    }

    private final IExperimentsConfig getPahoExperimentsConfig() {
        return new IExperimentsConfig(this){
            final /* synthetic */ MqttConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public int inactivityTimeoutSecs() {
                return MqttConnection.access$getConnectionConfig$p(this.this$0).getInactivityTimeoutSeconds();
            }
        };
    }

    private final boolean isSSL() {
        if (this.mqtt != null) {
            MqttAsyncClient mqttAsyncClient = this.mqtt;
            Intrinsics.checkNotNull((Object)mqttAsyncClient);
            String uri = mqttAsyncClient.getServerURI();
            return uri != null && StringsKt.startsWith$default((String)uri, (String)"ssl", (boolean)false, (int)2, null);
        }
        return false;
    }

    public static final /* synthetic */ com.gojek.courier.logging.ILogger access$getLogger$p(MqttConnection $this) {
        return $this.logger;
    }

    public static final /* synthetic */ IMessageSendListener access$getMessageSendListener$p(MqttConnection $this) {
        return $this.messageSendListener;
    }

    public static final /* synthetic */ void access$setPushReConnect$p(MqttConnection $this, boolean bl) {
        $this.pushReConnect = bl;
    }

    public static final /* synthetic */ void access$setFastReconnect$p(MqttConnection $this, short s) {
        $this.fastReconnect = s;
    }

    public static final /* synthetic */ void access$setConnectSuccessTime$p(MqttConnection $this, long l) {
        $this.connectSuccessTime = l;
    }

    public static final /* synthetic */ Clock access$getClock$p(MqttConnection $this) {
        return $this.clock;
    }

    public static final /* synthetic */ IRunnableScheduler access$getRunnableScheduler$p(MqttConnection $this) {
        return $this.runnableScheduler;
    }

    public static final /* synthetic */ ConnectionConfig access$getConnectionConfig$p(MqttConnection $this) {
        return $this.connectionConfig;
    }

    public static final /* synthetic */ ServerUri access$getServerUri$p(MqttConnection $this) {
        return $this.serverUri;
    }

    public static final /* synthetic */ long access$getConnectSuccessTime$p(MqttConnection $this) {
        return $this.connectSuccessTime;
    }

    public static final /* synthetic */ long access$getConnectStartTime$p(MqttConnection $this) {
        return $this.connectStartTime;
    }

    public static final /* synthetic */ SubscriptionStore access$getSubscriptionStore$p(MqttConnection $this) {
        return $this.subscriptionStore;
    }

    public static final /* synthetic */ org.eclipse.paho.client.mqttv3.MqttConnectOptions access$getOptions$p(MqttConnection $this) {
        return $this.options;
    }

    public static final /* synthetic */ WakeLockProvider access$getWakeLockProvider$p(MqttConnection $this) {
        return $this.wakeLockProvider;
    }

    public static final /* synthetic */ IHostFallbackPolicy access$getHostFallbackPolicy$p(MqttConnection $this) {
        return $this.hostFallbackPolicy;
    }

    public static final /* synthetic */ ISubscriptionRetryPolicy access$getSubscriptionPolicy$p(MqttConnection $this) {
        return $this.subscriptionPolicy;
    }

    public static final /* synthetic */ ISubscriptionRetryPolicy access$getUnsubscriptionPolicy$p(MqttConnection $this) {
        return $this.unsubscriptionPolicy;
    }

    public static final /* synthetic */ NetworkUtils access$getNetworkUtils$p(MqttConnection $this) {
        return $this.networkUtils;
    }

    public static final /* synthetic */ Context access$getContext$p(MqttConnection $this) {
        return $this.context;
    }

    public static final /* synthetic */ KeepAliveFailureHandler access$getKeepAliveFailureHandler$p(MqttConnection $this) {
        return $this.keepAliveFailureHandler;
    }

    public static final /* synthetic */ IConnectRetryTimePolicy access$getConnectRetryTimePolicy$p(MqttConnection $this) {
        return $this.connectRetryTimePolicy;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/gojek/mqtt/connection/MqttConnection$Companion;", "", "()V", "TAG", "", "mqtt-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

