/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.event;

import com.gojek.mqtt.event.EventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.exception.CourierExceptionKt;
import com.gojek.mqtt.pingsender.IPingSenderEvents;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/gojek/mqtt/event/PingEventHandler;", "Lcom/gojek/mqtt/pingsender/IPingSenderEvents;", "eventHandler", "Lcom/gojek/mqtt/event/EventHandler;", "(Lcom/gojek/mqtt/event/EventHandler;)V", "exceptionInStart", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "mqttPingInitiated", "serverUri", "", "keepAliveSecs", "", "mqttPingScheduled", "nextPingTimeSecs", "onBackgroundAlarmPingLimitReached", "pingEventFailure", "timeTaken", "exception", "", "pingEventSuccess", "pingMqttTokenNull", "mqtt-client_release"})
public final class PingEventHandler
implements IPingSenderEvents {
    @NotNull
    private final EventHandler eventHandler;

    public PingEventHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.eventHandler = eventHandler;
    }

    public void exceptionInStart(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.eventHandler.onEvent(new MqttEvent.MqttPingExceptionEvent(CourierExceptionKt.toCourierException(e), false, null, 4, null));
    }

    public void mqttPingScheduled(long nextPingTimeSecs, long keepAliveSecs) {
        this.eventHandler.onEvent(new MqttEvent.MqttPingScheduledEvent(nextPingTimeSecs, keepAliveSecs, false, null, 8, null));
    }

    public void mqttPingInitiated(@NotNull String serverUri, long keepAliveSecs) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        this.eventHandler.onEvent(new MqttEvent.MqttPingInitiatedEvent(serverUri, keepAliveSecs, false, null, 8, null));
    }

    public void pingMqttTokenNull(@NotNull String serverUri, long keepAliveSecs) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        this.eventHandler.onEvent(new MqttEvent.MqttPingCancelledEvent(serverUri, keepAliveSecs, false, null, 8, null));
    }

    public void pingEventSuccess(@NotNull String serverUri, long timeTaken, long keepAliveSecs) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        this.eventHandler.onEvent(new MqttEvent.MqttPingSuccessEvent(serverUri, timeTaken, keepAliveSecs, false, null, 16, null));
    }

    public void pingEventFailure(@NotNull String serverUri, long timeTaken, @NotNull Throwable exception, long keepAliveSecs) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.eventHandler.onEvent(new MqttEvent.MqttPingFailureEvent(serverUri, timeTaken, keepAliveSecs, CourierExceptionKt.toCourierException(exception), false, null, 32, null));
    }

    public void onBackgroundAlarmPingLimitReached() {
        this.eventHandler.onEvent(new MqttEvent.BackgroundAlarmPingLimitReached(false, null, 2, null));
    }
}

