/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.exception.handler.v3.impl;

import com.gojek.courier.logging.ILogger;
import com.gojek.mqtt.exception.handler.v3.MqttExceptionHandler;
import com.gojek.mqtt.policies.connectretrytime.IConnectRetryTimePolicy;
import com.gojek.mqtt.scheduler.IRunnableScheduler;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Random;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/gojek/mqtt/exception/handler/v3/impl/MqttExceptionHandlerImpl;", "Lcom/gojek/mqtt/exception/handler/v3/MqttExceptionHandler;", "runnableScheduler", "Lcom/gojek/mqtt/scheduler/IRunnableScheduler;", "connectRetryTimePolicy", "Lcom/gojek/mqtt/policies/connectretrytime/IConnectRetryTimePolicy;", "logger", "Lcom/gojek/courier/logging/ILogger;", "random", "Ljava/util/Random;", "(Lcom/gojek/mqtt/scheduler/IRunnableScheduler;Lcom/gojek/mqtt/policies/connectretrytime/IConnectRetryTimePolicy;Lcom/gojek/courier/logging/ILogger;Ljava/util/Random;)V", "handleDNSException", "", "handleException", "mqttException", "Lorg/eclipse/paho/client/mqttv3/MqttException;", "reconnect", "", "handleOtherException", "handleSSLHandshakeException", "handleSocketException", "handleSocketTimeOutException", "Companion", "mqtt-client_release"})
public final class MqttExceptionHandlerImpl
implements MqttExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IRunnableScheduler runnableScheduler;
    @NotNull
    private final IConnectRetryTimePolicy connectRetryTimePolicy;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Random random;
    @NotNull
    public static final String TAG = "MqttExceptionHandler";

    public MqttExceptionHandlerImpl(@NotNull IRunnableScheduler runnableScheduler, @NotNull IConnectRetryTimePolicy connectRetryTimePolicy, @NotNull ILogger logger, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)runnableScheduler, (String)"runnableScheduler");
        Intrinsics.checkNotNullParameter((Object)connectRetryTimePolicy, (String)"connectRetryTimePolicy");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.runnableScheduler = runnableScheduler;
        this.connectRetryTimePolicy = connectRetryTimePolicy;
        this.logger = logger;
        this.random = random;
    }

    public /* synthetic */ MqttExceptionHandlerImpl(IRunnableScheduler iRunnableScheduler, IConnectRetryTimePolicy iConnectRetryTimePolicy, ILogger iLogger, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            random = new Random();
        }
        this(iRunnableScheduler, iConnectRetryTimePolicy, iLogger, random);
    }

    @Override
    public void handleException(@NotNull MqttException mqttException, boolean reconnect) {
        Intrinsics.checkNotNullParameter((Object)((Object)mqttException), (String)"mqttException");
        short s = (short)mqttException.getReasonCode();
        if (s == 3) {
            this.logger.e(TAG, "Server Unavailable, try reconnecting later");
            int reconnectIn = this.random.nextInt(9) + 1;
            this.runnableScheduler.scheduleNextConnectionCheck((long)reconnectIn * 60L);
        } else if (s == 32101) {
            this.logger.e(TAG, "Client already disconnected.");
            if (reconnect) {
                this.runnableScheduler.connectMqtt((long)this.connectRetryTimePolicy.getConnRetryTimeSecs() * 1000L);
            }
        } else if (s == 32102) {
            if (reconnect) {
                this.runnableScheduler.scheduleNextConnectionCheck(1L);
            }
        } else if (s == 0) {
            this.logger.e(TAG, "Client exception : entered REASON_CODE_CLIENT_EXCEPTION");
            if (mqttException.getCause() == null) {
                this.handleOtherException();
                this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
            } else {
                Throwable throwable = mqttException.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                this.logger.e(TAG, Intrinsics.stringPlus((String)"Exception : ", (Object)throwable.getMessage()));
                if (mqttException.getCause() instanceof UnknownHostException) {
                    this.handleDNSException();
                } else if (mqttException.getCause() instanceof SocketException) {
                    this.handleSocketException();
                } else if (mqttException.getCause() instanceof SocketTimeoutException) {
                    this.handleSocketTimeOutException();
                } else if (mqttException.getCause() instanceof UnresolvedAddressException) {
                    this.handleDNSException();
                } else if (mqttException.getCause() instanceof SSLHandshakeException) {
                    this.handleSSLHandshakeException();
                } else {
                    this.handleOtherException();
                    this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
                }
            }
        } else if (s == 32104) {
            if (reconnect) {
                this.runnableScheduler.connectMqtt();
            }
        } else if (s == 32000) {
            if (reconnect) {
                this.runnableScheduler.connectMqtt();
            }
        } else if (s == 32110) {
            this.logger.e(TAG, "Client already in connecting state");
        } else if (s == 32109) {
            if (reconnect) {
                this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
            }
        } else if (s == 32202) {
            this.logger.e(TAG, Intrinsics.stringPlus((String)"There are already to many messages in publish. Exception : ", (Object)mqttException.getMessage()));
        } else if (s == 32103) {
            this.handleOtherException();
            this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
        } else if (s != 32111 && s != 32100 && s != 32107) {
            if (s == 4) {
                this.runnableScheduler.scheduleAuthFailureRunnable();
            } else if (s != 2 && s != 32108 && s != 1 && s != 32001) {
                if (s == 5) {
                    this.runnableScheduler.scheduleAuthFailureRunnable();
                } else if (s != 32105 && s != 32106 && s != 32201) {
                    if (s == 6) {
                        this.handleOtherException();
                        this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
                    } else {
                        this.handleOtherException();
                        this.runnableScheduler.connectMqtt((long)this.connectRetryTimePolicy.getConnRetryTimeSecs() * 1000L);
                    }
                }
            }
        }
    }

    private final void handleOtherException() {
        this.logger.e(TAG, "Client exception : entered handleOtherException");
    }

    private final void handleDNSException() {
        this.logger.e(TAG, "DNS Failure , Connect using ips");
        this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
    }

    private final void handleSocketException() {
        this.logger.e(TAG, "DNS Failure , Connect using ips");
        this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
    }

    private final void handleSocketTimeOutException() {
        this.logger.e(TAG, "Client exception : entered handleSocketTimeOutException");
        this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
    }

    private final void handleSSLHandshakeException() {
        this.logger.e(TAG, "SSLHandshake Failure , Connect using ips");
        this.runnableScheduler.scheduleNextConnectionCheck(this.connectRetryTimePolicy.getConnRetryTimeSecs());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/gojek/mqtt/exception/handler/v3/impl/MqttExceptionHandlerImpl$Companion;", "", "()V", "TAG", "", "mqtt-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

