/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.handler;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import com.gojek.courier.logging.ILogger;
import com.gojek.mqtt.client.IClientSchedulerBridge;
import com.gojek.mqtt.client.model.MqttSendPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/gojek/mqtt/handler/IncomingHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "clientSchedulerBridge", "Lcom/gojek/mqtt/client/IClientSchedulerBridge;", "logger", "Lcom/gojek/courier/logging/ILogger;", "(Landroid/os/Looper;Lcom/gojek/mqtt/client/IClientSchedulerBridge;Lcom/gojek/courier/logging/ILogger;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "mqtt-client_release"})
public final class IncomingHandler
extends Handler {
    @NotNull
    private final IClientSchedulerBridge clientSchedulerBridge;
    @NotNull
    private final ILogger logger;

    public IncomingHandler(@NotNull Looper looper, @NotNull IClientSchedulerBridge clientSchedulerBridge, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)clientSchedulerBridge, (String)"clientSchedulerBridge");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(looper);
        this.clientSchedulerBridge = clientSchedulerBridge;
        this.logger = logger;
    }

    public void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            if (msg.what == 4) {
                Bundle bundle = msg.getData();
                Parcelable parcelable = bundle.getParcelable("msg");
                Intrinsics.checkNotNull((Object)parcelable);
                Parcelable parcelable2 = parcelable;
                Intrinsics.checkNotNullExpressionValue((Object)parcelable2, (String)"bundle.getParcelable(MESSAGE)!!");
                MqttSendPacket packet = (MqttSendPacket)parcelable2;
                this.clientSchedulerBridge.sendMessage(packet);
            }
        }
        catch (Exception e) {
            this.logger.e("IncomingHandler", "Exception", (Throwable)e);
        }
    }
}

