/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.network;

import com.gojek.courier.logging.ILogger;
import com.gojek.mqtt.client.v3.IAndroidMqttClient;
import com.gojek.mqtt.network.ActiveNetInfo;
import com.gojek.mqtt.utils.NetworkUtils;
import com.gojek.networktracker.NetworkStateListener;
import com.gojek.networktracker.NetworkStateTracker;
import com.gojek.networktracker.model.NetworkState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/gojek/mqtt/network/NetworkHandler;", "", "logger", "Lcom/gojek/courier/logging/ILogger;", "androidMqttClient", "Lcom/gojek/mqtt/client/v3/IAndroidMqttClient;", "networkUtils", "Lcom/gojek/mqtt/utils/NetworkUtils;", "networkStateTracker", "Lcom/gojek/networktracker/NetworkStateTracker;", "(Lcom/gojek/courier/logging/ILogger;Lcom/gojek/mqtt/client/v3/IAndroidMqttClient;Lcom/gojek/mqtt/utils/NetworkUtils;Lcom/gojek/networktracker/NetworkStateTracker;)V", "networkState", "Lcom/gojek/networktracker/model/NetworkState;", "networkStateListener", "Lcom/gojek/networktracker/NetworkStateListener;", "destroy", "", "getActiveNetworkInfo", "Lcom/gojek/mqtt/network/ActiveNetInfo;", "init", "isConnected", "", "mqtt-client_release"})
public final class NetworkHandler {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final IAndroidMqttClient androidMqttClient;
    @NotNull
    private final NetworkUtils networkUtils;
    @NotNull
    private final NetworkStateTracker networkStateTracker;
    @NotNull
    private final NetworkStateListener networkStateListener;
    @NotNull
    private NetworkState networkState;

    public NetworkHandler(@NotNull ILogger logger, @NotNull IAndroidMqttClient androidMqttClient, @NotNull NetworkUtils networkUtils, @NotNull NetworkStateTracker networkStateTracker) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)androidMqttClient, (String)"androidMqttClient");
        Intrinsics.checkNotNullParameter((Object)networkUtils, (String)"networkUtils");
        Intrinsics.checkNotNullParameter((Object)networkStateTracker, (String)"networkStateTracker");
        this.logger = logger;
        this.androidMqttClient = androidMqttClient;
        this.networkUtils = networkUtils;
        this.networkStateTracker = networkStateTracker;
        this.networkStateListener = new NetworkStateListener(this){
            final /* synthetic */ NetworkHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull NetworkState activeNetworkState) {
                Intrinsics.checkNotNullParameter((Object)activeNetworkState, (String)"activeNetworkState");
                NetworkState previousNetworkState = NetworkHandler.access$getNetworkState$p(this.this$0);
                NetworkHandler.access$getLogger$p(this.this$0).d("NetworkHandler", Intrinsics.stringPlus((String)"Network state changed: ", (Object)activeNetworkState));
                NetworkHandler.access$getLogger$p(this.this$0).d("NetworkHandler", Intrinsics.stringPlus((String)"Previous network state: ", (Object)previousNetworkState));
                if (activeNetworkState.isConnected()) {
                    if (!NetworkHandler.access$getAndroidMqttClient$p(this.this$0).isConnected()) {
                        NetworkHandler.access$getLogger$p(this.this$0).d("NetworkHandler", "connecting mqtt on network connect");
                        IAndroidMqttClient.DefaultImpls.connect$default(NetworkHandler.access$getAndroidMqttClient$p(this.this$0), 0L, 1, null);
                    } else if (!previousNetworkState.isConnected()) {
                        NetworkHandler.access$getLogger$p(this.this$0).d("NetworkHandler", "reconnecting mqtt on network connect");
                        NetworkHandler.access$getAndroidMqttClient$p(this.this$0).reconnect();
                    }
                }
                NetworkHandler.access$setNetworkState$p(this.this$0, activeNetworkState);
            }
        };
        this.networkState = this.networkStateTracker.getActiveNetworkState();
    }

    public final void init() {
        this.networkStateTracker.addListener(this.networkStateListener);
    }

    public final void destroy() {
        this.networkStateTracker.removeListener(this.networkStateListener);
    }

    public final boolean isConnected() {
        return this.networkState.isConnected();
    }

    @NotNull
    public final ActiveNetInfo getActiveNetworkInfo() {
        return new ActiveNetInfo(this.networkState.isConnected(), this.networkState.isValidated(), this.networkUtils.getNetworkType(this.networkState.getNetInfo()));
    }

    public static final /* synthetic */ NetworkState access$getNetworkState$p(NetworkHandler $this) {
        return $this.networkState;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(NetworkHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ IAndroidMqttClient access$getAndroidMqttClient$p(NetworkHandler $this) {
        return $this.androidMqttClient;
    }

    public static final /* synthetic */ void access$setNetworkState$p(NetworkHandler $this, NetworkState networkState) {
        $this.networkState = networkState;
    }
}

