/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.persistence.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.gojek.mqtt.persistence.dao.IncomingMessagesDao;
import com.gojek.mqtt.persistence.model.MqttReceivePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class IncomingMessagesDao_Impl
implements IncomingMessagesDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MqttReceivePacket> __insertionAdapterOfMqttReceivePacket;
    private final SharedSQLiteStatement __preparedStmtOfClearAllMessages;
    private final SharedSQLiteStatement __preparedStmtOfRemoveMessagesWithOlderTimestamp;

    public IncomingMessagesDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMqttReceivePacket = new EntityInsertionAdapter<MqttReceivePacket>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `incoming_messages` (`message`,`msg_id`,`ts`,`topic`) VALUES (?,nullif(?, 0),?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MqttReceivePacket value) {
                if (value.getMessage() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindBlob(1, value.getMessage());
                }
                stmt.bindLong(2, value.getMessageId());
                stmt.bindLong(3, value.getNanosTimestamp());
                if (value.getTopic() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTopic());
                }
            }
        };
        this.__preparedStmtOfClearAllMessages = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from incoming_messages";
                return "DELETE from incoming_messages";
            }
        };
        this.__preparedStmtOfRemoveMessagesWithOlderTimestamp = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from incoming_messages where ts < ?";
                return "DELETE from incoming_messages where ts < ?";
            }
        };
    }

    @Override
    public void addMessage(MqttReceivePacket mqttPacket) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMqttReceivePacket.insert((Object)mqttPacket);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearAllMessages() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearAllMessages.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearAllMessages.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeMessagesWithOlderTimestamp(long timestampNanos) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveMessagesWithOlderTimestamp.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, timestampNanos);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveMessagesWithOlderTimestamp.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MqttReceivePacket> getAllMessagesWithTopicFilter(Set<String> topics) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" from incoming_messages where topic in (");
        int _inputSize = topics.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : topics) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msg_id");
            int _cursorIndexOfNanosTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ts");
            int _cursorIndexOfTopic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"topic");
            ArrayList<MqttReceivePacket> _result = new ArrayList<MqttReceivePacket>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                byte[] _tmpMessage = _cursor.getBlob(_cursorIndexOfMessage);
                long _tmpMessageId = _cursor.getLong(_cursorIndexOfMessageId);
                long _tmpNanosTimestamp = _cursor.getLong(_cursorIndexOfNanosTimestamp);
                String _tmpTopic = _cursor.getString(_cursorIndexOfTopic);
                MqttReceivePacket _item_1 = new MqttReceivePacket(_tmpMessage, _tmpMessageId, _tmpNanosTimestamp, _tmpTopic);
                _result.add(_item_1);
            }
            ArrayList<MqttReceivePacket> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeMessagesById(List<Long> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE from incoming_messages where msg_id in (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (Long _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindLong(_argIndex, _item.longValue());
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

