/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.persistence.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.gojek.mqtt.persistence.dao.PahoMessagesDao;
import com.gojek.mqtt.persistence.model.MqttPahoPacket;
import java.util.ArrayList;
import java.util.List;

public final class PahoMessagesDao_Impl
implements PahoMessagesDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MqttPahoPacket> __insertionAdapterOfMqttPahoPacket;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessageByKey;
    private final SharedSQLiteStatement __preparedStmtOfClearAllMessages;

    public PahoMessagesDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMqttPahoPacket = new EntityInsertionAdapter<MqttPahoPacket>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `paho_messages` (`key`,`header_bytes`,`header_offset`,`header_length`,`payload_bytes`,`payload_offset`,`payload_length`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MqttPahoPacket value) {
                if (value.getKey() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getKey());
                }
                if (value.getHeaderBytes() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindBlob(2, value.getHeaderBytes());
                }
                stmt.bindLong(3, (long)value.getHeaderOffset());
                stmt.bindLong(4, (long)value.getHeaderLength());
                if (value.getPayloadBytes() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getPayloadBytes());
                }
                stmt.bindLong(6, (long)value.getPayloadOffset());
                stmt.bindLong(7, (long)value.getPayloadLength());
            }
        };
        this.__preparedStmtOfDeleteMessageByKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from paho_messages where `key`=?";
                return "DELETE from paho_messages where `key`=?";
            }
        };
        this.__preparedStmtOfClearAllMessages = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from paho_messages";
                return "DELETE from paho_messages";
            }
        };
    }

    @Override
    public void insertMessage(MqttPahoPacket mqttPacket) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMqttPahoPacket.insert((Object)mqttPacket);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteMessageByKey(String key) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteMessageByKey.acquire();
        int _argIndex = 1;
        if (key == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, key);
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteMessageByKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearAllMessages() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearAllMessages.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearAllMessages.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttPahoPacket getMessageByKey(String key) {
        String _sql = "SELECT * from paho_messages where `key`=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from paho_messages where `key`=?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MqttPahoPacket _result;
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfHeaderBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_bytes");
            int _cursorIndexOfHeaderOffset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_offset");
            int _cursorIndexOfHeaderLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_length");
            int _cursorIndexOfPayloadBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_bytes");
            int _cursorIndexOfPayloadOffset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_offset");
            int _cursorIndexOfPayloadLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_length");
            if (_cursor.moveToFirst()) {
                String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                byte[] _tmpHeaderBytes = _cursor.getBlob(_cursorIndexOfHeaderBytes);
                int _tmpHeaderOffset = _cursor.getInt(_cursorIndexOfHeaderOffset);
                int _tmpHeaderLength = _cursor.getInt(_cursorIndexOfHeaderLength);
                byte[] _tmpPayloadBytes = _cursor.getBlob(_cursorIndexOfPayloadBytes);
                int _tmpPayloadOffset = _cursor.getInt(_cursorIndexOfPayloadOffset);
                int _tmpPayloadLength = _cursor.getInt(_cursorIndexOfPayloadLength);
                _result = new MqttPahoPacket(_tmpKey, _tmpHeaderBytes, _tmpHeaderOffset, _tmpHeaderLength, _tmpPayloadBytes, _tmpPayloadOffset, _tmpPayloadLength);
            } else {
                _result = null;
            }
            MqttPahoPacket mqttPahoPacket = _result;
            return mqttPahoPacket;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int containsMessage(String key) {
        String _sql = "SELECT count(`key`) from paho_messages where `key`=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(`key`) from paho_messages where `key`=?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllKeys() {
        String _sql = "SELECT `key` from paho_messages";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `key` from paho_messages", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MqttPahoPacket> getAllMessages() {
        String _sql = "SELECT * from paho_messages";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from paho_messages", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfHeaderBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_bytes");
            int _cursorIndexOfHeaderOffset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_offset");
            int _cursorIndexOfHeaderLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"header_length");
            int _cursorIndexOfPayloadBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_bytes");
            int _cursorIndexOfPayloadOffset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_offset");
            int _cursorIndexOfPayloadLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload_length");
            ArrayList<MqttPahoPacket> _result = new ArrayList<MqttPahoPacket>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                byte[] _tmpHeaderBytes = _cursor.getBlob(_cursorIndexOfHeaderBytes);
                int _tmpHeaderOffset = _cursor.getInt(_cursorIndexOfHeaderOffset);
                int _tmpHeaderLength = _cursor.getInt(_cursorIndexOfHeaderLength);
                byte[] _tmpPayloadBytes = _cursor.getBlob(_cursorIndexOfPayloadBytes);
                int _tmpPayloadOffset = _cursor.getInt(_cursorIndexOfPayloadOffset);
                int _tmpPayloadLength = _cursor.getInt(_cursorIndexOfPayloadLength);
                MqttPahoPacket _item = new MqttPahoPacket(_tmpKey, _tmpHeaderBytes, _tmpHeaderOffset, _tmpHeaderLength, _tmpPayloadBytes, _tmpPayloadOffset, _tmpPayloadLength);
                _result.add(_item);
            }
            ArrayList<MqttPahoPacket> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

