/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.persistence.db;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.gojek.mqtt.persistence.dao.IncomingMessagesDao;
import com.gojek.mqtt.persistence.dao.IncomingMessagesDao_Impl;
import com.gojek.mqtt.persistence.dao.PahoMessagesDao;
import com.gojek.mqtt.persistence.dao.PahoMessagesDao_Impl;
import com.gojek.mqtt.persistence.db.MqttDatabase;
import java.util.HashMap;
import java.util.HashSet;

public final class MqttDatabase_Impl
extends MqttDatabase {
    private volatile IncomingMessagesDao _incomingMessagesDao;
    private volatile PahoMessagesDao _pahoMessagesDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(4){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `incoming_messages` (`message` BLOB NOT NULL, `msg_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ts` INTEGER NOT NULL, `topic` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `paho_messages` (`key` TEXT NOT NULL, `header_bytes` BLOB NOT NULL, `header_offset` INTEGER NOT NULL, `header_length` INTEGER NOT NULL, `payload_bytes` BLOB NOT NULL, `payload_offset` INTEGER NOT NULL, `payload_length` INTEGER NOT NULL, PRIMARY KEY(`key`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'd8201fcd09dcd101838b0f6cee2bcce8')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `incoming_messages`");
                _db.execSQL("DROP TABLE IF EXISTS `paho_messages`");
                if (MqttDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqttDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqttDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (MqttDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqttDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqttDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                MqttDatabase_Impl.this.mDatabase = _db;
                MqttDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (MqttDatabase_Impl.this.mCallbacks != null) {
                    int _size = MqttDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MqttDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsIncomingMessages = new HashMap<String, TableInfo.Column>(4);
                _columnsIncomingMessages.put("message", new TableInfo.Column("message", "BLOB", true, 0, null, 1));
                _columnsIncomingMessages.put("msg_id", new TableInfo.Column("msg_id", "INTEGER", true, 1, null, 1));
                _columnsIncomingMessages.put("ts", new TableInfo.Column("ts", "INTEGER", true, 0, null, 1));
                _columnsIncomingMessages.put("topic", new TableInfo.Column("topic", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysIncomingMessages = new HashSet(0);
                HashSet _indicesIncomingMessages = new HashSet(0);
                TableInfo _infoIncomingMessages = new TableInfo("incoming_messages", _columnsIncomingMessages, _foreignKeysIncomingMessages, _indicesIncomingMessages);
                TableInfo _existingIncomingMessages = TableInfo.read((SupportSQLiteDatabase)_db, (String)"incoming_messages");
                if (!_infoIncomingMessages.equals((Object)_existingIncomingMessages)) {
                    return new RoomOpenHelper.ValidationResult(false, "incoming_messages(com.gojek.mqtt.persistence.model.MqttReceivePacket).\n Expected:\n" + _infoIncomingMessages + "\n Found:\n" + _existingIncomingMessages);
                }
                HashMap<String, TableInfo.Column> _columnsPahoMessages = new HashMap<String, TableInfo.Column>(7);
                _columnsPahoMessages.put("key", new TableInfo.Column("key", "TEXT", true, 1, null, 1));
                _columnsPahoMessages.put("header_bytes", new TableInfo.Column("header_bytes", "BLOB", true, 0, null, 1));
                _columnsPahoMessages.put("header_offset", new TableInfo.Column("header_offset", "INTEGER", true, 0, null, 1));
                _columnsPahoMessages.put("header_length", new TableInfo.Column("header_length", "INTEGER", true, 0, null, 1));
                _columnsPahoMessages.put("payload_bytes", new TableInfo.Column("payload_bytes", "BLOB", true, 0, null, 1));
                _columnsPahoMessages.put("payload_offset", new TableInfo.Column("payload_offset", "INTEGER", true, 0, null, 1));
                _columnsPahoMessages.put("payload_length", new TableInfo.Column("payload_length", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysPahoMessages = new HashSet(0);
                HashSet _indicesPahoMessages = new HashSet(0);
                TableInfo _infoPahoMessages = new TableInfo("paho_messages", _columnsPahoMessages, _foreignKeysPahoMessages, _indicesPahoMessages);
                TableInfo _existingPahoMessages = TableInfo.read((SupportSQLiteDatabase)_db, (String)"paho_messages");
                if (!_infoPahoMessages.equals((Object)_existingPahoMessages)) {
                    return new RoomOpenHelper.ValidationResult(false, "paho_messages(com.gojek.mqtt.persistence.model.MqttPahoPacket).\n Expected:\n" + _infoPahoMessages + "\n Found:\n" + _existingPahoMessages);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "d8201fcd09dcd101838b0f6cee2bcce8", "a7b007fbb0c9080505895f7f304f2a69");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"incoming_messages", "paho_messages"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `incoming_messages`");
            _db.execSQL("DELETE FROM `paho_messages`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncomingMessagesDao incomingMessagesDao() {
        if (this._incomingMessagesDao != null) {
            return this._incomingMessagesDao;
        }
        MqttDatabase_Impl mqttDatabase_Impl = this;
        synchronized (mqttDatabase_Impl) {
            if (this._incomingMessagesDao == null) {
                this._incomingMessagesDao = new IncomingMessagesDao_Impl(this);
            }
            return this._incomingMessagesDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PahoMessagesDao pahoMessagesDao() {
        if (this._pahoMessagesDao != null) {
            return this._pahoMessagesDao;
        }
        MqttDatabase_Impl mqttDatabase_Impl = this;
        synchronized (mqttDatabase_Impl) {
            if (this._pahoMessagesDao == null) {
                this._pahoMessagesDao = new PahoMessagesDao_Impl(this);
            }
            return this._pahoMessagesDao;
        }
    }
}

