/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.persistence.impl;

import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import com.gojek.mqtt.persistence.IMqttReceivePersistence;
import com.gojek.mqtt.persistence.dao.IncomingMessagesDao;
import com.gojek.mqtt.persistence.dao.PahoMessagesDao;
import com.gojek.mqtt.persistence.db.MqttDatabase;
import com.gojek.mqtt.persistence.model.MqttPahoPacket;
import com.gojek.mqtt.persistence.model.MqttReceivePacket;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.internal.MqttPersistentData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/gojek/mqtt/persistence/impl/PahoPersistence;", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "Lcom/gojek/mqtt/persistence/IMqttReceivePersistence;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "database", "Lcom/gojek/mqtt/persistence/db/MqttDatabase;", "incomingMessagesDao", "Lcom/gojek/mqtt/persistence/dao/IncomingMessagesDao;", "pahoMessagesDao", "Lcom/gojek/mqtt/persistence/dao/PahoMessagesDao;", "addReceivedMessage", "", "mqttPacket", "Lcom/gojek/mqtt/persistence/model/MqttReceivePacket;", "clear", "clearAll", "close", "containsKey", "", "key", "", "get", "Lorg/eclipse/paho/client/mqttv3/MqttPersistable;", "getAllIncomingMessagesWithTopicFilter", "", "topics", "", "keys", "Ljava/util/Enumeration;", "open", "clientId", "serverURI", "put", "persistable", "remove", "removeMessagesWithOlderTimestamp", "", "timestampNanos", "", "removeReceivedMessages", "messageIds", "mqtt-client_release"})
public final class PahoPersistence
implements MqttClientPersistence,
IMqttReceivePersistence {
    @NotNull
    private final Context context;
    private MqttDatabase database;
    private IncomingMessagesDao incomingMessagesDao;
    private PahoMessagesDao pahoMessagesDao;

    public PahoPersistence(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void open(@NotNull String clientId, @NotNull String serverURI) {
        RoomDatabase roomDatabase;
        RoomDatabase roomDatabase2;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        RoomDatabase roomDatabase3 = Room.databaseBuilder((Context)this.context.getApplicationContext(), MqttDatabase.class, (String)Intrinsics.stringPlus((String)clientId, (Object)":mqtt-db")).fallbackToDestructiveMigration().build();
        Intrinsics.checkNotNullExpressionValue((Object)roomDatabase3, (String)"databaseBuilder(\n       \u2026on()\n            .build()");
        this.database = (MqttDatabase)roomDatabase3;
        roomDatabase3 = this.database;
        if (roomDatabase3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            roomDatabase2 = null;
        } else {
            roomDatabase2 = roomDatabase3;
        }
        this.incomingMessagesDao = roomDatabase2.incomingMessagesDao();
        roomDatabase3 = this.database;
        if (roomDatabase3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            roomDatabase = null;
        } else {
            roomDatabase = roomDatabase3;
        }
        this.pahoMessagesDao = roomDatabase.pahoMessagesDao();
    }

    public void close() {
    }

    public void put(@NotNull String key, @NotNull MqttPersistable persistable) {
        PahoMessagesDao pahoMessagesDao;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)persistable, (String)"persistable");
        Object object = this.pahoMessagesDao;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = object;
        }
        object = persistable.getHeaderBytes();
        int n = persistable.getHeaderLength();
        int n2 = persistable.getHeaderOffset();
        byte[] byArray = persistable.getPayloadBytes();
        int n3 = persistable.getPayloadLength();
        int n4 = persistable.getPayloadOffset();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"headerBytes");
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"payloadBytes");
        pahoMessagesDao.insertMessage(new MqttPahoPacket(key, (byte[])object, n2, n, byArray, n4, n3));
    }

    @NotNull
    public MqttPersistable get(@NotNull String key) {
        PahoMessagesDao pahoMessagesDao;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PahoMessagesDao pahoMessagesDao2 = this.pahoMessagesDao;
        if (pahoMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = pahoMessagesDao2;
        }
        MqttPahoPacket message = pahoMessagesDao.getMessageByKey(key);
        return (MqttPersistable)new MqttPersistentData(message.getKey(), message.getHeaderBytes(), message.getHeaderOffset(), message.getHeaderLength(), message.getPayloadBytes(), message.getPayloadOffset(), message.getPayloadLength());
    }

    public void remove(@NotNull String key) {
        PahoMessagesDao pahoMessagesDao;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PahoMessagesDao pahoMessagesDao2 = this.pahoMessagesDao;
        if (pahoMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = pahoMessagesDao2;
        }
        pahoMessagesDao.deleteMessageByKey(key);
    }

    @NotNull
    public Enumeration<?> keys() {
        PahoMessagesDao pahoMessagesDao;
        PahoMessagesDao pahoMessagesDao2 = this.pahoMessagesDao;
        if (pahoMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = pahoMessagesDao2;
        }
        Enumeration enumeration = Collections.enumeration((Collection)pahoMessagesDao.getAllKeys());
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(pahoMessagesDao.getAllKeys())");
        return enumeration;
    }

    public void clear() {
        PahoMessagesDao pahoMessagesDao;
        PahoMessagesDao pahoMessagesDao2 = this.pahoMessagesDao;
        if (pahoMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = pahoMessagesDao2;
        }
        pahoMessagesDao.clearAllMessages();
    }

    public boolean containsKey(@NotNull String key) {
        PahoMessagesDao pahoMessagesDao;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PahoMessagesDao pahoMessagesDao2 = this.pahoMessagesDao;
        if (pahoMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
            pahoMessagesDao = null;
        } else {
            pahoMessagesDao = pahoMessagesDao2;
        }
        return pahoMessagesDao.containsMessage(key) > 1;
    }

    @Override
    public void addReceivedMessage(@NotNull MqttReceivePacket mqttPacket) {
        IncomingMessagesDao incomingMessagesDao;
        Intrinsics.checkNotNullParameter((Object)mqttPacket, (String)"mqttPacket");
        IncomingMessagesDao incomingMessagesDao2 = this.incomingMessagesDao;
        if (incomingMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incomingMessagesDao");
            incomingMessagesDao = null;
        } else {
            incomingMessagesDao = incomingMessagesDao2;
        }
        incomingMessagesDao.addMessage(mqttPacket);
    }

    @Override
    @NotNull
    public List<MqttReceivePacket> getAllIncomingMessagesWithTopicFilter(@NotNull Set<String> topics) {
        IncomingMessagesDao incomingMessagesDao;
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        IncomingMessagesDao incomingMessagesDao2 = this.incomingMessagesDao;
        if (incomingMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incomingMessagesDao");
            incomingMessagesDao = null;
        } else {
            incomingMessagesDao = incomingMessagesDao2;
        }
        return incomingMessagesDao.getAllMessagesWithTopicFilter(topics);
    }

    @Override
    public int removeReceivedMessages(@NotNull List<Long> messageIds) {
        IncomingMessagesDao incomingMessagesDao;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        IncomingMessagesDao incomingMessagesDao2 = this.incomingMessagesDao;
        if (incomingMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incomingMessagesDao");
            incomingMessagesDao = null;
        } else {
            incomingMessagesDao = incomingMessagesDao2;
        }
        return incomingMessagesDao.removeMessagesById(messageIds);
    }

    @Override
    public int removeMessagesWithOlderTimestamp(long timestampNanos) {
        IncomingMessagesDao incomingMessagesDao;
        IncomingMessagesDao incomingMessagesDao2 = this.incomingMessagesDao;
        if (incomingMessagesDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incomingMessagesDao");
            incomingMessagesDao = null;
        } else {
            incomingMessagesDao = incomingMessagesDao2;
        }
        return incomingMessagesDao.removeMessagesWithOlderTimestamp(timestampNanos);
    }

    public final void clearAll() {
        Object object;
        if (this.pahoMessagesDao != null) {
            PahoMessagesDao pahoMessagesDao;
            object = this.pahoMessagesDao;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pahoMessagesDao");
                pahoMessagesDao = null;
            } else {
                pahoMessagesDao = object;
            }
            pahoMessagesDao.clearAllMessages();
        }
        if (this.incomingMessagesDao != null) {
            Object object2;
            object = this.incomingMessagesDao;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"incomingMessagesDao");
                object2 = null;
            } else {
                object2 = object;
            }
            object2.clearAllMessages();
        }
    }
}

