/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.policies.connectretrytime;

import com.gojek.mqtt.policies.connectretrytime.ConnectRetryTimeConfig;
import com.gojek.mqtt.policies.connectretrytime.IConnectRetryTimePolicy;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/gojek/mqtt/policies/connectretrytime/ConnectRetryTimePolicy;", "Lcom/gojek/mqtt/policies/connectretrytime/IConnectRetryTimePolicy;", "connectRetryTimeConfig", "Lcom/gojek/mqtt/policies/connectretrytime/ConnectRetryTimeConfig;", "(Lcom/gojek/mqtt/policies/connectretrytime/ConnectRetryTimeConfig;)V", "reconnectTime", "Ljava/util/concurrent/atomic/AtomicInteger;", "retryCount", "getConnRetryTimeSecs", "", "forceExp", "", "getCurrentRetryTime", "getRetryCount", "resetParams", "", "updateReconnectTimeExponentially", "exponentialFactor", "mqtt-client_release"})
public final class ConnectRetryTimePolicy
implements IConnectRetryTimePolicy {
    @NotNull
    private final ConnectRetryTimeConfig connectRetryTimeConfig;
    @NotNull
    private final AtomicInteger reconnectTime;
    @NotNull
    private final AtomicInteger retryCount;

    public ConnectRetryTimePolicy(@NotNull ConnectRetryTimeConfig connectRetryTimeConfig) {
        Intrinsics.checkNotNullParameter((Object)connectRetryTimeConfig, (String)"connectRetryTimeConfig");
        this.connectRetryTimeConfig = connectRetryTimeConfig;
        this.reconnectTime = new AtomicInteger(0);
        this.retryCount = new AtomicInteger(0);
    }

    @Override
    public int getConnRetryTimeSecs(boolean forceExp) {
        int maxRetryCount = this.connectRetryTimeConfig.getMaxRetryCount();
        int reconnectTimeFixed = this.connectRetryTimeConfig.getReconnectTimeFixed();
        int reconnectTimeRandom = this.connectRetryTimeConfig.getReconnectTimeRandom();
        int maxReconnectTime = this.connectRetryTimeConfig.getMaxReconnectTime();
        Random random = new Random();
        if (!(this.reconnectTime.get() != 0 && this.retryCount.get() >= maxRetryCount || forceExp)) {
            this.reconnectTime.set(reconnectTimeFixed + random.nextInt(reconnectTimeRandom) + 1);
            this.retryCount.getAndIncrement();
        } else {
            this.updateReconnectTimeExponentially(2);
        }
        if (this.reconnectTime.get() > maxReconnectTime) {
            this.reconnectTime.set(maxReconnectTime);
        } else if (this.reconnectTime.get() == 0) {
            this.reconnectTime.set(reconnectTimeFixed + random.nextInt(reconnectTimeRandom) + 1);
        }
        return this.reconnectTime.get();
    }

    @Override
    public int getRetryCount() {
        return this.retryCount.get();
    }

    @Override
    public int getConnRetryTimeSecs() {
        return this.getConnRetryTimeSecs(false);
    }

    @Override
    public int getCurrentRetryTime() {
        return this.reconnectTime.get();
    }

    private final int updateReconnectTimeExponentially(int exponentialFactor) {
        int next;
        int current;
        while (!this.reconnectTime.compareAndSet(current = this.reconnectTime.get(), next = current * exponentialFactor)) {
        }
        return next;
    }

    @Override
    public void resetParams() {
        this.reconnectTime.set(0);
        this.retryCount.set(0);
    }
}

