/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.policies.hostfallback;

import com.gojek.mqtt.model.ServerUri;
import com.gojek.mqtt.policies.hostfallback.IHostFallbackPolicy;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/gojek/mqtt/policies/hostfallback/HostFallbackPolicy;", "Lcom/gojek/mqtt/policies/hostfallback/IHostFallbackPolicy;", "serverUris", "", "Lcom/gojek/mqtt/model/ServerUri;", "(Ljava/util/List;)V", "currentIndex", "", "serverUriList", "getServerUri", "onConnectFailure", "", "exception", "", "resetParams", "mqtt-client_release"})
public final class HostFallbackPolicy
implements IHostFallbackPolicy {
    private int currentIndex;
    @NotNull
    private final List<ServerUri> serverUriList;

    public HostFallbackPolicy(@NotNull List<ServerUri> serverUris) {
        Intrinsics.checkNotNullParameter(serverUris, (String)"serverUris");
        this.serverUriList = CollectionsKt.toList((Iterable)serverUris);
        if (serverUris.isEmpty()) {
            throw new IllegalArgumentException("serverUris should not be empty");
        }
    }

    @Override
    @NotNull
    public ServerUri getServerUri() {
        return this.serverUriList.get(this.currentIndex);
    }

    @Override
    public void onConnectFailure(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof MqttException && (short)((MqttException)exception).getReasonCode() == 0) {
            this.currentIndex = (this.currentIndex + 1) % this.serverUriList.size();
        }
    }

    @Override
    public void resetParams() {
        this.currentIndex = 0;
    }
}

