/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.policies.subscriptionretry;

import androidx.annotation.VisibleForTesting;
import com.gojek.mqtt.policies.subscriptionretry.ISubscriptionRetryPolicy;
import com.gojek.mqtt.policies.subscriptionretry.SubscriptionRetryConfig;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/gojek/mqtt/policies/subscriptionretry/SubscriptionRetryPolicy;", "Lcom/gojek/mqtt/policies/subscriptionretry/ISubscriptionRetryPolicy;", "subscriptionRetryConfig", "Lcom/gojek/mqtt/policies/subscriptionretry/SubscriptionRetryConfig;", "(Lcom/gojek/mqtt/policies/subscriptionretry/SubscriptionRetryConfig;)V", "retryCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRetryCount", "", "getRetryCount$mqtt_client_release", "resetParams", "", "shouldRetry", "", "mqtt-client_release"})
public final class SubscriptionRetryPolicy
implements ISubscriptionRetryPolicy {
    @NotNull
    private final SubscriptionRetryConfig subscriptionRetryConfig;
    @NotNull
    private final AtomicInteger retryCount;

    public SubscriptionRetryPolicy(@NotNull SubscriptionRetryConfig subscriptionRetryConfig) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRetryConfig, (String)"subscriptionRetryConfig");
        this.subscriptionRetryConfig = subscriptionRetryConfig;
        this.retryCount = new AtomicInteger(0);
    }

    @Override
    public boolean shouldRetry() {
        return this.retryCount.incrementAndGet() <= this.subscriptionRetryConfig.getMaxRetryCount();
    }

    @Override
    public void resetParams() {
        this.retryCount.set(0);
    }

    @VisibleForTesting
    public final int getRetryCount$mqtt_client_release() {
        return this.retryCount.get();
    }
}

