/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.scheduler;

import android.os.Handler;
import android.os.HandlerThread;
import com.gojek.courier.QoS;
import com.gojek.courier.logging.ILogger;
import com.gojek.mqtt.client.IClientSchedulerBridge;
import com.gojek.mqtt.event.EventHandler;
import com.gojek.mqtt.event.MqttEvent;
import com.gojek.mqtt.scheduler.IRunnableScheduler;
import com.gojek.mqtt.scheduler.runnable.ActivityCheckRunnable;
import com.gojek.mqtt.scheduler.runnable.AuthFailureRunnable;
import com.gojek.mqtt.scheduler.runnable.ConnectionCheckRunnable;
import com.gojek.mqtt.scheduler.runnable.DisconnectRunnable;
import com.gojek.mqtt.scheduler.runnable.MqttExceptionRunnable;
import com.gojek.mqtt.scheduler.runnable.ResetParamsRunnable;
import com.gojek.mqtt.scheduler.runnable.SubscribeRunnable;
import com.gojek.mqtt.scheduler.runnable.UnsubscribeRunnable;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J \u0010$\u001a\u00020\u001c2\u000e\u0010%\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001eH\u0016J$\u0010-\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001e2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/H\u0016J\u001e\u00102\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001e2\f\u00103\u001a\b\u0012\u0004\u0012\u00020004H\u0016J\b\u00105\u001a\u00020\u001cH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/gojek/mqtt/scheduler/MqttRunnableScheduler;", "Lcom/gojek/mqtt/scheduler/IRunnableScheduler;", "handlerThread", "Landroid/os/HandlerThread;", "mqttThreadHandler", "Landroid/os/Handler;", "clientSchedulerBridge", "Lcom/gojek/mqtt/client/IClientSchedulerBridge;", "logger", "Lcom/gojek/courier/logging/ILogger;", "eventHandler", "Lcom/gojek/mqtt/event/EventHandler;", "activityCheckIntervalSeconds", "", "(Landroid/os/HandlerThread;Landroid/os/Handler;Lcom/gojek/mqtt/client/IClientSchedulerBridge;Lcom/gojek/courier/logging/ILogger;Lcom/gojek/mqtt/event/EventHandler;I)V", "activityCheckRunnable", "Lcom/gojek/mqtt/scheduler/runnable/ActivityCheckRunnable;", "authFailureRunnable", "Lcom/gojek/mqtt/scheduler/runnable/AuthFailureRunnable;", "connectionCheckRunnable", "Lcom/gojek/mqtt/scheduler/runnable/ConnectionCheckRunnable;", "disconnectRunnable", "Lcom/gojek/mqtt/scheduler/runnable/DisconnectRunnable;", "mqttExceptionRunnable", "Lcom/gojek/mqtt/scheduler/runnable/MqttExceptionRunnable;", "resetParamsRunnable", "Lcom/gojek/mqtt/scheduler/runnable/ResetParamsRunnable;", "connectMqtt", "", "timeMillis", "", "disconnectMqtt", "reconnect", "", "clearState", "scheduleAuthFailureRunnable", "scheduleMqttHandleExceptionRunnable", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "scheduleNextActivityCheck", "scheduleNextConnectionCheck", "reconnectTimeSecs", "scheduleResetParams", "delayMillis", "scheduleSubscribe", "topicMap", "", "", "Lcom/gojek/courier/QoS;", "scheduleUnsubscribe", "topics", "", "sendThreadEventIfNotAlive", "Companion", "mqtt-client_release"})
public final class MqttRunnableScheduler
implements IRunnableScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HandlerThread handlerThread;
    @NotNull
    private final Handler mqttThreadHandler;
    @NotNull
    private final IClientSchedulerBridge clientSchedulerBridge;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final EventHandler eventHandler;
    private final int activityCheckIntervalSeconds;
    @NotNull
    private final ConnectionCheckRunnable connectionCheckRunnable;
    @NotNull
    private final MqttExceptionRunnable mqttExceptionRunnable;
    @NotNull
    private final DisconnectRunnable disconnectRunnable;
    @NotNull
    private final ActivityCheckRunnable activityCheckRunnable;
    @NotNull
    private final ResetParamsRunnable resetParamsRunnable;
    @NotNull
    private final AuthFailureRunnable authFailureRunnable;
    @NotNull
    public static final String TAG = "MqttRunnableScheduler";

    public MqttRunnableScheduler(@NotNull HandlerThread handlerThread, @NotNull Handler mqttThreadHandler, @NotNull IClientSchedulerBridge clientSchedulerBridge, @NotNull ILogger logger, @NotNull EventHandler eventHandler, int activityCheckIntervalSeconds) {
        Intrinsics.checkNotNullParameter((Object)handlerThread, (String)"handlerThread");
        Intrinsics.checkNotNullParameter((Object)mqttThreadHandler, (String)"mqttThreadHandler");
        Intrinsics.checkNotNullParameter((Object)clientSchedulerBridge, (String)"clientSchedulerBridge");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.handlerThread = handlerThread;
        this.mqttThreadHandler = mqttThreadHandler;
        this.clientSchedulerBridge = clientSchedulerBridge;
        this.logger = logger;
        this.eventHandler = eventHandler;
        this.activityCheckIntervalSeconds = activityCheckIntervalSeconds;
        this.connectionCheckRunnable = new ConnectionCheckRunnable(this.clientSchedulerBridge);
        this.mqttExceptionRunnable = new MqttExceptionRunnable(this.clientSchedulerBridge);
        this.disconnectRunnable = new DisconnectRunnable(this.clientSchedulerBridge);
        this.activityCheckRunnable = new ActivityCheckRunnable(this.clientSchedulerBridge, this.logger);
        this.resetParamsRunnable = new ResetParamsRunnable(this.clientSchedulerBridge);
        this.authFailureRunnable = new AuthFailureRunnable(this.clientSchedulerBridge);
    }

    @Override
    public void connectMqtt() {
        this.connectMqtt(10L);
    }

    @Override
    public void connectMqtt(long timeMillis) {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.removeCallbacks((Runnable)this.mqttExceptionRunnable);
            this.mqttThreadHandler.removeCallbacks((Runnable)this.disconnectRunnable);
            this.mqttThreadHandler.postDelayed((Runnable)this.connectionCheckRunnable, timeMillis);
        }
        catch (Exception e) {
            this.logger.e(TAG, "Exception in MQTT connect handler", (Throwable)e);
        }
    }

    @Override
    public void disconnectMqtt(boolean reconnect, boolean clearState) {
        try {
            this.sendThreadEventIfNotAlive();
            this.disconnectRunnable.setReconnect(reconnect);
            this.disconnectRunnable.setClearState(clearState);
            this.mqttThreadHandler.removeCallbacks((Runnable)this.disconnectRunnable);
            this.mqttThreadHandler.removeCallbacks((Runnable)this.connectionCheckRunnable);
            this.mqttThreadHandler.postAtFrontOfQueue((Runnable)this.disconnectRunnable);
        }
        catch (Exception e) {
            this.logger.e(TAG, "Exception in MQTT disconnect", (Throwable)e);
        }
    }

    @Override
    public void scheduleNextActivityCheck() {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.removeCallbacks((Runnable)this.activityCheckRunnable);
            this.mqttThreadHandler.postDelayed((Runnable)this.activityCheckRunnable, (long)this.activityCheckIntervalSeconds * 1000L);
        }
        catch (Exception e) {
            this.logger.e(TAG, "Exception scheduleNextActivityCheck", (Throwable)e);
        }
    }

    @Override
    public void scheduleMqttHandleExceptionRunnable(@Nullable Exception e, boolean reconnect) {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttExceptionRunnable.setParameters(e, reconnect);
            this.mqttThreadHandler.removeCallbacks((Runnable)this.mqttExceptionRunnable);
            this.mqttThreadHandler.removeCallbacks((Runnable)this.connectionCheckRunnable);
            this.mqttThreadHandler.postAtFrontOfQueue((Runnable)this.mqttExceptionRunnable);
        }
        catch (Exception ex) {
            this.logger.e(TAG, "Exception while posting mqttdisconnect runnable", (Throwable)ex);
        }
    }

    @Override
    public void scheduleNextConnectionCheck() {
        this.scheduleNextConnectionCheck(180L);
    }

    @Override
    public void scheduleNextConnectionCheck(long reconnectTimeSecs) {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.removeCallbacks((Runnable)this.connectionCheckRunnable);
            this.mqttThreadHandler.postDelayed((Runnable)this.connectionCheckRunnable, reconnectTimeSecs * (long)1000);
        }
        catch (Exception e) {
            this.logger.e(TAG, "Exception scheduleNextConnectionCheck", (Throwable)e);
        }
    }

    @Override
    public void scheduleSubscribe(long delayMillis, @NotNull Map<String, ? extends QoS> topicMap) {
        Intrinsics.checkNotNullParameter(topicMap, (String)"topicMap");
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.postDelayed((Runnable)new SubscribeRunnable(this.clientSchedulerBridge, topicMap), delayMillis);
        }
        catch (Exception ex) {
            this.logger.e(TAG, "Exception scheduleSubscribe", (Throwable)ex);
        }
    }

    @Override
    public void scheduleUnsubscribe(long delayMillis, @NotNull Set<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.postDelayed((Runnable)new UnsubscribeRunnable(this.clientSchedulerBridge, topics), delayMillis);
        }
        catch (Exception ex) {
            this.logger.e(TAG, "Exception scheduleUnsubscribe", (Throwable)ex);
        }
    }

    @Override
    public void scheduleResetParams(long delayMillis) {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.removeCallbacks((Runnable)this.resetParamsRunnable);
            this.mqttThreadHandler.postDelayed((Runnable)this.resetParamsRunnable, delayMillis);
        }
        catch (Exception ex) {
            this.logger.e(TAG, "Exception scheduleResetParams", (Throwable)ex);
        }
    }

    @Override
    public void scheduleAuthFailureRunnable() {
        try {
            this.sendThreadEventIfNotAlive();
            this.mqttThreadHandler.removeCallbacks((Runnable)this.authFailureRunnable);
            this.mqttThreadHandler.post((Runnable)this.authFailureRunnable);
        }
        catch (Exception ex) {
            this.logger.e(TAG, "Exception while scheduleAuthFailureRunnable", (Throwable)ex);
        }
    }

    private final void sendThreadEventIfNotAlive() {
        if (!this.handlerThread.isAlive()) {
            boolean bl = this.handlerThread.isInterrupted();
            Thread.State state = this.handlerThread.getState();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)state), (String)"handlerThread.state");
            this.eventHandler.onEvent(new MqttEvent.HandlerThreadNotAliveEvent(bl, state, null, 4, null));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/gojek/mqtt/scheduler/MqttRunnableScheduler$Companion;", "", "()V", "TAG", "", "mqtt-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

