/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.subscription;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.gojek.courier.QoS;
import com.gojek.courier.extensions.CollectionExtensionsKt;
import com.gojek.mqtt.subscription.PersistableSubscriptionStore;
import com.gojek.mqtt.subscription.Persistence;
import com.gojek.mqtt.subscription.SubscriptionStore;
import com.gojek.mqtt.subscription.SubscriptionStoreListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0002J\r\u0010\u001a\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u001bJ(\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fH\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/gojek/mqtt/subscription/PersistableSubscriptionStore;", "Lcom/gojek/mqtt/subscription/SubscriptionStore;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "listener", "com/gojek/mqtt/subscription/PersistableSubscriptionStore$listener$1", "Lcom/gojek/mqtt/subscription/PersistableSubscriptionStore$listener$1;", "persistence", "Lcom/gojek/mqtt/subscription/Persistence;", "state", "Lcom/gojek/mqtt/subscription/PersistableSubscriptionStore$State;", "clear", "", "getListener", "Lcom/gojek/mqtt/subscription/SubscriptionStoreListener;", "getSubscribeTopics", "", "", "Lcom/gojek/courier/QoS;", "getUnsubscribeTopics", "", "cleanSession", "", "onTopicsUnsubscribedInternal", "topics", "restoreState", "restoreState$mqtt_client_release", "subscribeTopics", "topicMap", "unsubscribeTopics", "", "State", "mqtt-client_release"})
public final class PersistableSubscriptionStore
implements SubscriptionStore {
    private State state;
    @NotNull
    private final Persistence persistence;
    @NotNull
    private final listener.1 listener;

    public PersistableSubscriptionStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.persistence = new Persistence(context);
        this.listener = new SubscriptionStoreListener(this){
            final /* synthetic */ PersistableSubscriptionStore this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTopicsUnsubscribed(@NotNull Set<String> topics) {
                Intrinsics.checkNotNullParameter(topics, (String)"topics");
                PersistableSubscriptionStore.access$onTopicsUnsubscribedInternal(this.this$0, topics);
            }

            public void onTopicsSubscribed(@NotNull Map<String, ? extends QoS> topicMap) {
                SubscriptionStoreListener.DefaultImpls.onTopicsSubscribed(this, topicMap);
            }
        };
        this.restoreState$mqtt_client_release();
    }

    @Override
    @NotNull
    public synchronized Map<String, QoS> getSubscribeTopics() {
        State state;
        State state2 = this.state;
        if (state2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state = null;
        } else {
            state = state2;
        }
        return CollectionExtensionsKt.toImmutableMap(state.getSubscriptionTopics());
    }

    @Override
    @NotNull
    public synchronized Set<String> getUnsubscribeTopics(boolean cleanSession) {
        State state;
        State state2;
        if (cleanSession) {
            State state3;
            this.persistence.put("PendingUnsubscribes", SetsKt.emptySet());
            state2 = this.state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"state");
                state3 = null;
            } else {
                state3 = state2;
            }
            this.state = State.copy$default(state3, null, SetsKt.emptySet(), 1, null);
        }
        if ((state2 = this.state) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state = null;
        } else {
            state = state2;
        }
        return CollectionExtensionsKt.toImmutableSet(state.getPendingUnsubscribeTopics());
    }

    @Override
    @NotNull
    public synchronized Map<String, QoS> subscribeTopics(@NotNull Map<String, ? extends QoS> topicMap) {
        State state;
        State state2;
        State state3;
        State state4;
        State state5;
        Intrinsics.checkNotNullParameter(topicMap, (String)"topicMap");
        State state6 = this.state;
        if (state6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state5 = null;
        } else {
            state5 = state6;
        }
        Map addedTopics = MapsKt.minus(topicMap, (Iterable)state5.getSubscriptionTopics().keySet());
        state6 = this.state;
        if (state6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state4 = null;
        } else {
            state4 = state6;
        }
        state6 = this.state;
        if (state6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state3 = null;
        } else {
            state3 = state6;
        }
        Map map = MapsKt.plus(state3.getSubscriptionTopics(), topicMap);
        state6 = this.state;
        if (state6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state2 = null;
        } else {
            state2 = state6;
        }
        state6 = this.state = state4.copy(map, SetsKt.minus(state2.getPendingUnsubscribeTopics(), (Iterable)topicMap.keySet()));
        if (state6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state = null;
        } else {
            state = state6;
        }
        this.persistence.put("PendingUnsubscribes", state.getPendingUnsubscribeTopics());
        return addedTopics;
    }

    @Override
    @NotNull
    public synchronized Set<String> unsubscribeTopics(@NotNull List<String> topics) {
        State state;
        State state2;
        State state3;
        State state4;
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        State state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state4 = null;
        } else {
            state4 = state5;
        }
        state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state3 = null;
        } else {
            state3 = state5;
        }
        Map map = MapsKt.minus(state3.getSubscriptionTopics(), (Iterable)topics);
        state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state2 = null;
        } else {
            state2 = state5;
        }
        state5 = this.state = state4.copy(map, SetsKt.plus(state2.getPendingUnsubscribeTopics(), (Iterable)topics));
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state = null;
        } else {
            state = state5;
        }
        this.persistence.put("PendingUnsubscribes", state.getPendingUnsubscribeTopics());
        return CollectionsKt.toSet((Iterable)topics);
    }

    @Override
    @NotNull
    public SubscriptionStoreListener getListener() {
        return this.listener;
    }

    @Override
    public synchronized void clear() {
        this.persistence.put("PendingUnsubscribes", SetsKt.emptySet());
        this.state = new State(MapsKt.emptyMap(), SetsKt.emptySet());
    }

    @VisibleForTesting
    public final void restoreState$mqtt_client_release() {
        this.state = new State(MapsKt.emptyMap(), this.persistence.get("PendingUnsubscribes", SetsKt.emptySet()));
    }

    private final synchronized void onTopicsUnsubscribedInternal(Set<String> topics) {
        State state;
        State state2;
        State state3;
        State state4;
        State state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state4 = null;
        } else {
            state4 = state5;
        }
        state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state3 = null;
        } else {
            state3 = state5;
        }
        Map<String, QoS> map = state3.getSubscriptionTopics();
        state5 = this.state;
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state2 = null;
        } else {
            state2 = state5;
        }
        state5 = this.state = state4.copy(map, SetsKt.minus(state2.getPendingUnsubscribeTopics(), (Iterable)topics));
        if (state5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            state = null;
        } else {
            state = state5;
        }
        this.persistence.put("PendingUnsubscribes", state.getPendingUnsubscribeTopics());
    }

    public static final /* synthetic */ void access$onTopicsUnsubscribedInternal(PersistableSubscriptionStore $this, Set topics) {
        $this.onTopicsUnsubscribedInternal(topics);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/gojek/mqtt/subscription/PersistableSubscriptionStore$State;", "", "subscriptionTopics", "", "", "Lcom/gojek/courier/QoS;", "pendingUnsubscribeTopics", "", "(Ljava/util/Map;Ljava/util/Set;)V", "getPendingUnsubscribeTopics", "()Ljava/util/Set;", "getSubscriptionTopics", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "mqtt-client_release"})
    private static final class State {
        @NotNull
        private final Map<String, QoS> subscriptionTopics;
        @NotNull
        private final Set<String> pendingUnsubscribeTopics;

        public State(@NotNull Map<String, ? extends QoS> subscriptionTopics, @NotNull Set<String> pendingUnsubscribeTopics) {
            Intrinsics.checkNotNullParameter(subscriptionTopics, (String)"subscriptionTopics");
            Intrinsics.checkNotNullParameter(pendingUnsubscribeTopics, (String)"pendingUnsubscribeTopics");
            this.subscriptionTopics = subscriptionTopics;
            this.pendingUnsubscribeTopics = pendingUnsubscribeTopics;
        }

        @NotNull
        public final Map<String, QoS> getSubscriptionTopics() {
            return this.subscriptionTopics;
        }

        @NotNull
        public final Set<String> getPendingUnsubscribeTopics() {
            return this.pendingUnsubscribeTopics;
        }

        @NotNull
        public final Map<String, QoS> component1() {
            return this.subscriptionTopics;
        }

        @NotNull
        public final Set<String> component2() {
            return this.pendingUnsubscribeTopics;
        }

        @NotNull
        public final State copy(@NotNull Map<String, ? extends QoS> subscriptionTopics, @NotNull Set<String> pendingUnsubscribeTopics) {
            Intrinsics.checkNotNullParameter(subscriptionTopics, (String)"subscriptionTopics");
            Intrinsics.checkNotNullParameter(pendingUnsubscribeTopics, (String)"pendingUnsubscribeTopics");
            return new State(subscriptionTopics, pendingUnsubscribeTopics);
        }

        public static /* synthetic */ State copy$default(State state, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = state.subscriptionTopics;
            }
            if ((n & 2) != 0) {
                set = state.pendingUnsubscribeTopics;
            }
            return state.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "State(subscriptionTopics=" + this.subscriptionTopics + ", pendingUnsubscribeTopics=" + this.pendingUnsubscribeTopics + ')';
        }

        public int hashCode() {
            int result = ((Object)this.subscriptionTopics).hashCode();
            result = result * 31 + ((Object)this.pendingUnsubscribeTopics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.subscriptionTopics, state.subscriptionTopics)) {
                return false;
            }
            return Intrinsics.areEqual(this.pendingUnsubscribeTopics, state.pendingUnsubscribeTopics);
        }
    }
}

