/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J+\u0010\u0007\u001a\u00020\u0004\"\u0004\b\u0000\u0010\b\"\u0010\b\u0001\u0010\t*\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\n2\u0006\u0010\u000b\u001a\u0002H\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/gojek/mqtt/utils/MqttUtils;", "", "()V", "isCompressed", "", "bytes", "", "isEmpty", "S", "T", "", "argument", "(Ljava/lang/Iterable;)Z", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "name", "", "daemon", "uncompressByteArray", "mqtt-client_release"})
public final class MqttUtils {
    private final boolean isCompressed(byte[] bytes) {
        boolean bl;
        try {
            bl = bytes == null || bytes.length < 2 ? false : bytes[0] == 31 && bytes[1] == -117;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] uncompressByteArray(@Nullable byte[] bytes) throws IOException {
        Closeable n22;
        byte[] byArray;
        int DEFAULT_BUFFER_SIZE = 4096;
        if (!this.isCompressed(bytes)) {
            return bytes;
        }
        ByteArrayInputStream bais = null;
        GZIPInputStream gzis = null;
        ByteArrayOutputStream baos = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gzis = new GZIPInputStream(bais);
            baos = new ByteArrayOutputStream(DEFAULT_BUFFER_SIZE);
            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
            int n22 = 0;
            while (true) {
                void it;
                int n = gzis.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int n3 = n;
                int n4 = -1;
                boolean bl3 = false;
                n22 = it;
                Unit unit = Unit.INSTANCE;
                if (n4 == n) break;
                baos.write(buffer, 0, n22);
            }
            gzis.close();
            bais.close();
            byte[] uncompressedByteArray = baos.toByteArray();
            baos.close();
            byArray = uncompressedByteArray;
            n22 = gzis;
        }
        catch (IOException ioex) {
            try {
                throw ioex;
            }
            catch (Throwable throwable) {
                InputStream inputStream = gzis;
                if (inputStream != null) {
                    ((GZIPInputStream)inputStream).close();
                }
                inputStream = bais;
                if (inputStream != null) {
                    ((ByteArrayInputStream)inputStream).close();
                }
                inputStream = baos;
                if (inputStream != null) {
                    ((ByteArrayOutputStream)((Object)inputStream)).close();
                }
                throw throwable;
            }
        }
        ((GZIPInputStream)n22).close();
        n22 = bais;
        ((ByteArrayInputStream)n22).close();
        n22 = baos;
        ((ByteArrayOutputStream)n22).close();
        return byArray;
    }

    public final <S, T extends Iterable<? extends S>> boolean isEmpty(T argument) {
        return argument == null || !argument.iterator().hasNext();
    }

    @NotNull
    public final ThreadFactory threadFactory(@NotNull String name, boolean daemon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ThreadFactory(name, daemon){
            @NotNull
            private final AtomicInteger i;
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $daemon;
            {
                this.$name = $name;
                this.$daemon = $daemon;
                this.i = new AtomicInteger(1);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable runnable) {
                Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                int threadCount = this.i.getAndIncrement();
                Thread result = new Thread(runnable);
                result.setName(this.$name + '-' + threadCount);
                result.setDaemon(this.$daemon);
                result.setPriority(9);
                return result;
            }
        };
    }
}

