/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.utils;

import android.net.NetworkInfo;
import android.text.TextUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/gojek/mqtt/utils/NetInfo;", "", "info", "Landroid/net/NetworkInfo;", "networkType", "", "isWifi", "", "(Landroid/net/NetworkInfo;SZ)V", "isAvailable", "isRoaming", "getNetworkType", "()S", "ssid", "", "equals", "other", "hashCode", "", "toString", "mqtt-client_release"})
public final class NetInfo {
    @Nullable
    private final NetworkInfo info;
    private final boolean isAvailable;
    private final boolean isRoaming;
    private final short networkType;
    @Nullable
    private final String ssid;
    private final boolean isWifi;

    public NetInfo(@NotNull NetworkInfo info, short networkType, boolean isWifi) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        this.isAvailable = info.isAvailable();
        this.isRoaming = info.isRoaming();
        this.networkType = networkType;
        this.isWifi = isWifi;
        this.ssid = info.getExtraInfo();
    }

    public final short getNetworkType() {
        return this.networkType;
    }

    public int hashCode() {
        int n;
        int hashCode = this.networkType;
        hashCode += 31 * (this.isWifi ? 1231 : 1237);
        String string = this.ssid;
        return hashCode += 31 * (string == null ? 0 : (n = string.hashCode()));
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return !(other instanceof NetInfo) ? false : this.equals((NetInfo)other);
    }

    private final boolean equals(NetInfo info) {
        if (this.networkType != info.networkType) {
            return false;
        }
        if (!this.isWifi || !info.isWifi) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)this.ssid) && TextUtils.isEmpty((CharSequence)info.ssid)) {
            return true;
        }
        return TextUtils.isEmpty((CharSequence)this.ssid) || TextUtils.isEmpty((CharSequence)info.ssid) ? false : Intrinsics.areEqual((Object)this.ssid, (Object)info.ssid);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.info == null) {
            string = "";
        } else {
            String string2 = this.ssid;
            string = "[type: " + this.info.getTypeName() + '[' + this.info.getSubtypeName() + "], state: " + this.info.getState() + '/' + this.info.getDetailedState() + ", reason: " + (this.info.getReason() == null ? "(unspecified)" : this.info.getReason()) + ", extra: " + (string2 == null ? "(none)" : string2) + ", roaming: " + this.isRoaming + ", failover: " + this.info.isFailover() + ", isAvailable: " + this.isAvailable + ']';
        }
        return string;
    }
}

