/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import com.gojek.mqtt.utils.NetInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/gojek/mqtt/utils/NetworkUtils;", "", "()V", "getNetInfo", "Lcom/gojek/mqtt/utils/NetInfo;", "context", "Landroid/content/Context;", "getNetworkInfo", "Landroid/net/NetworkInfo;", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkType", "", "getNetworkName", "", "getNetworkType", "", "info", "isConnected", "", "isOnWifi", "isWifi", "mqtt-client_release"})
public final class NetworkUtils {
    public final boolean isConnected(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        short networkType = this.getNetworkType(context);
        return networkType != -1;
    }

    public final short getNetworkType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo networkInfo = this.getNetworkInfo(context);
        return this.getNetworkType(networkInfo);
    }

    private final NetworkInfo getNetworkInfo(Context context) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        ConnectivityManager cm = connectivityManager;
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo == null && (networkInfo = this.getNetworkInfo(cm, 0)) == null) {
            networkInfo = this.getNetworkInfo(cm, 1);
        }
        return networkInfo;
    }

    private final NetworkInfo getNetworkInfo(ConnectivityManager connectivityManager, int networkType) {
        if (Build.VERSION.SDK_INT < 21) {
            return connectivityManager.getNetworkInfo(networkType);
        }
        Network[] networkArray = connectivityManager.getAllNetworks();
        Intrinsics.checkNotNullExpressionValue((Object)networkArray, (String)"connectivityManager.allNetworks");
        Network[] networks = networkArray;
        if (networks.length == 0) {
            return null;
        }
        for (Network network : networks) {
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
            if (networkInfo == null || networkType != networkInfo.getType()) continue;
            return networkInfo;
        }
        return null;
    }

    public final short getNetworkType(@Nullable NetworkInfo info) {
        short s;
        int networkType;
        if (info == null || !info.isConnected()) {
            return -1;
        }
        if (info.getType() == 1) {
            return 1;
        }
        int n = networkType = info.getSubtype();
        switch (n) {
            case 13: {
                s = 4;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                s = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                s = 2;
                break;
            }
            case 0: {
                s = 0;
                break;
            }
            default: {
                s = 0;
            }
        }
        return s;
    }

    @Nullable
    public final NetInfo getNetInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo info = this.getNetworkInfo(context);
        if (info == null || !info.isConnected()) {
            return null;
        }
        short networkType = this.getNetworkType(info);
        return new NetInfo(info, networkType, this.isWifi(networkType));
    }

    public final boolean isOnWifi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isWifi(this.getNetworkType(context));
    }

    private final boolean isWifi(short networkType) {
        return 1 == networkType;
    }

    @NotNull
    public final String getNetworkName(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string2;
            if (this.isOnWifi(context)) {
                string2 = "wifi";
            } else {
                NetworkInfo activeNetworkInfo;
                Object object = context.getSystemService("connectivity");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager connectivityManager = (ConnectivityManager)object;
                NetworkInfo networkInfo = activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                Intrinsics.checkNotNull((Object)networkInfo);
                string2 = networkInfo.getExtraInfo();
            }
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            if (isOnWi\u2026o\n            }\n        }");
        }
        catch (Exception e) {
            string = "Unknown";
        }
        return string;
    }
}

