/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.mqtt.wakelock;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.PowerManager;
import com.gojek.courier.logging.ILogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/gojek/mqtt/wakelock/WakeLockProvider;", "", "context", "Landroid/content/Context;", "logger", "Lcom/gojek/courier/logging/ILogger;", "(Landroid/content/Context;Lcom/gojek/courier/logging/ILogger;)V", "wakelock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "acquireWakeLock", "", "timeout", "", "releaseWakeLock", "Companion", "mqtt-client_release"})
public final class WakeLockProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;
    @Nullable
    private PowerManager.WakeLock wakelock;
    @NotNull
    public static final String TAG = "WakeLockProvider";
    @NotNull
    public static final String WAKE_LOCK_TAG = "MQTTWLock";

    public WakeLockProvider(@NotNull Context context, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.logger = logger;
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    public final void acquireWakeLock(int timeout) {
        if (timeout > 0) {
            if (this.wakelock == null) {
                Object object = this.context.getSystemService("power");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
                }
                PowerManager pm = (PowerManager)object;
                PowerManager.WakeLock wakeLock = this.wakelock = pm.newWakeLock(1, WAKE_LOCK_TAG);
                Intrinsics.checkNotNull((Object)wakeLock);
                wakeLock.setReferenceCounted(false);
            }
            PowerManager.WakeLock wakeLock = this.wakelock;
            Intrinsics.checkNotNull((Object)wakeLock);
            wakeLock.acquire((long)timeout * 1000L);
        }
        this.logger.d(TAG, "Wakelock Acquired");
    }

    public final void releaseWakeLock() {
        if (this.wakelock != null) {
            PowerManager.WakeLock wakeLock = this.wakelock;
            Intrinsics.checkNotNull((Object)wakeLock);
            if (wakeLock.isHeld()) {
                PowerManager.WakeLock wakeLock2 = this.wakelock;
                Intrinsics.checkNotNull((Object)wakeLock2);
                wakeLock2.release();
                this.logger.d(TAG, "Wakelock Released");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/gojek/mqtt/wakelock/WakeLockProvider$Companion;", "", "()V", "TAG", "", "WAKE_LOCK_TAG", "mqtt-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

