/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.networktracker;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.net.ConnectivityManagerCompat;
import com.gojek.courier.logging.ILogger;
import com.gojek.networktracker.NetworkStateListener;
import com.gojek.networktracker.NetworkStateTracker;
import com.gojek.networktracker.model.NetworkState;
import com.gojek.networktracker.util.BuildInfoProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0002<=B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020\u0014H\u0016J\r\u0010.\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b/J\b\u00100\u001a\u000201H\u0002J\r\u00102\u001a\u000201H\u0001\u00a2\u0006\u0002\b3J\u0010\u00104\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001cH\u0016J\u0015\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b7J\r\u00108\u001a\u00020+H\u0001\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020+H\u0001\u00a2\u0006\u0002\b;R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u00060\nR\u00020\u00008\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00148\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R,\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001d8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\f\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010#\u001a\u00060$R\u00020\u00008\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006>"}, d2={"Lcom/gojek/networktracker/NetworkStateTrackerImpl;", "Lcom/gojek/networktracker/NetworkStateTracker;", "mAppContext", "Landroid/content/Context;", "logger", "Lcom/gojek/courier/logging/ILogger;", "buildInfoProvider", "Lcom/gojek/networktracker/util/BuildInfoProvider;", "(Landroid/content/Context;Lcom/gojek/courier/logging/ILogger;Lcom/gojek/networktracker/util/BuildInfoProvider;)V", "mBroadcastReceiver", "Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateBroadcastReceiver;", "getMBroadcastReceiver$network_tracker_release$annotations", "()V", "getMBroadcastReceiver$network_tracker_release", "()Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateBroadcastReceiver;", "setMBroadcastReceiver$network_tracker_release", "(Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateBroadcastReceiver;)V", "mConnectivityManager", "Landroid/net/ConnectivityManager;", "mCurrentState", "Lcom/gojek/networktracker/model/NetworkState;", "getMCurrentState$network_tracker_release$annotations", "getMCurrentState$network_tracker_release", "()Lcom/gojek/networktracker/model/NetworkState;", "setMCurrentState$network_tracker_release", "(Lcom/gojek/networktracker/model/NetworkState;)V", "mListeners", "Ljava/util/LinkedHashSet;", "Lcom/gojek/networktracker/NetworkStateListener;", "Lkotlin/collections/LinkedHashSet;", "getMListeners$network_tracker_release$annotations", "getMListeners$network_tracker_release", "()Ljava/util/LinkedHashSet;", "mLock", "", "mNetworkCallback", "Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateCallback;", "getMNetworkCallback$network_tracker_release$annotations", "getMNetworkCallback$network_tracker_release", "()Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateCallback;", "setMNetworkCallback$network_tracker_release", "(Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateCallback;)V", "addListener", "", "listener", "getActiveNetworkState", "getInitialState", "getInitialState$network_tracker_release", "isActiveNetworkValidated", "", "isNetworkCallbackSupported", "isNetworkCallbackSupported$network_tracker_release", "removeListener", "setState", "newState", "setState$network_tracker_release", "startTracking", "startTracking$network_tracker_release", "stopTracking", "stopTracking$network_tracker_release", "NetworkStateBroadcastReceiver", "NetworkStateCallback", "network-tracker_release"})
public final class NetworkStateTrackerImpl
implements NetworkStateTracker {
    @NotNull
    private final Context mAppContext;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final ConnectivityManager mConnectivityManager;
    @RequiresApi(value=24)
    public NetworkStateCallback mNetworkCallback;
    public NetworkStateBroadcastReceiver mBroadcastReceiver;
    @NotNull
    private final Object mLock;
    @NotNull
    private final LinkedHashSet<NetworkStateListener> mListeners;
    public NetworkState mCurrentState;

    public NetworkStateTrackerImpl(@NotNull Context mAppContext, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)mAppContext, (String)"mAppContext");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)buildInfoProvider, (String)"buildInfoProvider");
        this.mAppContext = mAppContext;
        this.logger = logger;
        this.buildInfoProvider = buildInfoProvider;
        Object object = this.mAppContext.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.mConnectivityManager = (ConnectivityManager)object;
        this.mLock = new Object();
        boolean bl = false;
        this.mListeners = new LinkedHashSet();
        if (this.isNetworkCallbackSupported$network_tracker_release()) {
            this.setMNetworkCallback$network_tracker_release(new NetworkStateCallback());
        } else {
            this.setMBroadcastReceiver$network_tracker_release(new NetworkStateBroadcastReceiver());
        }
    }

    public /* synthetic */ NetworkStateTrackerImpl(Context context, ILogger iLogger, BuildInfoProvider buildInfoProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            buildInfoProvider = new BuildInfoProvider();
        }
        this(context, iLogger, buildInfoProvider);
    }

    @NotNull
    public final NetworkStateCallback getMNetworkCallback$network_tracker_release() {
        NetworkStateCallback networkStateCallback = this.mNetworkCallback;
        if (networkStateCallback != null) {
            return networkStateCallback;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mNetworkCallback");
        return null;
    }

    public final void setMNetworkCallback$network_tracker_release(@NotNull NetworkStateCallback networkStateCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkStateCallback), (String)"<set-?>");
        this.mNetworkCallback = networkStateCallback;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMNetworkCallback$network_tracker_release$annotations() {
    }

    @NotNull
    public final NetworkStateBroadcastReceiver getMBroadcastReceiver$network_tracker_release() {
        NetworkStateBroadcastReceiver networkStateBroadcastReceiver = this.mBroadcastReceiver;
        if (networkStateBroadcastReceiver != null) {
            return networkStateBroadcastReceiver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mBroadcastReceiver");
        return null;
    }

    public final void setMBroadcastReceiver$network_tracker_release(@NotNull NetworkStateBroadcastReceiver networkStateBroadcastReceiver) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkStateBroadcastReceiver), (String)"<set-?>");
        this.mBroadcastReceiver = networkStateBroadcastReceiver;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMBroadcastReceiver$network_tracker_release$annotations() {
    }

    @NotNull
    public final LinkedHashSet<NetworkStateListener> getMListeners$network_tracker_release() {
        return this.mListeners;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMListeners$network_tracker_release$annotations() {
    }

    @NotNull
    public final NetworkState getMCurrentState$network_tracker_release() {
        NetworkState networkState = this.mCurrentState;
        if (networkState != null) {
            return networkState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mCurrentState");
        return null;
    }

    public final void setMCurrentState$network_tracker_release(@NotNull NetworkState networkState) {
        Intrinsics.checkNotNullParameter((Object)networkState, (String)"<set-?>");
        this.mCurrentState = networkState;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMCurrentState$network_tracker_release$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.getMListeners$network_tracker_release().add(listener) && this.getMListeners$network_tracker_release().size() == 1) {
                this.setMCurrentState$network_tracker_release(this.getInitialState$network_tracker_release());
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s: initial state = %s";
                Object[] objectArray = new Object[]{this.getClass().getSimpleName(), this.getMCurrentState$network_tracker_release()};
                boolean bl4 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                this.logger.d("NetworkStateTracker", string2);
                this.startTracking$network_tracker_release();
            }
            listener.onStateChanged(this.getMCurrentState$network_tracker_release());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.getMListeners$network_tracker_release().remove(listener) && this.getMListeners$network_tracker_release().isEmpty()) {
                this.stopTracking$network_tracker_release();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @VisibleForTesting
    @NotNull
    public final NetworkState getInitialState$network_tracker_release() {
        return this.getActiveNetworkState();
    }

    @VisibleForTesting
    public final void startTracking$network_tracker_release() {
        if (this.isNetworkCallbackSupported$network_tracker_release()) {
            try {
                this.logger.d("NetworkStateTracker", "Registering network callback");
                this.mConnectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.getMNetworkCallback$network_tracker_release());
            }
            catch (IllegalArgumentException e) {
                this.logger.e("NetworkStateTracker", "Received exception while registering network callback", (Throwable)e);
            }
            catch (SecurityException e) {
                this.logger.e("NetworkStateTracker", "Received exception while registering network callback", (Throwable)e);
            }
        } else {
            this.logger.d("NetworkStateTracker", "Registering broadcast receiver");
            this.mAppContext.registerReceiver((BroadcastReceiver)this.getMBroadcastReceiver$network_tracker_release(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    @VisibleForTesting
    public final void stopTracking$network_tracker_release() {
        if (this.isNetworkCallbackSupported$network_tracker_release()) {
            try {
                this.logger.d("NetworkStateTracker", "Unregistering network callback");
                this.mConnectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.getMNetworkCallback$network_tracker_release());
            }
            catch (IllegalArgumentException e) {
                this.logger.e("NetworkStateTracker", "Received exception while unregistering network callback", (Throwable)e);
            }
            catch (SecurityException e) {
                this.logger.e("NetworkStateTracker", "Received exception while unregistering network callback", (Throwable)e);
            }
        } else {
            this.logger.d("NetworkStateTracker", "Unregistering broadcast receiver");
            this.mAppContext.unregisterReceiver((BroadcastReceiver)this.getMBroadcastReceiver$network_tracker_release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void setState$network_tracker_release(@NotNull NetworkState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Object object = this.mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)this.getMCurrentState$network_tracker_release(), (Object)newState)) {
                return;
            }
            this.setMCurrentState$network_tracker_release(newState);
            List listenersList = new ArrayList(this.getMListeners$network_tracker_release());
            bl2 = new Handler(Looper.getMainLooper()).post(() -> NetworkStateTrackerImpl.setState$lambda-3$lambda-2(listenersList, this));
        }
    }

    @VisibleForTesting
    public final boolean isNetworkCallbackSupported$network_tracker_release() {
        return this.buildInfoProvider.isAndroidNAndAbove();
    }

    @Override
    @NotNull
    public NetworkState getActiveNetworkState() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        boolean isConnected = info != null && info.isConnected();
        boolean isValidated = this.isActiveNetworkValidated();
        boolean isMetered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
        boolean isNotRoaming = info != null && !info.isRoaming();
        return new NetworkState(isConnected, isValidated, isMetered, isNotRoaming, info);
    }

    private final boolean isActiveNetworkValidated() {
        boolean bl;
        if (Build.VERSION.SDK_INT < 23) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Network network = this.mConnectivityManager.getActiveNetwork();
                NetworkCapabilities capabilities = this.mConnectivityManager.getNetworkCapabilities(network);
                bl2 = capabilities != null && capabilities.hasCapability(16);
            }
            catch (SecurityException exception) {
                this.logger.e("NetworkStateTracker", "Unable to validate active network", (Throwable)exception);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private static final void setState$lambda-3$lambda-2(List $listenersList, NetworkStateTrackerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)$listenersList, (String)"$listenersList");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (NetworkStateListener listener : $listenersList) {
            listener.onStateChanged(this$0.getMCurrentState$network_tracker_release());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lcom/gojek/networktracker/NetworkStateTrackerImpl;)V", "onCapabilitiesChanged", "", "network", "Landroid/net/Network;", "capabilities", "Landroid/net/NetworkCapabilities;", "onLost", "network-tracker_release"})
    @RequiresApi(value=24)
    @VisibleForTesting
    public final class NetworkStateCallback
    extends ConnectivityManager.NetworkCallback {
        public NetworkStateCallback() {
            Intrinsics.checkNotNullParameter((Object)NetworkStateTrackerImpl.this, (String)"this$0");
        }

        public void onCapabilitiesChanged(@NonNull @NotNull Network network, @NonNull @NotNull NetworkCapabilities capabilities) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
            ILogger iLogger = NetworkStateTrackerImpl.this.logger;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Network capabilities changed: %s";
            Object[] objectArray = new Object[]{capabilities};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            iLogger.d("NetworkStateTracker", string2);
            NetworkStateTrackerImpl.this.setState$network_tracker_release(NetworkStateTrackerImpl.this.getActiveNetworkState());
        }

        public void onLost(@NonNull @NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            NetworkStateTrackerImpl.this.logger.d("NetworkStateTracker", "Network connection lost");
            NetworkStateTrackerImpl.this.setState$network_tracker_release(NetworkStateTrackerImpl.this.getActiveNetworkState());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/gojek/networktracker/NetworkStateTrackerImpl$NetworkStateBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "(Lcom/gojek/networktracker/NetworkStateTrackerImpl;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "network-tracker_release"})
    @VisibleForTesting
    public final class NetworkStateBroadcastReceiver
    extends BroadcastReceiver {
        public NetworkStateBroadcastReceiver() {
            Intrinsics.checkNotNullParameter((Object)NetworkStateTrackerImpl.this, (String)"this$0");
        }

        public void onReceive(@Nullable Context context, @Nullable Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.net.conn.CONNECTIVITY_CHANGE")) {
                NetworkStateTrackerImpl.this.logger.d("NetworkStateTracker", "Network broadcast received");
                NetworkStateTrackerImpl.this.setState$network_tracker_release(NetworkStateTrackerImpl.this.getActiveNetworkState());
            }
        }
    }
}

