/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IExperimentsConfig;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttInterceptor;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.NoOpLogger;
import org.eclipse.paho.client.mqttv3.NoOpsPahoEvents;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.LocalNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketSecureNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLIENT_ID_PREFIX = "paho-";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private String clientId;
    private String mqttVersion;
    private String serverURI;
    protected ClientComms comms;
    private ILogger logger;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private IPahoEvents pahoEvents;
    static final String className = MqttAsyncClient.class.getName();
    private final String TAG = "MqttAsyncClient";

    public MqttAsyncClient(String serverURI, String clientId, String mqttVersion) throws MqttException {
        this(serverURI, clientId, mqttVersion, new MqttDefaultFilePersistence(), new TimerPingSender(), new NoOpLogger());
    }

    public MqttAsyncClient(String serverURI, String clientId, String mqttVersion, MqttClientPersistence persistence, MqttPingSender mqttPingSender, ILogger logger) throws MqttException {
        this(serverURI, clientId, mqttVersion, persistence, 100, mqttPingSender, logger, new NoOpsPahoEvents(), null);
    }

    public MqttAsyncClient(String serverURI, String clientId, String mqttVersion, MqttClientPersistence persistence, int maxInflightMsgs, MqttPingSender pingSender, ILogger logger, IPahoEvents pahoEvents, IExperimentsConfig experimentsConfig) throws MqttException {
        this(serverURI, clientId, mqttVersion, persistence, 100, pingSender, logger, new NoOpsPahoEvents(), null, null);
    }

    public MqttAsyncClient(String serverURI, String clientId, String mqttVersion, MqttClientPersistence persistence, int maxInflightMsgs, MqttPingSender pingSender, ILogger logger, IPahoEvents pahoEvents, IExperimentsConfig experimentsConfig, List<MqttInterceptor> mqttInterceptorList) throws MqttException {
        String methodName = "MqttAsyncClient";
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.mqttVersion = mqttVersion;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, this.getMqttPingSender(pingSender), maxInflightMsgs, logger, experimentsConfig, mqttInterceptorList, pahoEvents);
        this.logger = logger;
        this.persistence.close();
        this.topics = new Hashtable();
        this.pahoEvents = pahoEvents;
    }

    private MqttPingSender getMqttPingSender(MqttPingSender mqttPingSender) {
        return mqttPingSender == null ? new TimerPingSender() : mqttPingSender;
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        char MIN_HIGH_SURROGATE = '\ud800';
        char MAX_HIGH_SURROGATE = '\udbff';
        return ch >= MIN_HIGH_SURROGATE && ch <= MAX_HIGH_SURROGATE;
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        String methodName = "createNetworkModules";
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        for (int i = 0; i < array.length; ++i) {
            networkModules[i] = this.createNetworkModule(array[i], options);
        }
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        NetworkModule netModule;
        String methodName = "createNetworkModule";
        SocketFactory factory = options.getSocketFactory();
        int serverURIType = MqttConnectOptions.validateURI(address);
        switch (serverURIType) {
            case 0: {
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 1883);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId, this.logger, this.pahoEvents);
                ((TCPNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                ((TCPNetworkModule)netModule).setReadTimeout(options.getReadTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 8883);
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId, this.logger, this.pahoEvents);
                ((SSLNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getHandshakeTimeout());
                ((SSLNetworkModule)netModule).setReadTimeout(options.getReadTimeout());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 3: {
                String shortAddress = address.substring(5);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 80);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketNetworkModule(factory, address, host, port, this.clientId, this.logger, this.pahoEvents);
                ((WebSocketNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                ((WebSocketNetworkModule)netModule).setReadTimeout(options.getReadTimeout());
                break;
            }
            case 4: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 443);
                SSLSocketFactoryFactory wSSFactoryFactory = null;
                if (factory == null) {
                    wSSFactoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        wSSFactoryFactory.initialize(sslClientProps, null);
                    }
                    factory = wSSFactoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, address, host, port, this.clientId, this.logger, this.pahoEvents);
                ((WebSocketSecureNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                ((WebSocketSecureNetworkModule)netModule).setSSLhandshakeTimeout(options.getHandshakeTimeout());
                ((WebSocketSecureNetworkModule)netModule).setReadTimeout(options.getReadTimeout());
                if (wSSFactoryFactory == null || (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 2: {
                netModule = new LocalNetworkModule(address.substring(8));
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private int getPort(String uri, int defaultPort) {
        int portIndex = uri.lastIndexOf(58);
        int port = portIndex == -1 ? defaultPort : Integer.valueOf(uri.substring(portIndex + 1));
        return port;
    }

    private String getHostName(String uri) {
        int schemeIndex = uri.lastIndexOf(47);
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(schemeIndex + 1, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        String methodName = "connect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback, this.pahoEvents);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "disconnect";
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
        }
        catch (MqttException ex) {
            this.logger.e("MqttAsyncClient", "Exception in disconnect : " + ex);
            throw ex;
        }
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    public boolean isConnecting() {
        return this.comms.isConnecting();
    }

    public boolean isDisconnecting() {
        return this.comms.isDisconnecting();
    }

    public boolean isDisconnected() {
        return this.comms.isDisconnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getMqttVersion() {
        return this.mqttVersion;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public void setServerURI(String serverURI) throws MqttException {
        if (null != this.serverURI && !this.serverURI.equals(serverURI)) {
            this.serverURI = serverURI;
        }
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopic.validate(topic, false);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    public IMqttToken checkPing(Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "ping";
        this.logger.d("MqttAsyncClient", "checking for ping");
        MqttToken token = this.comms.checkForActivity();
        return token;
    }

    public void checkActivity() {
        this.comms.checkActivity();
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "subscribe";
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i] + ":" + qos[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "unsubscribe";
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.comms.setCallback(callback);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        String methodName = "publish";
        MqttTopic.validate(topic, false);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        return token;
    }

    @Override
    public void close() throws MqttException {
        String methodName = "close";
        this.logger.d("MqttAsyncClient", "close started");
        this.comms.close();
        this.logger.d("MqttAsyncClient", "close completed");
    }

    public int getInflightMessages() {
        return this.comms.getClientState().getInflightMsgs();
    }

    public int getMaxflightMessages() {
        return this.comms.getClientState().getMaxInflightMsgs();
    }

    public void pingReq(IMqttActionListener listener) throws MqttException {
        if (this.comms != null && this.comms.isConnected() && this.getClientId() != null) {
            MqttToken token = new MqttToken(this.getClientId());
            token.setActionCallback(listener);
            MqttPingReq pingMsg = new MqttPingReq();
            this.comms.sendNoWait(pingMsg, token);
        }
    }

    public long getFastReconnectCheckStartTime() {
        return this.comms.getClientState().getFastReconnectCheckStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastOutboundActivity() {
        MqttAsyncClient mqttAsyncClient = this;
        synchronized (mqttAsyncClient) {
            if (this.comms != null && this.comms.getClientState() != null) {
                return this.comms.getClientState().getLastOutboundActivity();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastInboundActivity() {
        MqttAsyncClient mqttAsyncClient = this;
        synchronized (mqttAsyncClient) {
            try {
                ClientState clientState = this.comms != null ? this.comms.getClientState() : null;
                return clientState != null ? clientState.getLastInboundActivity() : 0L;
            }
            catch (NullPointerException nullPointerException) {
                return 0L;
            }
        }
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(bufferOpts));
    }

    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.comms.getBufferedMessage(bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.comms.deleteBufferedMessage(bufferIndex);
    }
}

