/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.wire.UserProperty;

public class MqttConnectOptions {
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int CONNECTION_TIMEOUT_DEFAULT = 30;
    public static final int HANDSHAKE_TIMEOUT_DEFAULT = 30;
    public static final int READ_TIMEOUT_DEFAULT = 360;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    protected static final int URI_TYPE_TCP = 0;
    protected static final int URI_TYPE_SSL = 1;
    protected static final int URI_TYPE_LOCAL = 2;
    protected static final int URI_TYPE_WS = 3;
    protected static final int URI_TYPE_WSS = 4;
    private int keepAliveInterval = 60;
    private int keepAliveIntervalServer = 60;
    private String willDestination = null;
    private MqttMessage willMessage = null;
    private String userName;
    private char[] password;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private boolean cleanSession = true;
    private int connectionTimeout = 30;
    private int handshakeTimeout = 30;
    private int readTimeout = 360;
    private String protocolName = "MQIsdp";
    private int protocolLevel = 3;
    private String[] serverURIs = null;
    private List<UserProperty> userPropertyList;

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (userName != null && userName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.userName = userName;
    }

    public void setWill(MqttTopic topic, byte[] payload, int qos, boolean retained) {
        String topicS = topic.getName();
        this.validateWill(topicS, payload);
        this.setWill(topicS, new MqttMessage(payload), qos, retained);
    }

    public void setWill(String topic, byte[] payload, int qos, boolean retained) {
        this.validateWill(topic, payload);
        this.setWill(topic, new MqttMessage(payload), qos, retained);
    }

    private void validateWill(String dest, Object payload) {
        if (dest == null || payload == null) {
            throw new IllegalArgumentException();
        }
        MqttTopic.validate(dest, false);
    }

    protected void setWill(String topic, MqttMessage msg, int qos, boolean retained) {
        this.willDestination = topic;
        this.willMessage = msg;
        this.willMessage.setQos(qos);
        this.willMessage.setRetained(retained);
        this.willMessage.setMutable(false);
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public int getKeepAliveIntervalServer() {
        return this.keepAliveIntervalServer;
    }

    public void setKeepAliveInterval(int keepAliveInterval) throws IllegalArgumentException {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setKeepAliveIntervalServer(int keepAliveInterval) throws IllegalArgumentException {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveIntervalServer = keepAliveInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.connectionTimeout = connectionTimeout;
    }

    public void setHandshakeTimeout(int handshakeTimeout) {
        if (handshakeTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.handshakeTimeout = handshakeTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.readTimeout = readTimeout;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties props) {
        this.sslClientProps = props;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public String[] getServerURIs() {
        return this.serverURIs;
    }

    public void setServerURIs(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            MqttConnectOptions.validateURI(array[i]);
        }
        this.serverURIs = array;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolLevel(int protocolLevel) {
        this.protocolLevel = protocolLevel;
    }

    public int getProtocolLevel() {
        return this.protocolLevel;
    }

    public List<UserProperty> getUserPropertyList() {
        return this.userPropertyList;
    }

    public void setUserPropertyList(List<UserProperty> userPropertyList) {
        this.userPropertyList = userPropertyList;
    }

    protected static int validateURI(String srvURI) {
        try {
            URI vURI = new URI(srvURI);
            if (!vURI.getPath().equals("")) {
                throw new IllegalArgumentException(srvURI);
            }
            if (vURI.getScheme().equals("tcp")) {
                return 0;
            }
            if (vURI.getScheme().equals("ssl")) {
                return 1;
            }
            if (vURI.getScheme().equals("local")) {
                return 2;
            }
            if (vURI.getScheme().equals("ws")) {
                return 3;
            }
            if (vURI.getScheme().equals("wss")) {
                return 4;
            }
            throw new IllegalArgumentException(srvURI);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(srvURI);
        }
    }

    public Properties getDebug() {
        Properties p = new Properties();
        p.put("CleanSession", new Boolean(this.isCleanSession()));
        p.put("ConTimeout", new Integer(this.getConnectionTimeout()));
        p.put("KeepAliveInterval", new Integer(this.getKeepAliveInterval()));
        p.put("UserName", this.getUserName() == null ? "null" : this.getUserName());
        p.put("WillDestination", this.getWillDestination() == null ? "null" : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            p.put("SocketFactory", "null");
        } else {
            p.put("SocketFactory", this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            p.put("SSLProperties", "null");
        } else {
            p.put("SSLProperties", this.getSSLProperties());
        }
        return p;
    }
}

