/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

public class TimerPingSender
implements MqttPingSender {
    private ClientComms comms;
    private ILogger logger;
    private Timer timer;
    private static final String className = TimerPingSender.class.getName();
    private final String TAG = "TimerPingSender";

    @Override
    public void init(ClientComms comms, ILogger logger) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
        this.logger = logger;
    }

    @Override
    public void start() {
        String methodName = "start";
        String clientid = this.comms.getClient().getClientId();
        this.timer = new Timer("MQTT Ping: " + clientid);
        this.timer.schedule((TimerTask)new PingTask(), this.comms.getKeepAlive());
    }

    @Override
    public void stop() {
        String methodName = "stop";
        this.logger.d("TimerPingSender", "Stopping timer");
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        this.timer.schedule((TimerTask)new PingTask(), delayInMilliseconds);
    }

    class PingTask
    extends TimerTask {
        private static final String methodName = "PingTask.run";

        PingTask() {
        }

        @Override
        public void run() {
            TimerPingSender.this.logger.d("TimerPingSender", "in ping timer task run function");
            TimerPingSender.this.comms.checkForActivity();
        }
    }
}

