/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.paho.client.mqttv3.BufferedMessage;
import org.eclipse.paho.client.mqttv3.ICommsCallback;
import org.eclipse.paho.client.mqttv3.IExperimentsConfig;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttInterceptor;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.NoOpsPahoEvents;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.IDiscardedBufferMessageCallback;
import org.eclipse.paho.client.mqttv3.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.client.mqttv3.internal.MqttInterceptorCallback;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    CommsReceiver receiver;
    CommsSender sender;
    ICommsCallback callback;
    ClientState clientState;
    MqttInterceptorCallback mqttInterceptorCallback;
    MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private ILogger logger;
    CommsTokenStore tokenStore;
    boolean stoppingComms = false;
    static final byte CONNECTED = 0;
    static final byte CONNECTING = 1;
    static final byte DISCONNECTING = 2;
    static final byte DISCONNECTED = 3;
    static final byte CLOSED = 4;
    private byte conState = (byte)3;
    Object conLock = new Object();
    private boolean closePending = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;
    private IPahoEvents pahoEvents;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "disconnected-buffer-thread"));
    private final String TAG = "CLIENTCOMMS";

    public ClientComms(IMqttAsyncClient client, MqttClientPersistence persistence, MqttPingSender pingSender, int maxInflightMsgs, ILogger logger, IExperimentsConfig experimentsConfig, List<MqttInterceptor> mqttInterceptorList, IPahoEvents pahoEvents) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.pingSender = pingSender;
        this.logger = logger;
        this.pingSender.init(this, logger);
        this.pahoEvents = pahoEvents;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this, logger);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this, pingSender, maxInflightMsgs, logger, experimentsConfig, pahoEvents);
        this.mqttInterceptorCallback = new MqttInterceptorCallback(mqttInterceptorList, logger);
        this.callback.setClientState(this.clientState);
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        this.internalSend(message, token, new NoOpsPahoEvents());
    }

    void internalSend(MqttWireMessage message, MqttToken token, IPahoEvents pahoEvents) throws MqttException {
        String methodName = "internalSend";
        if (token.getClient() != null) {
            this.logger.e("CLIENTCOMMS", "Token is already in use - cannot reuse");
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
            if (message.getType() == 1) {
                pahoEvents.onConnectPacketSend();
            }
        }
        catch (MqttException e) {
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        if (this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                if (message instanceof MqttPublish && ((MqttPublish)message).getMessage().getQos() > 0) {
                    if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                        this.clientState.persistBufferedMessage(message);
                    }
                    this.disconnectedMessageBuffer.putMessage(message, token);
                }
            } else {
                this.internalSend(message, token);
            }
        } else if (this.disconnectedMessageBuffer != null) {
            if (message instanceof MqttPublish && ((MqttPublish)message).getMessage().getQos() > 0) {
                if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                    this.clientState.persistBufferedMessage(message);
                }
                this.disconnectedMessageBuffer.putMessage(message, token);
            }
        } else {
            this.logger.e("CLIENTCOMMS", "send failed , not connected");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MqttException {
        String methodName = "close";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected()) {
                    this.logger.e("CLIENTCOMMS", "close failed not disconnected");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.executorService.shutdown();
                this.disconnectedMessageBuffer = null;
                this.clientState = null;
                this.callback = null;
                this.mqttInterceptorCallback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
                this.logger.d("CLIENTCOMMS", "close completed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions options, MqttToken token, IPahoEvents pahoEvents) throws MqttException {
        String methodName = "connect";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                this.logger.e("CLIENTCOMMS", "connect failed : not disconnected");
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.conState = 1;
            this.conOptions = options;
            MqttConnect connect = new MqttConnect(this.client.getClientId(), options.isCleanSession(), options.getKeepAliveIntervalServer(), options.getUserName(), options.getPassword(), options.getWillMessage(), options.getWillDestination(), options.getProtocolName(), options.getProtocolLevel(), options.getUserPropertyList());
            this.clientState.setKeepAliveSecs(options.getKeepAliveInterval());
            this.clientState.setCleanSession(options.isCleanSession());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect, pahoEvents);
            conbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack cack, MqttException mex) throws MqttException {
        String methodName = "connectComplete";
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                this.logger.d("CLIENTCOMMS", "client successfully connected");
                this.conState = 0;
                return;
            }
        }
        this.logger.e("CLIENTCOMMS", "connected failed , rc is not zero", mex);
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason) {
        boolean wasConnected;
        String methodName = "shutdownConnection";
        MqttToken endToken = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending) {
                return;
            }
            this.stoppingComms = true;
            this.logger.d("CLIENTCOMMS", "setting constate to DISCONNECTING");
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception ioe) {
            this.logger.e("CLIENTCOMMS", "exception while trying to stop network module", ioe);
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        if (this.tokenStore != null) {
            this.tokenStore.quiesce(new MqttException(32102));
        }
        endToken = this.handleOldTokens(token, reason);
        try {
            if (this.clientState != null) {
                this.clientState.disconnected(reason);
            }
        }
        catch (Exception ex) {
            this.logger.e("CLIENTCOMMS", "exception while trying to disconnect clientState", ex);
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        if (this.mqttInterceptorCallback != null) {
            this.mqttInterceptorCallback.stop();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception ex) {
            this.logger.e("CLIENTCOMMS", "exception while trying to close persistence db", ex);
        }
        object = this.conLock;
        synchronized (object) {
            this.logger.e("CLIENTCOMMS", "setting constate to : DISCONNECTED");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null & this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        object = this.conLock;
        synchronized (object) {
            if (wasConnected && this.callback != null) {
                this.callback.connectionLost(reason);
            }
            if (this.closePending) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        String methodName = "handleOldTokens";
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = (MqttToken)toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals(MqttDisconnect.KEY) || tok.internalTok.getKey().equals(MqttConnect.KEY)) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        String methodName = "disconnect";
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.logger.e("CLIENTCOMMS", "disconnect failed, cause : in closed state");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.logger.e("CLIENTCOMMS", "disconnect failed, cause : already disconnected");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.logger.e("CLIENTCOMMS", "disconnect failed, cause : already disconnecting");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.logger.e("CLIENTCOMMS", "disconnect failed, cause : called on callback thread");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.logger.d("CLIENTCOMMS", "setting constate state : DISCONNECTING");
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token);
            discbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.clientState.quiesce(quiesceTimeout);
        MqttToken token = new MqttToken(this.client.getClientId());
        try {
            this.internalSend(new MqttDisconnect(), token);
            token.waitForCompletion(disconnectTimeout);
        }
        catch (Exception exception) {
        }
        finally {
            token.internalTok.markComplete(null, null);
            this.shutdownConnection(token, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = networkModules;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", new Integer(this.conState));
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", new Boolean(this.stoppingComms));
        return props;
    }

    public void clear() {
        if (this.disconnectedMessageBuffer != null) {
            this.disconnectedMessageBuffer.clear();
        }
    }

    public MqttToken checkForActivity() {
        MqttToken token = null;
        try {
            token = this.clientState.checkForActivity();
        }
        catch (MqttException e) {
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
        return token;
    }

    public MqttToken sendPingRequest() {
        MqttToken token = null;
        try {
            token = this.clientState.sendForcePingRequest();
        }
        catch (MqttException e) {
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
        return token;
    }

    public void checkActivity() {
        try {
            this.clientState.checkActivity();
        }
        catch (MqttException e) {
            this.callback.fastReconnect();
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
    }

    private void handleRunException(Exception ex) {
        String methodName = "handleRunException";
        this.logger.e("CLIENTCOMMS", "excpetion occured , shutting down connection : ", ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.shutdownConnection(null, mex);
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
        this.clientState.setPersistence(persistence);
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttPublish send = (MqttPublish)this.disconnectedMessageBuffer.getMessage(bufferIndex).getMessage();
        return send.getMessage();
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.disconnectedMessageBuffer.deleteMessage(bufferIndex);
    }

    public void notifyConnect() {
        String methodName = "notifyConnect";
        if (this.disconnectedMessageBuffer != null) {
            this.disconnectedMessageBuffer.setPublishCallback(new ReconnectDisconnectedBufferCallback("notifyConnect"));
            this.disconnectedMessageBuffer.setMessageDiscardedCallBack(new MessageDiscardedCallback());
            this.executorService.execute(this.disconnectedMessageBuffer);
        }
    }

    public int getActualInFlight() {
        return this.clientState.getInflightMsgs();
    }

    class ReconnectDisconnectedBufferCallback
    implements IDisconnectedBufferCallback {
        final String methodName;

        ReconnectDisconnectedBufferCallback(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void publishBufferedMessage(BufferedMessage bufferedMessage) throws MqttException {
            if (ClientComms.this.isConnected()) {
                while (ClientComms.this.clientState.getInflightMsgs() >= ClientComms.this.clientState.getMaxInflightMsgs() - 3) {
                    Thread.yield();
                }
            } else {
                throw ExceptionHelper.createMqttException(32104);
            }
            ClientComms.this.internalSend(bufferedMessage.getMessage(), bufferedMessage.getToken());
            ClientComms.this.clientState.unPersistBufferedMessage(bufferedMessage.getMessage());
        }
    }

    class MessageDiscardedCallback
    implements IDiscardedBufferMessageCallback {
        MessageDiscardedCallback() {
        }

        @Override
        public void messageDiscarded(MqttWireMessage message) {
            if (ClientComms.this.disconnectedMessageBuffer.isPersistBuffer()) {
                ClientComms.this.clientState.unPersistBufferedMessage(message);
            }
            ClientComms.this.pahoEvents.onOfflineMessageDiscarded(message.getMessageId());
        }
    }

    private class DisconnectBG
    implements Runnable {
        Thread dBg = null;
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.dBg = new Thread((Runnable)this, "MQTT Disc: " + ClientComms.this.getClient().getClientId());
            this.dBg.start();
        }

        @Override
        public void run() {
            String methodName = "disconnectBG:run";
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                this.token.internalTok.waitUntilSent();
            }
            catch (MqttException mqttException) {
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        Thread cBg = null;
        MqttToken conToken;
        MqttConnect conPacket;
        IPahoEvents pahoEvents;

        ConnectBG(ClientComms cc, MqttToken cToken, MqttConnect cPacket, IPahoEvents pahoEvents) {
            this.clientComms = cc;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.cBg = new Thread((Runnable)this, "MQTT Con: " + ClientComms.this.getClient().getClientId());
            this.pahoEvents = pahoEvents;
        }

        void start() {
            this.cBg.start();
        }

        @Override
        public void run() {
            String methodName = "connectBG:run";
            MqttException mqttEx = null;
            long time = System.currentTimeMillis();
            String eventType = "socket_conn_event";
            try {
                MqttDeliveryToken[] toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                for (int i = 0; i < toks.length; ++i) {
                    toks[i].internalTok.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.logger.logEvent(eventType, true, ClientComms.this.client.getServerURI(), System.currentTimeMillis() - time, null, 0, 0L, 0L, "", 0);
                time = System.currentTimeMillis();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream(), networkModule.getSocket(), ClientComms.this.logger, ClientComms.this.mqttInterceptorCallback);
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream(), networkModule.getSocket(), ClientComms.this.logger, ClientComms.this.mqttInterceptorCallback);
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.mqttInterceptorCallback.start("MQTT Int Call: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.internalSend(this.conPacket, this.conToken, this.pahoEvents);
                eventType = "conn_pkt_event";
                ClientComms.this.logger.logEvent(eventType, true, ClientComms.this.client.getServerURI(), System.currentTimeMillis() - time, null, 0, 0L, 0L, "", 0);
            }
            catch (MqttException ex) {
                ClientComms.this.logger.e("CLIENTCOMMS", "connect failed : unxpected exception , cause : ", ex);
                mqttEx = ex;
            }
            catch (Exception ex) {
                ClientComms.this.logger.e("CLIENTCOMMS", "connect failed : unxpected exception , cause : ", ex);
                mqttEx = ExceptionHelper.createMqttException(ex);
            }
            if (mqttEx != null) {
                ClientComms.this.logger.logEvent(eventType, false, ClientComms.this.client.getServerURI(), System.currentTimeMillis() - time, mqttEx, mqttEx.getReasonCode(), 0L, 0L, "", 0);
                ClientComms.this.shutdownConnection(this.conToken, mqttEx);
            }
        }
    }
}

