/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.ICommsCallback;
import org.eclipse.paho.client.mqttv3.IExperimentsConfig;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttActionListenerNew;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class ClientState {
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_SENT_BUFFERED_PREFIX = "sb-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private Hashtable inUseMsgIds;
    private volatile Vector pendingMessages;
    private volatile Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private ICommsCallback callback = null;
    private ILogger logger;
    private long keepAlive;
    private boolean cleanSession;
    private MqttClientPersistence persistence;
    private int maxInflight = 10;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private Object queueLock = new Object();
    private Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long fastReconnectCheckStartTime = 0L;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private long lastPing = 0L;
    private MqttWireMessage pingCommand;
    private Boolean pingOutstanding = Boolean.FALSE;
    private boolean connected = false;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable inboundQoS2 = null;
    private MqttPingSender pingSender = null;
    private static final String className = ClientState.class.getName();
    private long inactivityTimeout = 60000L;
    private static final long DEFAULT_INACTIVITY_TIMEOUT = 60000L;
    private IPahoEvents pahoEvents;
    private final String TAG = "clientState";

    protected ClientState(MqttClientPersistence persistence, CommsTokenStore tokenStore, ICommsCallback callback, ClientComms clientComms, MqttPingSender pingSender, int maxInflightMsgs, ILogger logger, IExperimentsConfig experimentsConfig, IPahoEvents pahoEvents) throws MqttException {
        this.maxInflight = maxInflightMsgs;
        this.inUseMsgIds = new Hashtable();
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = persistence;
        this.callback = callback;
        this.tokenStore = tokenStore;
        this.clientComms = clientComms;
        this.pingSender = pingSender;
        this.logger = logger;
        this.pahoEvents = pahoEvents;
        if (experimentsConfig != null) {
            this.inactivityTimeout = (long)experimentsConfig.inactivityTimeoutSecs() * 1000L;
        }
        this.restoreState();
        logger.d("clientState", "client id : " + clientComms.getClient().getClientId());
    }

    protected void setKeepAliveSecs(long keepAliveSecs) {
        this.keepAlive = keepAliveSecs * 1000L;
    }

    protected long getKeepAlive() {
        return this.keepAlive;
    }

    protected void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    private String getSendPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_PREFIX + message.getMessageId();
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_CONFIRMED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_RECEIVED_PREFIX + message.getMessageId();
    }

    protected void clearState() throws MqttException {
        String methodName = "clearState";
        this.logger.d("clientState", "clearing state");
        this.persistence.clear();
        this.clientComms.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String key, MqttPersistable persistable) throws MqttException {
        String methodName = "restoreMessage";
        MqttWireMessage message = null;
        try {
            message = MqttWireMessage.createWireMessage(persistable, this.clientComms.getClient().getMqttVersion());
        }
        catch (MqttException ex) {
            this.logger.e("clientState", "exception in restore message, cause : ", ex);
            if (ex.getCause() instanceof EOFException) {
                if (key != null) {
                    this.persistence.remove(key);
                }
            }
            throw ex;
        }
        this.logger.d("clientState", "restoring message : " + message.toString() + " with key : " + key);
        return message;
    }

    private void insertInOrder(Vector list, MqttWireMessage newMsg) {
        int newMsgId = newMsg.getMessageId();
        for (int i = 0; i < list.size(); ++i) {
            MqttWireMessage otherMsg = (MqttWireMessage)list.elementAt(i);
            int otherMsgId = otherMsg.getMessageId();
            if (otherMsgId <= newMsgId) continue;
            list.insertElementAt(newMsg, i);
            return;
        }
        list.addElement(newMsg);
    }

    private Vector reOrder(Vector list) {
        int i;
        Vector newList = new Vector();
        if (list.size() == 0) {
            return newList;
        }
        int previousMsgId = 0;
        int largestGap = 0;
        int largestGapMsgIdPosInList = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int currentMsgId = ((MqttWireMessage)list.elementAt(i2)).getMessageId();
            if (currentMsgId - previousMsgId > largestGap) {
                largestGap = currentMsgId - previousMsgId;
                largestGapMsgIdPosInList = i2;
            }
            previousMsgId = currentMsgId;
        }
        int highestMsgId = previousMsgId;
        int lowestMsgId = ((MqttWireMessage)list.elementAt(0)).getMessageId();
        if (65535 - highestMsgId + lowestMsgId > largestGap) {
            largestGapMsgIdPosInList = 0;
        }
        for (i = largestGapMsgIdPosInList; i < list.size(); ++i) {
            newList.addElement(list.elementAt(i));
        }
        for (i = 0; i < largestGapMsgIdPosInList; ++i) {
            newList.addElement(list.elementAt(i));
        }
        return newList;
    }

    protected void restoreState() throws MqttException {
        String key;
        String methodName = "restoreState";
        Enumeration messageKeys = this.persistence.keys();
        int highestMsgId = this.nextMsgId;
        Vector<String> orphanedPubRels = new Vector<String>();
        this.logger.d("clientState", "restoring state");
        while (messageKeys.hasMoreElements()) {
            MqttPubRel pubRelMessage;
            MqttDeliveryToken tok;
            MqttPublish sendMessage;
            MqttPersistable persistable;
            key = (String)messageKeys.nextElement();
            MqttWireMessage message = this.restoreMessage(key, persistable = this.persistence.get(key));
            if (message == null) continue;
            if (key.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.inboundQoS2.put(message.getMessageId(), message);
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(sendMessage))) {
                    MqttPersistable persistedConfirm = this.persistence.get(this.getSendConfirmPersistenceKey(sendMessage));
                    MqttPubRel confirmMessage = (MqttPubRel)this.restoreMessage(key, persistedConfirm);
                    if (confirmMessage != null) {
                        confirmMessage.setDuplicate(true);
                        this.outboundQoS2.put(confirmMessage.getMessageId(), confirmMessage);
                    }
                } else {
                    sendMessage.setDuplicate(true);
                    if (sendMessage.getMessage().getQos() == 2) {
                        this.outboundQoS2.put(sendMessage.getMessageId(), sendMessage);
                    } else {
                        this.outboundQoS1.put(sendMessage.getMessageId(), sendMessage);
                    }
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(sendMessage.getMessageId(), sendMessage.getMessageId());
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_BUFFERED_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (sendMessage.getMessage().getQos() == 2) {
                    this.outboundQoS2.put(sendMessage.getMessageId(), sendMessage);
                } else if (sendMessage.getMessage().getQos() == 1) {
                    this.outboundQoS1.put(sendMessage.getMessageId(), sendMessage);
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(sendMessage.getMessageId(), sendMessage.getMessageId());
                continue;
            }
            if (!key.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(pubRelMessage = (MqttPubRel)message))) continue;
            orphanedPubRels.addElement(key);
        }
        messageKeys = orphanedPubRels.elements();
        while (messageKeys.hasMoreElements()) {
            key = (String)messageKeys.nextElement();
            this.persistence.remove(key);
        }
        this.nextMsgId = highestMsgId;
    }

    private void restoreInflightMessages() {
        Object msg;
        Object key;
        this.logger.d("clientState", "restoring inflight messages started");
        String methodName = "restoreInflightMessages";
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration keys = this.outboundQoS2.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = this.outboundQoS2.get(key);
            if (msg instanceof MqttPublish) {
                ((MqttPublish)msg).setDuplicate(true);
                this.insertInOrder(this.pendingMessages, (MqttPublish)msg);
                continue;
            }
            if (!(msg instanceof MqttPubRel)) continue;
            this.insertInOrder(this.pendingFlows, (MqttPubRel)msg);
        }
        keys = this.outboundQoS1.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS1.get(key);
            ((MqttWireMessage)msg).setDuplicate(true);
            this.insertInOrder(this.pendingMessages, (MqttWireMessage)msg);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
        this.logger.d("clientState", "restoring inflight messages completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "send";
        if (message.isMessageIdRequired() && message.getMessageId() == 0) {
            message.setMessageId(this.getNextMessageId());
        }
        if (token != null) {
            try {
                token.internalTok.setMessageID(message.getMessageId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.maxInflight) {
                    this.logger.e("clientState", "max in flight messages reached ");
                    throw new MqttException(32202);
                }
                MqttMessage innerMessage = ((MqttPublish)message).getMessage();
                switch (innerMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(message.getMessageId(), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(message.getMessageId(), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                    }
                }
                this.tokenStore.saveToken(token, message);
                this.pendingMessages.addElement(message);
                this.queueLock.notifyAll();
            }
        }
        if (message instanceof MqttConnect) {
            Object object = this.queueLock;
            synchronized (object) {
                this.tokenStore.saveToken(token, message);
                this.pendingFlows.insertElementAt(message, 0);
                this.queueLock.notifyAll();
            }
        }
        if (message instanceof MqttPingReq) {
            this.pingCommand = message;
        } else if (message instanceof MqttPubRel) {
            this.outboundQoS2.put(message.getMessageId(), message);
            this.persistence.put(this.getSendConfirmPersistenceKey(message), (MqttPubRel)message);
        } else if (message instanceof MqttPubComp) {
            this.persistence.remove(this.getReceivedPersistenceKey(message));
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (!(message instanceof MqttAck)) {
                this.tokenStore.saveToken(token, message);
            }
            this.pendingFlows.addElement(message);
            this.queueLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish message) throws MqttPersistenceException {
        String methodName = "undo";
        Object object = this.queueLock;
        synchronized (object) {
            if (message.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(message.getMessageId());
            } else {
                this.outboundQoS2.remove(message.getMessageId());
            }
            this.pendingMessages.removeElement(message);
            this.persistence.remove(this.getSendPersistenceKey(message));
            this.tokenStore.removeToken(message);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttToken checkForActivity() throws MqttException {
        String methodName = "checkForActivity";
        MqttToken token = null;
        long nextPingTime = this.getKeepAlive();
        if (this.connected && this.keepAlive > 0L) {
            long time = System.currentTimeMillis();
            int delta = 100;
            int keepAliveMargin = 5000;
            Boolean bl = this.pingOutstanding;
            synchronized (bl) {
                if (!this.pingOutstanding.booleanValue()) {
                    long lastActivity = this.lastInboundActivity;
                    if (time - lastActivity + (long)keepAliveMargin >= this.keepAlive) {
                        this.logger.d("clientState", "inserting ping in pending flows , lastoutboundactivity time : " + this.lastOutboundActivity + " lastinboundactivitytime : " + this.lastInboundActivity);
                        this.pingOutstanding = Boolean.TRUE;
                        this.lastPing = time;
                        token = new MqttToken(this.clientComms.getClient().getClientId());
                        this.tokenStore.saveToken(token, this.pingCommand);
                        this.pendingFlows.insertElementAt(this.pingCommand, 0);
                        nextPingTime = this.getKeepAlive();
                        this.notifyQueueLock();
                    } else {
                        nextPingTime = this.getKeepAlive() - (time - lastActivity);
                        this.logger.d("clientState", "ping not outstanding , nextping time : " + nextPingTime);
                    }
                } else if (time - this.lastPing >= this.keepAlive + (long)delta && time - this.lastInboundActivity >= this.keepAlive + (long)delta) {
                    this.logger.e("clientState", "timed out as no activity, already sent the ping but no response recieved,  lastoutboundactivity : " + this.lastOutboundActivity + " fastReconnectCheckStartTime : " + this.fastReconnectCheckStartTime + " lastinboundactivity : " + this.lastInboundActivity);
                    throw ExceptionHelper.createMqttException(32000);
                }
            }
            this.logger.d("clientState", "scheduling next ping time : " + nextPingTime);
            this.pingSender.schedule(nextPingTime);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttToken sendForcePingRequest() throws MqttException {
        String methodName = "checkForActivity";
        MqttToken token = null;
        if (this.connected && this.keepAlive > 0L) {
            long time = System.currentTimeMillis();
            int delta = 100;
            Boolean bl = this.pingOutstanding;
            synchronized (bl) {
                if (!this.pingOutstanding.booleanValue()) {
                    this.logger.d("clientState", "inserting ping in pending flows , lastoutboundactivity time : " + this.lastOutboundActivity + " lastinboundactivitytime : " + this.lastInboundActivity);
                    this.pingOutstanding = Boolean.TRUE;
                    this.lastPing = time;
                    token = new MqttToken(this.clientComms.getClient().getClientId());
                    this.tokenStore.saveToken(token, this.pingCommand);
                    this.pendingFlows.insertElementAt(this.pingCommand, 0);
                    this.notifyQueueLock();
                } else if (time - this.lastPing >= this.keepAlive + (long)delta && time - this.lastInboundActivity >= this.keepAlive + (long)delta && time - this.lastOutboundActivity >= this.keepAlive + (long)delta) {
                    this.logger.e("clientState", "timed out as no activity, already sent the ping but no response recieved,  lastoutboundactivity : " + this.lastOutboundActivity + " fastReconnectCheckStartTime : " + this.fastReconnectCheckStartTime + " lastinboundactivity : " + this.lastInboundActivity);
                    throw ExceptionHelper.createMqttException(32000);
                }
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActivity() throws MqttException {
        Boolean bl = this.pingOutstanding;
        synchronized (bl) {
            if (this.fastReconnectCheckStartTime > this.lastInboundActivity && System.currentTimeMillis() - this.fastReconnectCheckStartTime >= this.inactivityTimeout) {
                this.logger.logFastReconnectEvent(this.fastReconnectCheckStartTime, this.lastInboundActivity);
                this.logger.e("clientState", "not recieved ack for 1 min so disconnecting");
                throw ExceptionHelper.createMqttException(32000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage get() throws MqttException {
        String methodName = "get";
        MqttWireMessage result = null;
        long sTime = System.currentTimeMillis();
        Object object = this.queueLock;
        synchronized (object) {
            while (result == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty() || this.pendingFlows.isEmpty() && this.actualInFlight >= this.maxInflight) {
                    try {
                        this.logger.d("clientState", "waiting for new work or for space in the inflight window ");
                        this.queueLock.wait();
                        this.logger.d("clientState", "new work or ping arrived");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!(this.connected || !this.pendingFlows.isEmpty() && (MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect)) {
                    this.logger.d("clientState", "no outstanding flows and not connected");
                    String threadId = "clientState:" + Thread.currentThread().getName() + ":" + Thread.currentThread().getId();
                    this.logger.logMqttThreadEvent("get_empty_qos1_msg", System.currentTimeMillis() - sTime, threadId);
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    result = (MqttWireMessage)this.pendingFlows.remove(0);
                    if (result instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                    }
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight < this.maxInflight) {
                    result = (MqttWireMessage)this.pendingMessages.elementAt(0);
                    this.pendingMessages.removeElementAt(0);
                    ++this.actualInFlight;
                    continue;
                }
                this.logger.d("clientState", "inflight window full");
            }
        }
        String threadId = "clientState:" + Thread.currentThread().getName() + ":" + Thread.currentThread().getId();
        this.logger.logMqttThreadEvent("get_qos1_msg", System.currentTimeMillis() - sTime, threadId);
        return result;
    }

    public void setKeepAliveInterval(long interval) {
        this.keepAlive = interval;
    }

    long getTimeUntilPing() {
        long timeSinceIn;
        long time;
        long timeSinceOut;
        long pingin = this.getKeepAlive();
        if (this.connected && this.getKeepAlive() > 0L && !this.pingOutstanding.booleanValue() && (pingin = (timeSinceOut = (time = System.currentTimeMillis()) - this.lastOutboundActivity) > (timeSinceIn = time - this.lastInboundActivity) ? this.getKeepAlive() - timeSinceOut : this.getKeepAlive() - timeSinceIn) <= 0L) {
            pingin = 10L;
        }
        return pingin;
    }

    protected void notifySent(MqttWireMessage message) {
        String methodName = "notifySent";
        this.lastOutboundActivity = System.currentTimeMillis();
        MqttToken token = this.tokenStore.getToken(message);
        token.internalTok.notifySent();
        if (message instanceof MqttPublish) {
            if (((MqttPublish)message).getMessage().getQos() == 0) {
                token.internalTok.markComplete(null, null);
                this.callback.asyncOperationComplete(token);
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
                this.checkQuiesceLock();
            } else {
                this.checkAndSetFastReconnectCheckStartTime();
                this.notifySentCallback(token);
            }
        } else if (message instanceof MqttPingReq || message instanceof MqttConnect || message instanceof MqttSubscribe || message instanceof MqttUnsubscribe) {
            this.checkAndSetFastReconnectCheckStartTime();
        }
    }

    private void checkAndSetFastReconnectCheckStartTime() {
        if (this.fastReconnectCheckStartTime <= this.lastInboundActivity) {
            this.fastReconnectCheckStartTime = System.currentTimeMillis();
            this.logger.d("clientState", "fastReconnect Check StartTime : " + this.fastReconnectCheckStartTime);
        }
    }

    public void notifySentCallback(MqttToken token) {
        IMqttActionListenerNew asyncCB;
        if (token != null && (asyncCB = (IMqttActionListenerNew)token.getActionCallback()) != null) {
            asyncCB.notifyWrittenOnSocket(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        String methodName = "decrementInFlight";
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkQuiesceLock() {
        String methodName = "checkQuiesceLock";
        int tokC = this.tokenStore.count();
        if (this.quiescing && tokC == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivedAck(MqttAck ack) throws MqttException {
        String methodName = "notifyReceivedAck";
        this.onInboundActivity();
        MqttToken token = this.tokenStore.getToken(ack);
        MqttException mex = null;
        if (token == null) {
            this.logger.d("clientState", "Token = null for MqttAck" + ack);
        } else if (ack instanceof MqttPubRec) {
            MqttPubRel rel = new MqttPubRel((MqttPubRec)ack);
            this.send(rel, token);
        } else if (ack instanceof MqttPubAck || ack instanceof MqttPubComp) {
            this.notifyResult(ack, token, mex);
        } else if (ack instanceof MqttPingResp) {
            Boolean rel = this.pingOutstanding;
            synchronized (rel) {
                this.pingOutstanding = Boolean.FALSE;
                this.notifyResult(ack, token, mex);
                this.tokenStore.removeToken(ack);
            }
        } else if (ack instanceof MqttConnack) {
            Object object;
            int rc = ((MqttConnack)ack).getReturnCode();
            if (rc == 0) {
                object = this.queueLock;
                synchronized (object) {
                    if (this.cleanSession) {
                        this.clearState();
                        this.tokenStore.saveToken(token, ack);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                mex = ExceptionHelper.createMqttException(rc);
                throw mex;
            }
            this.clientComms.connectComplete((MqttConnack)ack, mex);
            this.notifyResult(ack, token, mex);
            this.tokenStore.removeToken(ack);
            object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult(ack, token, mex);
            this.releaseMessageId(ack.getMessageId());
            this.tokenStore.removeToken(ack);
        }
        this.checkQuiesceLock();
    }

    protected void notifyReceivedMsg(MqttWireMessage message) throws MqttException {
        String methodName = "notifyReceivedMsg";
        this.onInboundActivity();
        if (!this.quiescing) {
            if (message instanceof MqttPublish) {
                MqttPublish send = (MqttPublish)message;
                switch (send.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback == null) break;
                        String logMessage = "Calling call back Message arrived for message ";
                        this.logger.d("clientState", logMessage + ":" + send.getMessage().toString());
                        this.callback.messageArrived(send);
                        break;
                    }
                    case 2: {
                        this.persistence.put(this.getReceivedPersistenceKey(message), (MqttPublish)message);
                        this.inboundQoS2.put(send.getMessageId(), send);
                        this.send(new MqttPubRec(send), null);
                    }
                }
            } else if (message instanceof MqttPubRel) {
                MqttPublish sendMsg = (MqttPublish)this.inboundQoS2.get(message.getMessageId());
                if (sendMsg != null) {
                    if (this.callback != null) {
                        this.callback.messageArrived(sendMsg);
                    }
                } else {
                    MqttPubComp pubComp = new MqttPubComp(message.getMessageId());
                    this.send(pubComp, null);
                }
            }
        }
    }

    protected void notifyComplete(MqttToken token) throws MqttException {
        String methodName = "notifyComplete";
        MqttWireMessage message = token.internalTok.getWireMessage();
        if (message != null && message instanceof MqttAck) {
            MqttAck ack = (MqttAck)message;
            if (ack instanceof MqttPubAck) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.persistence.remove(this.getSendBufferedPersistenceKey(message));
                this.outboundQoS1.remove(ack.getMessageId());
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
            } else if (ack instanceof MqttPubComp) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.persistence.remove(this.getSendConfirmPersistenceKey(message));
                this.persistence.remove(this.getSendBufferedPersistenceKey(message));
                this.outboundQoS2.remove(ack.getMessageId());
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
            }
            this.checkQuiesceLock();
        }
    }

    protected void notifyResult(MqttWireMessage ack, MqttToken token, MqttException ex) {
        try {
            String methodName = "notifyResult";
            token.internalTok.markComplete(ack, ex);
            if (ack != null && ack instanceof MqttAck && !(ack instanceof MqttPubRec)) {
                this.callback.asyncOperationComplete(token);
            }
            if (ack == null) {
                this.callback.asyncOperationComplete(token);
            }
        }
        catch (Exception e) {
            this.logger.e("clientState", "Exception occured", e);
        }
    }

    public void connected() {
        String methodName = "connected";
        this.logger.d("clientState", "client has successfully connected");
        this.connected = true;
        this.pingSender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector resolveOldTokens(MqttException reason) {
        String methodName = "resolveOldTokens";
        MqttException shutReason = reason;
        if (reason == null) {
            shutReason = new MqttException(32102);
        }
        Vector outT = this.tokenStore.getOutstandingTokens();
        Enumeration outTE = outT.elements();
        while (outTE.hasMoreElements()) {
            MqttToken tok;
            MqttToken mqttToken = tok = (MqttToken)outTE.nextElement();
            synchronized (mqttToken) {
                if (!tok.isComplete() && !tok.internalTok.isCompletePending() && tok.getException() == null) {
                    tok.internalTok.setException(shutReason);
                }
            }
            if (tok instanceof MqttDeliveryToken) continue;
            this.tokenStore.removeToken(tok.internalTok.getKey());
        }
        return outT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(MqttException reason) {
        String methodName = "disconnected";
        this.connected = false;
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            Boolean bl = this.pingOutstanding;
            synchronized (bl) {
                this.pingOutstanding = Boolean.FALSE;
            }
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    private synchronized void releaseMessageId(int msgId) {
        this.inUseMsgIds.remove(msgId);
    }

    private synchronized int getNextMessageId() throws MqttException {
        int startingMessageId = this.nextMsgId;
        int loopCount = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != startingMessageId || ++loopCount != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(this.nextMsgId));
        Integer id = this.nextMsgId;
        this.inUseMsgIds.put(id, id);
        return this.nextMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(long timeout) {
        String methodName = "quiesce";
        if (timeout > 0L) {
            this.logger.d("clientState", "quiesce started, timeout : " + timeout);
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int tokc = this.tokenStore.count();
                    if (tokc > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        this.quiesceLock.wait(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            this.logger.d("clientState", "quiesce completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyQueueLock() {
        String methodName = "notifyQueueLock";
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
    }

    protected void deliveryComplete(MqttPublish message) throws MqttPersistenceException {
        String methodName = "deliveryComplete";
        this.persistence.remove(this.getReceivedPersistenceKey(message));
        this.inboundQoS2.remove(message.getMessageId());
    }

    protected void close() {
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
        this.fastReconnectCheckStartTime = 0L;
        this.lastOutboundActivity = 0L;
        this.lastInboundActivity = 0L;
        this.lastPing = 0L;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("In use msgids", this.inUseMsgIds);
        props.put("pendingMessages", this.pendingMessages);
        props.put("pendingFlows", this.pendingFlows);
        props.put("maxInflight", (Object)this.maxInflight);
        props.put("nextMsgID", (Object)this.nextMsgId);
        props.put("actualInFlight", (Object)this.actualInFlight);
        props.put("inFlightPubRels", (Object)this.inFlightPubRels);
        props.put("quiescing", new Boolean(this.quiescing));
        props.put("pingoutstanding", this.pingOutstanding);
        props.put("lastOutboundActivity", (Object)this.lastOutboundActivity);
        props.put("lastInboundActivity", (Object)this.lastInboundActivity);
        props.put("outboundQoS2", this.outboundQoS2);
        props.put("outboundQoS1", this.outboundQoS1);
        props.put("inboundQoS2", this.inboundQoS2);
        props.put("tokens", this.tokenStore);
        return props;
    }

    public int getInflightMsgs() {
        return this.actualInFlight;
    }

    public int getMaxInflightMsgs() {
        return this.maxInflight;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    public long getFastReconnectCheckStartTime() {
        return this.fastReconnectCheckStartTime;
    }

    public long getLastOutboundActivity() {
        return this.lastOutboundActivity;
    }

    public long getLastInboundActivity() {
        return this.lastInboundActivity;
    }

    public void persistBufferedMessage(MqttWireMessage message) throws MqttException {
        String methodName = "persistBufferedMessage";
        message.setMessageId(this.getNextMessageId());
        String key = this.getSendBufferedPersistenceKey(message);
        try {
            this.persistence.put(key, (MqttPublish)message);
        }
        catch (MqttPersistenceException mpe) {
            this.persistence.open(this.clientComms.getClient().getClientId(), this.clientComms.getClient().getServerURI());
            this.persistence.put(key, (MqttPublish)message);
        }
    }

    public void unPersistBufferedMessage(MqttWireMessage message) {
        String methodName = "unPersistBufferedMessage";
        try {
            this.persistence.remove(this.getSendBufferedPersistenceKey(message));
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            // empty catch block
        }
    }

    private String getSendBufferedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_BUFFERED_PREFIX + message.getMessageId();
    }

    private void onInboundActivity() {
        this.lastInboundActivity = System.currentTimeMillis();
        this.logger.d("clientState", "Last in bound activity changed : " + this.lastInboundActivity);
        this.pahoEvents.onInboundInactivity();
    }
}

