/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Vector;
import org.eclipse.paho.client.mqttv3.ICommsCallback;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;

public class CommsCallback
implements Runnable,
ICommsCallback {
    private static int INBOUND_QUEUE_SIZE = 100;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    private ILogger logger;
    static final String className = CommsCallback.class.getName();
    private final String TAG = "COMMSCALLBACK";

    CommsCallback(ClientComms clientComms, ILogger logger) {
        this.clientComms = clientComms;
        this.logger = logger;
        this.messageQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.completeQueue = new Vector(INBOUND_QUEUE_SIZE);
    }

    @Override
    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackThread = new Thread((Runnable)this, threadName);
                this.callbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                this.logger.d("COMMSCALLBACK", "callback thread stop started");
                this.running = false;
                if (this.callbackThread != null && !Thread.currentThread().equals(this.callbackThread)) {
                    String threadId = this.callbackThread.getName() + this.callbackThread.getId();
                    long sTime = System.currentTimeMillis();
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.workAvailable.notifyAll();
                        }
                        this.callbackThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.logger.logMqttThreadEvent("callback_stop", System.currentTimeMillis() - sTime, threadId);
                    }
                }
            }
            this.callbackThread = null;
            this.logger.d("COMMSCALLBACK", "callback thread stop completed");
        }
    }

    @Override
    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        String threadId = this.callbackThread.getName() + this.callbackThread.getId();
        this.logger.logInitEvent("callback_start", System.currentTimeMillis(), threadId);
        while (this.running) {
            try {
                Object token;
                try {
                    Object object = this.workAvailable;
                    synchronized (object) {
                        if (this.running & this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.logger.d("COMMSCALLBACK", "Callback Thread Waiting on workAvailable");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.running) {
                    token = null;
                    Vector vector = this.completeQueue;
                    synchronized (vector) {
                        if (!this.completeQueue.isEmpty()) {
                            token = (MqttToken)this.completeQueue.elementAt(0);
                            this.completeQueue.removeElementAt(0);
                        }
                    }
                    if (null != token) {
                        this.handleActionComplete((MqttToken)token);
                    }
                    MqttPublish message = null;
                    Vector vector2 = this.messageQueue;
                    synchronized (vector2) {
                        if (!this.messageQueue.isEmpty()) {
                            message = (MqttPublish)this.messageQueue.elementAt(0);
                            String logMsg = "removed message from message queue, message";
                            this.logger.d("COMMSCALLBACK", logMsg + " : " + message.getMessage().toString());
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (null != message) {
                        this.handleMessage(message);
                    }
                }
                if (this.quiescing) {
                    this.clientState.checkQuiesceLock();
                }
                token = this.spaceAvailable;
                synchronized (token) {
                    this.spaceAvailable.notifyAll();
                }
            }
            catch (Throwable ex) {
                this.logger.e("COMMSCALLBACK", "exception occured, shutting down : ", ex);
                this.running = false;
                this.logger.logInitEvent("callback_fail", System.currentTimeMillis(), threadId + " : " + ex.getMessage());
                this.clientComms.shutdownConnection(null, new MqttException(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        String methodName = "handleActionComplete";
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            this.logger.d("COMMSCALLBACK", "in handle action complete");
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete()) {
                token.internalTok.setNotified(true);
            }
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
            this.logger.d("COMMSCALLBACK", "out handle action complete");
        }
    }

    @Override
    public void connectionLost(MqttException cause) {
        String methodName = "connectionLost";
        try {
            if (this.mqttCallback != null && cause != null) {
                this.logger.e("COMMSCALLBACK", "Connection lost occured", cause);
                this.mqttCallback.connectionLost(cause);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void fastReconnect() {
        if (this.mqttCallback != null) {
            this.logger.e("COMMSCALLBACK", "Fast Disconnect");
            this.mqttCallback.fastReconnect();
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        String methodName = "fireActionEvent";
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                asyncCB.onSuccess(token);
            } else {
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(MqttPublish sendMessage) {
        String methodName = "messageArrived";
        if (this.mqttCallback != null) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                while (!this.quiescing && this.messageQueue.size() >= INBOUND_QUEUE_SIZE) {
                    try {
                        this.logger.d("COMMSCALLBACK", "Waiting on call back Thread on space available");
                        this.spaceAvailable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.quiescing) {
                String logMsg = "adding message";
                this.logger.d("COMMSCALLBACK", logMsg + " : " + sendMessage.getMessage().toString());
                this.messageQueue.addElement(sendMessage);
                Object object2 = this.workAvailable;
                synchronized (object2) {
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quiesce() {
        String methodName = "quiesce";
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            this.spaceAvailable.notifyAll();
        }
    }

    @Override
    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String methodName = "handleMessage";
        if (this.mqttCallback != null) {
            String logMsg = "in handle  message for message";
            this.logger.d("COMMSCALLBACK", logMsg + " : " + publishMessage.getMessage().toString());
            String destName = publishMessage.getTopicName();
            logMsg = "calling callback thread message arrived, msg ";
            this.logger.d("COMMSCALLBACK", logMsg + " : " + publishMessage.getMessage().toString());
            boolean sendAck = this.mqttCallback.messageArrived(destName, publishMessage.getMessage());
            if (publishMessage.getMessage().getQos() == 1 && sendAck) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2 && sendAck) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncOperationComplete(MqttToken token) {
        String methodName = "asyncOperationComplete";
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            this.logger.e("COMMSCALLBACK", "problem in asyncopcomplete shutting down, cause : ", ex);
            System.err.println("problem in asyncopcomplete " + ex);
            ex.printStackTrace();
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    @Override
    public Thread getThread() {
        return this.callbackThread;
    }
}

