/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.MqttInterceptorCallback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsReceiver
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private volatile boolean receiving;
    private Socket socket = null;
    private ILogger logger;
    private MqttInterceptorCallback mqttInterceptorCallback;
    private static final String className = CommsReceiver.class.getName();
    private final String TAG = "CommsReciever";

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in, Socket socket, ILogger logger, MqttInterceptorCallback mqttInterceptorCallback) {
        this.socket = socket;
        this.in = new MqttInputStream(in, clientComms.getClient().getMqttVersion());
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.logger = logger;
        this.mqttInterceptorCallback = mqttInterceptorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        String methodName = "start";
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.recThread = new Thread((Runnable)this, threadName);
                this.recThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            this.logger.d("CommsReciever", "Reciever stopping started");
            if (this.running) {
                this.running = false;
                this.receiving = false;
                if (this.recThread != null && !Thread.currentThread().equals(this.recThread)) {
                    String threadId = this.recThread.getName() + this.recThread.getId();
                    long sTime = System.currentTimeMillis();
                    try {
                        this.recThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.logger.logMqttThreadEvent("receiver_stop", System.currentTimeMillis() - sTime, threadId);
                    }
                }
            }
        }
        this.recThread = null;
        this.logger.d("CommsReciever", "reciever stopping completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttToken token = null;
        String threadId = this.recThread.getName() + this.recThread.getId();
        while (this.running && this.in != null) {
            long sTime = System.currentTimeMillis();
            try {
                Object logMsg2;
                this.receiving = true;
                MqttWireMessage message = this.in.readMqttWireMessage(this.mqttInterceptorCallback);
                this.receiving = false;
                if (message instanceof MqttPublish) {
                    logMsg2 = "socket read completed for message";
                    this.logger.d("CommsReciever", (String)logMsg2 + " : " + ((MqttPublish)message).getMessage().toString());
                    int length = ((MqttPublish)message).getHeaderLength() + ((MqttPublish)message).getPayloadLength();
                    this.logger.d("CommsReciever", "bytes read on socket : " + length);
                    if (((MqttPublish)message).getMessage().getQos() == 1) {
                        this.logger.logEvent("offline_msg_rcv_event", true, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, null, 0, System.currentTimeMillis(), length, threadId, message.getMessageId());
                    }
                } else if (message instanceof MqttAck) {
                    this.logger.d("CommsReciever", "socket read completed for ack : " + ((MqttAck)message).toString());
                    long logMsg2 = ((MqttAck)message).getMessageId();
                } else {
                    this.logger.d("CommsReciever", "socket read completed");
                }
                this.logSocketProperties();
                if (message instanceof MqttAck) {
                    if (this.tokenStore != null) {
                        token = this.tokenStore.getToken(message);
                    }
                    if (token == null) {
                        MqttException ex = new MqttException(6);
                        this.logger.logEvent("mqtt_ack_rcv_event", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, ex, 6, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                        throw ex;
                    }
                    this.logger.logEvent("mqtt_ack_rcv_event", true, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, null, 0, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    logMsg2 = token;
                    synchronized (logMsg2) {
                        this.clientState.notifyReceivedAck((MqttAck)message);
                    }
                } else {
                    this.clientState.notifyReceivedMsg(message);
                }
                this.logger.logMessageReceivedData(message);
            }
            catch (MqttException ex) {
                this.logger.e("CommsReciever", "exception occured , cause : ", ex);
                this.running = false;
                this.logger.logEvent("offline_msg_rcv_event", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, ex, ex.getReasonCode(), System.currentTimeMillis(), 0L, threadId, -1);
                this.clientComms.shutdownConnection(token, ex);
            }
            catch (IOException ioe) {
                this.logger.e("CommsReciever", "IO excetion occured , cause : ", ioe);
                this.logger.logEvent("offline_msg_rcv_event", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, ioe, 32109, System.currentTimeMillis(), 0L, threadId, -1);
                this.running = false;
                if (this.clientComms.isDisconnecting()) continue;
                this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
            }
            finally {
                this.receiving = false;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }

    private void logSocketProperties() {
        try {
            if (this.socket.getChannel() != null) {
                this.logger.d("CommsReciever", "is socket channel blocking : " + this.socket.getChannel().isBlocking());
                this.logger.d("CommsReciever", "is socket channel connected : " + this.socket.getChannel().isConnected());
                this.logger.d("CommsReciever", "is socket channel connection pending : " + this.socket.getChannel().isConnectionPending());
                this.logger.d("CommsReciever", "is socket channel open : " + this.socket.getChannel().isOpen());
                this.logger.d("CommsReciever", "is socket channel connected : " + this.socket.getChannel().isRegistered());
                this.logger.d("CommsReciever", "socket channel validOps: " + this.socket.getChannel().validOps());
            }
            this.logger.d("CommsReciever", "is socket closed : " + this.socket.isClosed() + "  is socket connected : " + this.socket.isConnected() + "  is socket input shutdown : " + this.socket.isInputShutdown() + "  is socket output shutdown : " + this.socket.isOutputShutdown());
        }
        catch (Exception ex) {
            this.logger.e("CommsReciever", "exception during taking logs", ex);
        }
    }
}

