/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.MqttInterceptorCallback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsSender
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;
    private Socket socket = null;
    private ILogger logger;
    private MqttInterceptorCallback mqttInterceptorCallback;
    private static final String className = CommsSender.class.getName();
    private final String TAG = "COMMSSENDER";

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out, Socket socket, ILogger logger, MqttInterceptorCallback mqttInterceptorCallback) {
        this.socket = socket;
        this.out = new MqttOutputStream(out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.logger = logger;
        this.mqttInterceptorCallback = mqttInterceptorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.sendThread = new Thread((Runnable)this, threadName);
                this.sendThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            this.logger.d("COMMSSENDER", "sender stop started");
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.sendThread)) {
                    if (this.clientState != null) {
                        this.clientState.notifyQueueLock();
                    }
                    if (this.sendThread != null) {
                        String threadId = this.sendThread.getName() + this.sendThread.getId();
                        long sTime = System.currentTimeMillis();
                        try {
                            this.sendThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.logger.logMqttThreadEvent("sender_stop", System.currentTimeMillis() - sTime, threadId);
                        }
                    }
                }
            }
            this.sendThread = null;
            this.logger.d("COMMSSENDER", "sender stop completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttWireMessage message = null;
        String threadId = this.sendThread.getName() + this.sendThread.getId();
        while (this.running && this.out != null) {
            long sTime = System.currentTimeMillis();
            try {
                message = this.clientState.get();
                if (message != null) {
                    if (message instanceof MqttPubAck) {
                        this.logger.d("COMMSSENDER", "Sending Ack for packet" + message);
                    }
                    if (message instanceof MqttAck) {
                        this.logger.d("COMMSSENDER", "Sending Ack for packet" + message);
                        this.out.write(this.mqttInterceptorCallback, message);
                        this.out.flush();
                        this.logger.logEvent("mqtt_ack_send_event", true, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, null, 0, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    } else {
                        MqttToken token = this.tokenStore.getToken(message);
                        if (token != null) {
                            MqttToken mqttToken = token;
                            synchronized (mqttToken) {
                                String preLogLine;
                                block24: {
                                    if (message instanceof MqttPublish) {
                                        preLogLine = "socket write started for message code : ";
                                        this.logger.d("COMMSSENDER", preLogLine + ((MqttPublish)message).getMessage().toString());
                                        this.logger.d("COMMSSENDER", "socket write started for message id : " + ((MqttPublish)message).getMessageId());
                                        this.logSocketProperties();
                                    } else {
                                        preLogLine = "socket write started for message : ";
                                        this.logger.d("COMMSSENDER", preLogLine + message.toString());
                                        this.logSocketProperties();
                                    }
                                    this.out.write(this.mqttInterceptorCallback, message);
                                    try {
                                        this.out.flush();
                                    }
                                    catch (IOException ex) {
                                        this.logger.e("COMMSSENDER", "IO Exception in send ", ex);
                                        if (message instanceof MqttDisconnect) break block24;
                                        throw ex;
                                    }
                                }
                                if (message instanceof MqttPublish) {
                                    preLogLine = "socket write completed for message code : ";
                                    this.logger.d("COMMSSENDER", preLogLine + ((MqttPublish)message).getMessage().toString());
                                    this.logger.d("COMMSSENDER", "socket write completed for message : " + ((MqttPublish)message).getMessageId());
                                    int length = ((MqttPublish)message).getHeaderLength() + ((MqttPublish)message).getPayloadLength();
                                    this.logger.d("COMMSSENDER", "bytes written on socket : " + length);
                                    this.logSocketProperties();
                                } else {
                                    preLogLine = "socket write completed for message : ";
                                    this.logger.d("COMMSSENDER", preLogLine + message.toString());
                                    this.logSocketProperties();
                                }
                                this.clientState.notifySent(message);
                                this.logger.logEvent("mqtt_qos1_msg_send", true, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, null, 0, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                            }
                        }
                    }
                    this.logger.logMessageSentData(message);
                    continue;
                }
                this.logger.e("COMMSSENDER", "get message returned null, stopping");
                this.running = false;
            }
            catch (MqttException me) {
                if (message != null) {
                    if (message instanceof MqttAck) {
                        this.logger.logEvent("mqtt_ack_send_event", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, me, me.getReasonCode(), System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    } else {
                        this.logger.logEvent("mqtt_qos1_msg_send", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, me, me.getReasonCode(), System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    }
                }
                this.handleRunException(message, me);
            }
            catch (Exception ex) {
                if (message != null) {
                    if (message instanceof MqttAck) {
                        this.logger.logEvent("mqtt_ack_send_event", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, ex, 0, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    } else {
                        this.logger.logEvent("mqtt_qos1_msg_send", false, this.clientComms.getClient().getServerURI(), System.currentTimeMillis() - sTime, ex, 0, System.currentTimeMillis(), 0L, threadId, message.getMessageId());
                    }
                }
                this.handleRunException(message, ex);
            }
        }
    }

    private void handleRunException(MqttWireMessage message, Exception ex) {
        String methodName = "handleRunException";
        this.logger.e("COMMSSENDER", "Exception occured, cause : ", ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.running = false;
        this.clientComms.shutdownConnection(null, mex);
    }

    private void logSocketProperties() {
        try {
            if (this.socket.getChannel() != null) {
                this.logger.d("COMMSSENDER", "is socket channel blocking : " + this.socket.getChannel().isBlocking());
                this.logger.d("COMMSSENDER", "is socket channel connected : " + this.socket.getChannel().isConnected());
                this.logger.d("COMMSSENDER", "is socket channel connection pending : " + this.socket.getChannel().isConnectionPending());
                this.logger.d("COMMSSENDER", "is socket channel open : " + this.socket.getChannel().isOpen());
                this.logger.d("COMMSSENDER", "is socket channel connected : " + this.socket.getChannel().isRegistered());
                this.logger.d("COMMSSENDER", "socket channel validOps: " + this.socket.getChannel().validOps());
            }
            this.logger.d("COMMSSENDER", "is socket closed : " + this.socket.isClosed() + "  is socket connected : " + this.socket.isConnected() + "  is socket input shutdown : " + this.socket.isInputShutdown() + "  is socket output shutdown : " + this.socket.isOutputShutdown());
        }
        catch (Exception ex) {
            this.logger.e("COMMSSENDER", "exception during taking logs", ex);
        }
    }
}

