/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.List;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.MqttInterceptor;

public class MqttInterceptorCallback
implements Runnable {
    private final String TAG = "MqttInterceptorCallback";
    private static final int INBOUND_QUEUE_SIZE = 200;
    private final List<MqttInterceptor> mqttInterceptorList;
    private final Vector<MqttInterceptorMessage> messageQueue;
    private final Object lifecycle = new Object();
    private final Object workAvailable = new Object();
    private final Object spaceAvailable = new Object();
    private final ILogger logger;
    public boolean running = false;
    private Thread interceptorThread;

    MqttInterceptorCallback(List<MqttInterceptor> mqttInterceptorList, ILogger logger) {
        this.mqttInterceptorList = mqttInterceptorList;
        this.logger = logger;
        this.messageQueue = new Vector(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.running = true;
                this.interceptorThread = new Thread((Runnable)this, threadName);
                this.interceptorThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                if (this.interceptorThread != null && !Thread.currentThread().equals(this.interceptorThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.workAvailable.notifyAll();
                        }
                        this.interceptorThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Object object;
                try {
                    Object object2 = this.workAvailable;
                    synchronized (object2) {
                        if (this.running & this.messageQueue.isEmpty()) {
                            this.logger.d("MqttInterceptorCallback", "Callback Thread Waiting on workAvailable");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MqttInterceptorMessage message = null;
                if (this.running) {
                    object = this.messageQueue;
                    synchronized (object) {
                        if (!this.messageQueue.isEmpty()) {
                            message = this.messageQueue.elementAt(0);
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (null != message) {
                        this.handleMessage(message);
                    }
                }
                object = this.spaceAvailable;
                synchronized (object) {
                    this.spaceAvailable.notifyAll();
                }
            }
            catch (Throwable ex) {
                this.logger.e("MqttInterceptorCallback", "exception occurred, shutting mqtt interceptor callback : ", ex);
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mqttMessageIntercepted(byte[] mqttWireMessageBytes, boolean isSent) {
        MqttInterceptorMessage mqttInterceptorMessage = new MqttInterceptorMessage(mqttWireMessageBytes, isSent);
        Object object = this.spaceAvailable;
        synchronized (object) {
            while (this.messageQueue.size() >= 200) {
                try {
                    this.logger.d("MqttInterceptorCallback", "Waiting on call back Thread on space available");
                    this.spaceAvailable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.messageQueue.addElement(mqttInterceptorMessage);
        object = this.workAvailable;
        synchronized (object) {
            this.workAvailable.notifyAll();
        }
    }

    private void handleMessage(MqttInterceptorMessage message) {
        if (this.mqttInterceptorList != null) {
            for (MqttInterceptor mqttInterceptor : this.mqttInterceptorList) {
                try {
                    if (message.isSent) {
                        mqttInterceptor.onMqttWireMessageSent(message.mqttWireMessageBytes);
                        continue;
                    }
                    mqttInterceptor.onMqttWireMessageReceived(message.mqttWireMessageBytes);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class MqttInterceptorMessage {
        private final byte[] mqttWireMessageBytes;
        private final boolean isSent;

        MqttInterceptorMessage(byte[] mqttWireMessageBytes, boolean isSent) {
            this.mqttWireMessageBytes = mqttWireMessageBytes;
            this.isSent = isSent;
        }

        public byte[] getMqttWireMessageBytes() {
            return this.mqttWireMessageBytes;
        }

        public boolean isSent() {
            return this.isSent;
        }
    }
}

