/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;

public class SSLNetworkModule
extends TCPNetworkModule {
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;
    static final String className = SSLNetworkModule.class.getName();
    private final String TAG = "SSLNETWORKMODULE";

    public SSLNetworkModule(SSLSocketFactory factory, String host, int port, String resourceContext, ILogger logger, IPahoEvents pahoEvents) {
        super(factory, host, port, resourceContext, logger, pahoEvents);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        String methodName = "setEnabledCiphers";
        this.enabledCiphers = enabledCiphers;
        if (this.socket != null && enabledCiphers != null) {
            ((SSLSocket)this.socket).setEnabledCipherSuites(enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int timeout) {
        this.handshakeTimeoutSecs = timeout;
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        long socketStartTime = System.nanoTime();
        try {
            this.pahoEvents.onSSLSocketAttempt(this.port, this.host, this.socket.getSoTimeout());
            this.socket = ((SSLSocketFactory)this.factory).createSocket(this.socket, this.host, this.port, true);
            long socketEndTime = System.nanoTime();
            this.pahoEvents.onSSLSocketSuccess(this.port, this.host, this.socket.getSoTimeout(), TimeUnit.NANOSECONDS.toMillis(socketEndTime - socketStartTime));
            this.setEnabledCiphers(this.enabledCiphers);
            int soTimeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
            long handshakeStartTime = System.nanoTime();
            ((SSLSocket)this.socket).startHandshake();
            long handshakeEndTime = System.nanoTime();
            this.pahoEvents.onSSLHandshakeSuccess(this.port, this.host, this.socket.getSoTimeout(), TimeUnit.NANOSECONDS.toMillis(handshakeEndTime - handshakeStartTime));
            this.socket.setSoTimeout(soTimeout);
        }
        catch (IOException ex) {
            long socketEndTime = System.nanoTime();
            this.pahoEvents.onSSLSocketFailure(this.port, this.host, this.socket.getSoTimeout(), ex, TimeUnit.NANOSECONDS.toMillis(socketEndTime - socketStartTime));
            throw ex;
        }
    }

    @Override
    public void stop() throws IOException {
        this.socket.close();
    }
}

