/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IPahoEvents;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;

public class TCPNetworkModule
implements NetworkModule {
    protected Socket socket;
    protected SocketFactory factory;
    private SocketFactory defaultSocketFactory = SocketFactory.getDefault();
    protected String host;
    protected int port;
    private int conTimeout;
    private int readTimeout;
    private ILogger logger;
    protected IPahoEvents pahoEvents;
    static final String className = TCPNetworkModule.class.getName();
    private final String TAG = "TCPNETWORKMODULE";

    public TCPNetworkModule(SocketFactory factory, String host, int port, String resourceContext, ILogger logger, IPahoEvents pahoEvents) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.logger = logger;
        this.pahoEvents = pahoEvents;
    }

    @Override
    public void start() throws IOException, MqttException {
        String methodName = "start";
        long sTime = 0L;
        try {
            this.logger.d("TCPNETWORKMODULE", "Trying to connect on host : " + this.host + " and port :" + this.port);
            long dnsStartTime = System.currentTimeMillis();
            InetSocketAddress sockaddr = new InetSocketAddress(this.host, this.port);
            long dnsEndTime = System.currentTimeMillis();
            this.logger.d("TCPNETWORKMODULE", "DNS resolved : timeTaken in dns call : " + (dnsEndTime - dnsStartTime));
            this.logger.d("TCPNETWORKMODULE", "TCP readTimeout : " + this.readTimeout + "conTimeout : " + this.conTimeout);
            this.socket = this.defaultSocketFactory.createSocket();
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.readTimeout * 1000);
            this.pahoEvents.onSocketConnectAttempt(this.port, this.host, this.conTimeout * 1000);
            sTime = System.nanoTime();
            this.socket.connect(sockaddr, this.conTimeout * 1000);
            long eTime = System.nanoTime();
            long timeTaken = TimeUnit.NANOSECONDS.toMillis(eTime - sTime);
            this.pahoEvents.onSocketConnectSuccess(timeTaken, this.port, this.host, this.conTimeout * 1000);
            this.logger.d("TCPNETWORKMODULE", "Connected : saving TIME_TAKEN_IN_LAST_SOCKET_CONNECT : " + timeTaken);
        }
        catch (ConnectException ex) {
            this.logger.e("TCPNETWORKMODULE", "failed to create TCP Socket", ex);
            long timeTaken = -1L;
            if (sTime != 0L) {
                timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime);
            }
            this.pahoEvents.onSocketConnectFailure(timeTaken, this.port, this.host, this.conTimeout * 1000, ex);
            throw new MqttException(32103, (Throwable)ex);
        }
        catch (Throwable ex) {
            this.logger.e("TCPNETWORKMODULE", "failed to create TCP Socket", ex);
            long timeTaken = -1L;
            if (sTime != 0L) {
                timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime);
            }
            this.pahoEvents.onSocketConnectFailure(timeTaken, this.port, this.host, this.conTimeout * 1000, ex);
            throw ex;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void stop() throws IOException {
        try {
            if (this.socket != null) {
                if (this.socket.getOutputStream() != null) {
                    this.socket.shutdownOutput();
                }
                if (this.socket.getInputStream() != null) {
                    this.socket.shutdownInput();
                }
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.logger.e("TCPNETWORKMODULE", "exception while trying to stop network module", e);
            this.socket.close();
        }
    }

    public void setConnectTimeout(int timeout) {
        this.conTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }
}

