/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.UserProperty;

public class MqttConnect
extends MqttWireMessage {
    public static final byte USER_DEFINED_PAIR_IDENTIFIER = 38;
    public static String KEY = "Con";
    private String protocolName;
    private int protocolLevel;
    private String clientId;
    private boolean cleanSession;
    private MqttMessage willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private String willDestination;
    private List<UserProperty> userProperties;

    public MqttConnect(byte info, byte[] data) throws IOException, MqttException {
        super((byte)1);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.protocolName = this.decodeUTF8(dis);
        this.protocolLevel = dis.readByte();
        byte connect_flags = dis.readByte();
        this.cleanSession = (connect_flags >> 1 & 1) > 0;
        boolean willMessagePresent = (connect_flags >> 2 & 1) > 0;
        int willMessageQos = connect_flags >> 3 & 3;
        boolean willMessageRetained = (connect_flags >> 5 & 1) > 0;
        boolean userNamePresent = (connect_flags >> 7 & 1) > 0;
        boolean passwordPresent = (connect_flags >> 6 & 1) > 0;
        this.keepAliveInterval = dis.readUnsignedShort();
        this.clientId = this.decodeUTF8(dis);
        if (willMessagePresent) {
            this.willMessage = new MqttMessage();
            this.willDestination = this.decodeUTF8(dis);
            short payloadLength = dis.readShort();
            byte[] payload = new byte[payloadLength];
            dis.read(payload, 0, payloadLength);
            this.willMessage.setPayload(payload);
            this.willMessage.setQos(willMessageQos);
            this.willMessage.setRetained(willMessageRetained);
        }
        if (userNamePresent) {
            this.userName = this.decodeUTF8(dis);
            if (passwordPresent) {
                this.password = this.decodeUTF8(dis).toCharArray();
            }
        }
        dis.close();
    }

    public MqttConnect(String clientId, boolean cleanSession, int keepAliveInterval, String userName, char[] password, MqttMessage willMessage, String willDestination, String protocolName, int protocolLevel, List<UserProperty> userProperties) {
        super((byte)1);
        this.protocolName = protocolName;
        this.protocolLevel = protocolLevel;
        this.clientId = clientId;
        this.cleanSession = cleanSession;
        this.keepAliveInterval = keepAliveInterval;
        this.userName = userName;
        this.password = password;
        this.willMessage = willMessage;
        this.willDestination = willDestination;
        this.userProperties = userProperties;
    }

    @Override
    public String toString() {
        String rc = super.toString();
        rc = rc + " clientId " + this.clientId + " keepAliveInterval " + this.keepAliveInterval;
        return rc;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.encodeUTF8(dos, this.protocolName);
            dos.write(this.protocolLevel);
            int connectFlags = 0;
            if (this.cleanSession) {
                connectFlags = (byte)(connectFlags | 2);
            }
            if (this.willMessage != null) {
                connectFlags = (byte)(connectFlags | 4);
                connectFlags = (byte)(connectFlags | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    connectFlags = (byte)(connectFlags | 0x20);
                }
            }
            if (this.userName != null) {
                connectFlags = (byte)(connectFlags | 0x80);
                if (this.password != null) {
                    connectFlags = (byte)(connectFlags | 0x40);
                }
            }
            dos.write(connectFlags);
            dos.writeShort(this.keepAliveInterval);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.encodeUTF8(dos, this.clientId);
            if (this.willMessage != null) {
                this.encodeUTF8(dos, this.willDestination);
                dos.writeShort(this.willMessage.getPayload().length);
                dos.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                this.encodeUTF8(dos, this.userName);
                if (this.password != null) {
                    this.encodeUTF8(dos, new String(this.password));
                }
            }
            if (this.userProperties != null && !this.userProperties.isEmpty()) {
                for (UserProperty property : this.userProperties) {
                    dos.writeByte(38);
                    this.encodeUTF8(dos, property.getKey());
                    this.encodeUTF8(dos, property.getValue());
                }
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return new String(KEY);
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.password;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public String getWillDestination() {
        return this.willDestination;
    }
}

