/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.MqttInterceptorCallback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttOutputStream
extends OutputStream {
    private static final String className = MqttOutputStream.class.getName();
    private final String TAG = "MQTTOUTPUTSTREAM";
    private BufferedOutputStream out;

    public MqttOutputStream(OutputStream out) {
        this.out = new BufferedOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(MqttInterceptorCallback mqttInterceptorCallback, MqttWireMessage message) throws IOException, MqttException {
        String methodName = "write";
        byte[] bytes = message.getHeader();
        byte[] pl = message.getPayload();
        this.out.write(bytes, 0, bytes.length);
        this.out.write(pl, 0, pl.length);
        this.intercept(mqttInterceptorCallback, message);
    }

    private void intercept(MqttInterceptorCallback mqttInterceptorCallback, MqttWireMessage mqttWireMessage) throws MqttException {
        byte[] bytes = mqttWireMessage.getHeader();
        byte[] pl = mqttWireMessage.getPayload();
        byte[] packet = new byte[bytes.length + pl.length];
        System.arraycopy(bytes, 0, packet, 0, bytes.length);
        System.arraycopy(pl, 0, packet, bytes.length, pl.length);
        mqttInterceptorCallback.mqttMessageIntercepted(packet, true);
    }
}

