/*
 * Decompiled with CFR 0.152.
 */
package com.gojek.timer.pingsender;

import androidx.annotation.VisibleForTesting;
import com.gojek.courier.extensions.TimeUnitExtensionsKt;
import com.gojek.courier.utils.Clock;
import com.gojek.mqtt.pingsender.IPingSenderEvents;
import com.gojek.mqtt.pingsender.MqttPingSender;
import com.gojek.mqtt.pingsender.NoOpPingSenderEvents;
import com.gojek.timer.pingsender.TimerFactory;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.paho.client.mqttv3.ILogger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u000e8\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/gojek/timer/pingsender/TimerPingSender;", "Lcom/gojek/mqtt/pingsender/MqttPingSender;", "clock", "Lcom/gojek/courier/utils/Clock;", "timerFactory", "Lcom/gojek/timer/pingsender/TimerFactory;", "(Lcom/gojek/courier/utils/Clock;Lcom/gojek/timer/pingsender/TimerFactory;)V", "comms", "Lorg/eclipse/paho/client/mqttv3/internal/ClientComms;", "logger", "Lorg/eclipse/paho/client/mqttv3/ILogger;", "pingSenderEvents", "Lcom/gojek/mqtt/pingsender/IPingSenderEvents;", "timer", "Ljava/util/Timer;", "getTimer$timer_pingsender_release$annotations", "()V", "getTimer$timer_pingsender_release", "()Ljava/util/Timer;", "setTimer$timer_pingsender_release", "(Ljava/util/Timer;)V", "init", "", "schedule", "delayInMilliseconds", "", "setPingEventHandler", "start", "stop", "PingTask", "timer-pingsender_release"})
public final class TimerPingSender
implements MqttPingSender {
    @NotNull
    private final Clock clock;
    @NotNull
    private final TimerFactory timerFactory;
    private ClientComms comms;
    private ILogger logger;
    public Timer timer;
    @NotNull
    private IPingSenderEvents pingSenderEvents;

    public TimerPingSender(@NotNull Clock clock, @NotNull TimerFactory timerFactory) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)timerFactory, (String)"timerFactory");
        this.clock = clock;
        this.timerFactory = timerFactory;
        this.pingSenderEvents = (IPingSenderEvents)new NoOpPingSenderEvents();
    }

    public /* synthetic */ TimerPingSender(Clock clock, TimerFactory timerFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = new Clock();
        }
        if ((n & 2) != 0) {
            timerFactory = new TimerFactory();
        }
        this(clock, timerFactory);
    }

    @NotNull
    public final Timer getTimer$timer_pingsender_release() {
        Timer timer = this.timer;
        if (timer != null) {
            return timer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"timer");
        return null;
    }

    public final void setTimer$timer_pingsender_release(@NotNull Timer timer) {
        Intrinsics.checkNotNullParameter((Object)timer, (String)"<set-?>");
        this.timer = timer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTimer$timer_pingsender_release$annotations() {
    }

    public void init(@NotNull ClientComms comms, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)comms, (String)"comms");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.comms = comms;
        this.logger = logger;
    }

    public void start() {
        ClientComms clientComms;
        ClientComms clientComms2;
        ILogger iLogger;
        ILogger iLogger2 = this.logger;
        if (iLogger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            iLogger = null;
        } else {
            iLogger = iLogger2;
        }
        iLogger.d("TimerPingSender", "Starting timer");
        ClientComms clientComms3 = this.comms;
        if (clientComms3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
            clientComms2 = null;
        } else {
            clientComms2 = clientComms3;
        }
        String clientId = clientComms2.getClient().getClientId();
        this.setTimer$timer_pingsender_release(this.timerFactory.getTimer(Intrinsics.stringPlus((String)"MQTT Ping: ", (Object)clientId)));
        clientComms3 = this.comms;
        if (clientComms3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
            clientComms = null;
        } else {
            clientComms = clientComms3;
        }
        this.schedule(clientComms.getKeepAlive());
    }

    public void stop() {
        ILogger iLogger;
        ILogger iLogger2 = this.logger;
        if (iLogger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            iLogger = null;
        } else {
            iLogger = iLogger2;
        }
        iLogger.d("TimerPingSender", "Stopping timer");
        if (this.timer != null) {
            this.getTimer$timer_pingsender_release().cancel();
        }
    }

    public void schedule(long delayInMilliseconds) {
        ClientComms clientComms;
        this.getTimer$timer_pingsender_release().schedule((TimerTask)new PingTask(), delayInMilliseconds);
        long l = TimeUnitExtensionsKt.fromMillisToSeconds((long)delayInMilliseconds);
        ClientComms clientComms2 = this.comms;
        if (clientComms2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
            clientComms = null;
        } else {
            clientComms = clientComms2;
        }
        this.pingSenderEvents.mqttPingScheduled(l, TimeUnitExtensionsKt.fromMillisToSeconds((long)clientComms.getKeepAlive()));
    }

    public void setPingEventHandler(@NotNull IPingSenderEvents pingSenderEvents) {
        Intrinsics.checkNotNullParameter((Object)pingSenderEvents, (String)"pingSenderEvents");
        this.pingSenderEvents = pingSenderEvents;
    }

    public TimerPingSender() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/gojek/timer/pingsender/TimerPingSender$PingTask;", "Ljava/util/TimerTask;", "(Lcom/gojek/timer/pingsender/TimerPingSender;)V", "run", "", "timer-pingsender_release"})
    public final class PingTask
    extends TimerTask {
        public PingTask() {
            Intrinsics.checkNotNullParameter((Object)TimerPingSender.this, (String)"this$0");
        }

        @Override
        public void run() {
            ClientComms clientComms;
            ClientComms clientComms2;
            ClientComms clientComms3;
            ClientComms clientComms4;
            ILogger iLogger;
            ILogger iLogger2 = TimerPingSender.this.logger;
            if (iLogger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                iLogger = null;
            } else {
                iLogger = iLogger2;
            }
            iLogger.d("TimerPingSender", "Sending ping");
            Object object = TimerPingSender.this.comms;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
                clientComms4 = null;
            } else {
                clientComms4 = object;
            }
            IMqttAsyncClient iMqttAsyncClient = clientComms4.getClient();
            String serverUri = iMqttAsyncClient == null ? "" : ((object = iMqttAsyncClient.getServerURI()) == null ? "" : object);
            Object object2 = TimerPingSender.this.comms;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
                clientComms3 = null;
            } else {
                clientComms3 = object2;
            }
            long keepAliveMillis = clientComms3.getKeepAlive();
            IPingSenderEvents iPingSenderEvents = TimerPingSender.this.pingSenderEvents;
            ClientComms clientComms5 = TimerPingSender.this.comms;
            if (clientComms5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
                clientComms2 = null;
            } else {
                clientComms2 = clientComms5;
            }
            object2 = clientComms2.getClient().getServerURI();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"comms.client.serverURI");
            iPingSenderEvents.mqttPingInitiated((String)object2, TimeUnitExtensionsKt.fromMillisToSeconds((long)keepAliveMillis));
            clientComms5 = TimerPingSender.this.comms;
            if (clientComms5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"comms");
                clientComms = null;
            } else {
                clientComms = clientComms5;
            }
            MqttToken token = clientComms.checkForActivity();
            if (token == null) {
                ClientComms clientComms6;
                clientComms5 = TimerPingSender.this.logger;
                if (clientComms5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    clientComms6 = null;
                } else {
                    clientComms6 = clientComms5;
                }
                clientComms6.d("TimerPingSender", "Mqtt Ping Token null");
                TimerPingSender.this.pingSenderEvents.pingMqttTokenNull(serverUri, TimeUnitExtensionsKt.fromMillisToSeconds((long)keepAliveMillis));
                return;
            }
            long sTime = TimerPingSender.this.clock.nanoTime();
            token.setActionCallback(new IMqttActionListener(TimerPingSender.this, sTime, serverUri, keepAliveMillis){
                final /* synthetic */ TimerPingSender this$0;
                final /* synthetic */ long $sTime;
                final /* synthetic */ String $serverUri;
                final /* synthetic */ long $keepAliveMillis;
                {
                    this.this$0 = $receiver;
                    this.$sTime = $sTime;
                    this.$serverUri = $serverUri;
                    this.$keepAliveMillis = $keepAliveMillis;
                }

                public void onSuccess(@NotNull IMqttToken asyncActionToken) {
                    ILogger iLogger;
                    Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                    ILogger iLogger2 = TimerPingSender.access$getLogger$p(this.this$0);
                    if (iLogger2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        iLogger = null;
                    } else {
                        iLogger = iLogger2;
                    }
                    iLogger.d("TimerPingSender", "Mqtt Ping Sent successfully");
                    long timeTaken = TimeUnitExtensionsKt.fromNanosToMillis((long)(TimerPingSender.access$getClock$p(this.this$0).nanoTime() - this.$sTime));
                    TimerPingSender.access$getPingSenderEvents$p(this.this$0).pingEventSuccess(this.$serverUri, timeTaken, TimeUnitExtensionsKt.fromMillisToSeconds((long)this.$keepAliveMillis));
                }

                public void onFailure(@NotNull IMqttToken asyncActionToken, @NotNull Throwable exception) {
                    ILogger iLogger;
                    Intrinsics.checkNotNullParameter((Object)asyncActionToken, (String)"asyncActionToken");
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    ILogger iLogger2 = TimerPingSender.access$getLogger$p(this.this$0);
                    if (iLogger2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        iLogger = null;
                    } else {
                        iLogger = iLogger2;
                    }
                    iLogger.d("TimerPingSender", "Mqtt Ping Sent failed");
                    long timeTaken = TimeUnitExtensionsKt.fromNanosToMillis((long)(TimerPingSender.access$getClock$p(this.this$0).nanoTime() - this.$sTime));
                    TimerPingSender.access$getPingSenderEvents$p(this.this$0).pingEventFailure(this.$serverUri, timeTaken, exception, TimeUnitExtensionsKt.fromMillisToSeconds((long)this.$keepAliveMillis));
                }
            });
        }
    }
}

