/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.KeyToolkit;
import org.apache.parquet.crypto.keytools.KmsClient;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public abstract class RemoteKmsClient
implements KmsClient {
    public static final String LOCAL_WRAP_NO_KEY_VERSION = "NO_VERSION";
    protected String kmsInstanceID;
    protected String kmsInstanceURL;
    protected String kmsToken;
    protected Boolean isWrapLocally;
    protected Configuration hadoopConfiguration;
    protected boolean isDefaultToken;
    private ConcurrentMap<String, byte[]> masterKeyCache;

    @Override
    public void initialize(Configuration configuration, String kmsInstanceID, String kmsInstanceURL, String accessToken) {
        this.kmsInstanceID = kmsInstanceID;
        this.kmsInstanceURL = kmsInstanceURL;
        this.isWrapLocally = configuration.getBoolean("parquet.encryption.wrap.locally", false);
        if (this.isWrapLocally.booleanValue()) {
            this.masterKeyCache = new ConcurrentHashMap<String, byte[]>();
        }
        this.hadoopConfiguration = configuration;
        this.kmsToken = accessToken;
        this.isDefaultToken = this.kmsToken.equals("DEFAULT");
        this.initializeInternal();
    }

    @Override
    public String wrapKey(byte[] key, String masterKeyIdentifier) throws KeyAccessDeniedException {
        if (this.isWrapLocally.booleanValue()) {
            byte[] masterKey = this.masterKeyCache.computeIfAbsent(masterKeyIdentifier, k -> this.getKeyFromServer(masterKeyIdentifier));
            byte[] AAD = masterKeyIdentifier.getBytes(StandardCharsets.UTF_8);
            String encryptedEncodedKey = KeyToolkit.encryptKeyLocally(key, masterKey, AAD);
            return LocalKeyWrap.createSerialized(encryptedEncodedKey);
        }
        this.refreshToken();
        return this.wrapKeyInServer(key, masterKeyIdentifier);
    }

    @Override
    public byte[] unwrapKey(String wrappedKey, String masterKeyIdentifier) throws KeyAccessDeniedException {
        if (this.isWrapLocally.booleanValue()) {
            LocalKeyWrap keyWrap = LocalKeyWrap.parse(wrappedKey);
            String masterKeyVersion = keyWrap.getMasterKeyVersion();
            if (!LOCAL_WRAP_NO_KEY_VERSION.equals(masterKeyVersion)) {
                throw new ParquetCryptoRuntimeException("Master key versions are not supported for local wrapping: " + masterKeyVersion);
            }
            String encryptedEncodedKey = keyWrap.getEncryptedKey();
            byte[] masterKey = this.masterKeyCache.computeIfAbsent(masterKeyIdentifier, k -> this.getKeyFromServer(masterKeyIdentifier));
            byte[] AAD = masterKeyIdentifier.getBytes(StandardCharsets.UTF_8);
            return KeyToolkit.decryptKeyLocally(encryptedEncodedKey, masterKey, AAD);
        }
        this.refreshToken();
        return this.unwrapKeyInServer(wrappedKey, masterKeyIdentifier);
    }

    private void refreshToken() {
        if (this.isDefaultToken) {
            return;
        }
        this.kmsToken = this.hadoopConfiguration.getTrimmed("parquet.encryption.key.access.token");
        if (KeyToolkit.stringIsEmpty(this.kmsToken)) {
            throw new ParquetCryptoRuntimeException("Empty token");
        }
    }

    private byte[] getKeyFromServer(String keyIdentifier) {
        this.refreshToken();
        return this.getMasterKeyFromServer(keyIdentifier);
    }

    protected abstract String wrapKeyInServer(byte[] var1, String var2) throws KeyAccessDeniedException, UnsupportedOperationException;

    protected abstract byte[] unwrapKeyInServer(String var1, String var2) throws KeyAccessDeniedException, UnsupportedOperationException;

    protected abstract byte[] getMasterKeyFromServer(String var1) throws KeyAccessDeniedException, UnsupportedOperationException;

    protected abstract void initializeInternal() throws KeyAccessDeniedException;

    static class LocalKeyWrap {
        public static final String LOCAL_WRAP_KEY_VERSION_FIELD = "masterKeyVersion";
        public static final String LOCAL_WRAP_ENCRYPTED_KEY_FIELD = "encryptedKey";
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private String encryptedEncodedKey;
        private String masterKeyVersion;

        private LocalKeyWrap(String masterKeyVersion, String encryptedEncodedKey) {
            this.masterKeyVersion = masterKeyVersion;
            this.encryptedEncodedKey = encryptedEncodedKey;
        }

        private static String createSerialized(String encryptedEncodedKey) {
            HashMap<String, String> keyWrapMap = new HashMap<String, String>(2);
            keyWrapMap.put(LOCAL_WRAP_KEY_VERSION_FIELD, RemoteKmsClient.LOCAL_WRAP_NO_KEY_VERSION);
            keyWrapMap.put(LOCAL_WRAP_ENCRYPTED_KEY_FIELD, encryptedEncodedKey);
            try {
                return OBJECT_MAPPER.writeValueAsString(keyWrapMap);
            }
            catch (IOException e) {
                throw new ParquetCryptoRuntimeException("Failed to serialize local key wrap map", e);
            }
        }

        private static LocalKeyWrap parse(String wrappedKey) {
            Map keyWrapMap = null;
            try {
                keyWrapMap = (Map)OBJECT_MAPPER.readValue((Reader)new StringReader(wrappedKey), (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                throw new ParquetCryptoRuntimeException("Failed to parse local key wrap json " + wrappedKey, e);
            }
            String encryptedEncodedKey = (String)keyWrapMap.get(LOCAL_WRAP_ENCRYPTED_KEY_FIELD);
            String masterKeyVersion = (String)keyWrapMap.get(LOCAL_WRAP_KEY_VERSION_FIELD);
            return new LocalKeyWrap(masterKeyVersion, encryptedEncodedKey);
        }

        private String getMasterKeyVersion() {
            return this.masterKeyVersion;
        }

        private String getEncryptedKey() {
            return this.encryptedEncodedKey;
        }
    }
}

